/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.giftsofgiving.block;

import com.nyfaria.giftsofgiving.block.entity.PresentBlockEntity;
import com.nyfaria.giftsofgiving.init.BlockInit;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5558;
import net.minecraft.class_8567;

public class PresentBlock
extends class_2237 {
    private static final class_265 UP_OPEN_AABB = class_259.method_1072((class_265)class_259.method_1073(), (class_265)class_259.method_1081((double)0.21875, (double)0.0, (double)0.21875, (double)0.78125, (double)0.5625, (double)0.78125), (class_247)class_247.field_1366);
    public static final class_2754<class_2350> FACING = class_2318.field_10927;
    public static final class_2960 CONTENTS = new class_2960("contents");
    @Nullable
    private final class_1767 color;

    public PresentBlock(@Nullable class_1767 pColor, class_4970.class_2251 pProperties) {
        super(pProperties);
        this.color = pColor;
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11036));
    }

    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return new PresentBlockEntity(this.color, pPos, pState);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 pLevel, class_2680 pState, class_2591<T> pBlockEntityType) {
        return PresentBlock.method_31618(pBlockEntityType, BlockInit.PRESENT_BLOCK_ENTITY.get(), PresentBlockEntity::tick);
    }

    public class_2464 method_9604(class_2680 pState) {
        return class_2464.field_11458;
    }

    public class_1269 method_9534(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_1268 pHand, class_3965 pHit) {
        if (pLevel.field_9236) {
            return class_1269.field_5812;
        }
        if (pPlayer.method_7325()) {
            return class_1269.field_21466;
        }
        class_2586 blockentity = pLevel.method_8321(pPos);
        if (blockentity instanceof PresentBlockEntity) {
            PresentBlockEntity presentboxblockentity = (PresentBlockEntity)blockentity;
            if (PresentBlock.canOpen(pPlayer, presentboxblockentity)) {
                pPlayer.method_17355((class_3908)presentboxblockentity);
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    private static boolean canOpen(class_1657 player, PresentBlockEntity pBlockEntity) {
        boolean isGiftGiver = pBlockEntity.isGiftGiver(player);
        String name = player.method_5476().getString();
        String giveeName = pBlockEntity.method_5476().getString();
        boolean isGiftee = Objects.equals(name, giveeName);
        boolean closed = pBlockEntity.isClosed();
        return (isGiftGiver || isGiftee) && closed;
    }

    public class_2680 method_9605(class_1750 pContext) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)pContext.method_8038());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        pBuilder.method_11667(new class_2769[]{FACING});
    }

    public void method_9576(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1657 pPlayer) {
        class_2586 blockentity = pLevel.method_8321(pPos);
        if (blockentity instanceof PresentBlockEntity) {
            PresentBlockEntity presentboxblockentity = (PresentBlockEntity)blockentity;
            if (!pLevel.field_9236 && pPlayer.method_7337() && !presentboxblockentity.method_5442()) {
                class_1799 itemstack = PresentBlock.getColoredItemStack(this.getColor());
                blockentity.method_38240(itemstack);
                if (presentboxblockentity.method_16914()) {
                    itemstack.method_7977(presentboxblockentity.method_5797());
                }
                class_1542 itementity = new class_1542(pLevel, (double)pPos.method_10263() + 0.5, (double)pPos.method_10264() + 0.5, (double)pPos.method_10260() + 0.5, itemstack);
                itementity.method_6988();
                pLevel.method_8649((class_1297)itementity);
            } else {
                presentboxblockentity.method_11289(pPlayer);
            }
        }
        super.method_9576(pLevel, pPos, pState, pPlayer);
    }

    public List<class_1799> method_9560(class_2680 pState, class_8567.class_8568 pParams) {
        class_2586 blockentity = (class_2586)pParams.method_51876(class_181.field_1228);
        if (blockentity instanceof PresentBlockEntity) {
            PresentBlockEntity presentboxblockentity = (PresentBlockEntity)blockentity;
            pParams = pParams.method_51872(CONTENTS, p_56219_ -> {
                for (int i = 0; i < presentboxblockentity.method_5439(); ++i) {
                    p_56219_.accept(presentboxblockentity.method_5438(i));
                }
            });
        }
        return super.method_9560(pState, pParams);
    }

    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        class_2586 blockentity = pLevel.method_8321(pPos);
        if (blockentity instanceof PresentBlockEntity) {
            if (pStack.method_7938()) {
                ((PresentBlockEntity)blockentity).method_17488(pStack.method_7964());
            }
            ((PresentBlockEntity)blockentity).setGiftGiver((class_1657)pPlacer);
        }
    }

    public void method_9536(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pNewState, boolean pIsMoving) {
        if (!pState.method_27852(pNewState.method_26204())) {
            class_2586 blockentity = pLevel.method_8321(pPos);
            if (blockentity instanceof PresentBlockEntity) {
                pLevel.method_8455(pPos, pState.method_26204());
            }
            super.method_9536(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public void method_9568(class_1799 pStack, @Nullable class_1922 pLevel, List<class_2561> pTooltip, class_1836 pFlag) {
        super.method_9568(pStack, pLevel, pTooltip, pFlag);
        class_2487 compoundtag = class_1747.method_38072((class_1799)pStack);
        if (compoundtag != null) {
            if (compoundtag.method_10573("LootTable", 8)) {
                pTooltip.add((class_2561)class_2561.method_43470((String)"???????"));
            }
            if (compoundtag.method_10573("Items", 9)) {
                class_2371 nonnulllist = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
                class_1262.method_5429((class_2487)compoundtag, (class_2371)nonnulllist);
                int i = 0;
                int j = 0;
                for (class_1799 itemstack : nonnulllist) {
                    if (itemstack.method_7960()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    class_5250 mutablecomponent = itemstack.method_7964().method_27661();
                    mutablecomponent.method_27693(" x").method_27693(String.valueOf(itemstack.method_7947()));
                    pTooltip.add((class_2561)mutablecomponent);
                }
                if (j - i > 0) {
                    pTooltip.add((class_2561)class_2561.method_43469((String)"container.presentBox.more", (Object[])new Object[]{j - i}).method_27692(class_124.field_1056));
                }
            }
        }
    }

    public class_265 method_25959(class_2680 pState, class_1922 pLevel, class_2338 pPos) {
        return UP_OPEN_AABB;
    }

    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return UP_OPEN_AABB;
    }

    public class_1799 method_9574(class_1922 pLevel, class_2338 pPos, class_2680 pState) {
        class_1799 itemstack = super.method_9574(pLevel, pPos, pState);
        pLevel.method_8321(pPos).method_38240(itemstack);
        return itemstack;
    }

    @Nullable
    public static class_1767 getColorFromItem(class_1792 pItem) {
        return PresentBlock.getColorFromBlock(class_2248.method_9503((class_1792)pItem));
    }

    @Nullable
    public static class_1767 getColorFromBlock(class_2248 pBlock) {
        return pBlock instanceof PresentBlock ? ((PresentBlock)pBlock).getColor() : null;
    }

    public static class_2248 getBlockByColor(@Nullable class_1767 pColor) {
        return switch (pColor) {
            case class_1767.field_7945 -> BlockInit.PURPLE_PRESENT.get();
            case class_1767.field_7946 -> BlockInit.ORANGE_PRESENT.get();
            case class_1767.field_7958 -> BlockInit.MAGENTA_PRESENT.get();
            case class_1767.field_7951 -> BlockInit.LIGHT_BLUE_PRESENT.get();
            case class_1767.field_7947 -> BlockInit.YELLOW_PRESENT.get();
            case class_1767.field_7961 -> BlockInit.LIME_PRESENT.get();
            case class_1767.field_7954 -> BlockInit.PINK_PRESENT.get();
            case class_1767.field_7944 -> BlockInit.GRAY_PRESENT.get();
            case class_1767.field_7967 -> BlockInit.LIGHT_GRAY_PRESENT.get();
            case class_1767.field_7955 -> BlockInit.CYAN_PRESENT.get();
            case class_1767.field_7966 -> BlockInit.BLUE_PRESENT.get();
            case class_1767.field_7957 -> BlockInit.BROWN_PRESENT.get();
            case class_1767.field_7942 -> BlockInit.GREEN_PRESENT.get();
            case class_1767.field_7964 -> BlockInit.RED_PRESENT.get();
            case class_1767.field_7963 -> BlockInit.BLACK_PRESENT.get();
            default -> BlockInit.WHITE_PRESENT.get();
        };
    }

    @Nullable
    public class_1767 getColor() {
        return this.color;
    }

    public static class_1799 getColoredItemStack(@Nullable class_1767 pColor) {
        return new class_1799((class_1935)PresentBlock.getBlockByColor(pColor));
    }

    public class_2680 method_9598(class_2680 pState, class_2470 pRot) {
        return (class_2680)pState.method_11657(FACING, (Comparable)pRot.method_10503((class_2350)pState.method_11654(FACING)));
    }

    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return pState.method_26186(pMirror.method_10345((class_2350)pState.method_11654(FACING)));
    }
}

