/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.giftsofgiving.block.entity;

import com.nyfaria.giftsofgiving.block.PresentBlock;
import com.nyfaria.giftsofgiving.block.entity.menu.PresentBoxMenu;
import com.nyfaria.giftsofgiving.init.BlockInit;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class PresentBlockEntity
extends class_2621
implements class_1278 {
    public static final int COLUMNS = 9;
    public static final int ROWS = 3;
    public static final int CONTAINER_SIZE = 27;
    public static final int EVENT_SET_OPEN_COUNT = 1;
    public static final int OPENING_TICK_LENGTH = 10;
    public static final float MAX_LID_HEIGHT = 0.5f;
    public static final float MAX_LID_ROTATION = 270.0f;
    public static final String ITEMS_TAG = "Items";
    private static final int[] SLOTS = IntStream.range(0, 27).toArray();
    private class_2371<class_1799> itemStacks = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    private int openCount;
    private AnimationStatus animationStatus = AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;
    @javax.annotation.Nullable
    private final class_1767 color;
    private UUID giftGiver;
    private class_2561 giftGiverName;
    private boolean locked;

    public PresentBlockEntity(@javax.annotation.Nullable class_1767 pColor, class_2338 pPos, class_2680 pBlockState) {
        super(BlockInit.PRESENT_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.color = pColor;
    }

    public PresentBlockEntity(class_2338 pPos, class_2680 pBlockState) {
        super(BlockInit.PRESENT_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.color = PresentBlock.getColorFromBlock(pBlockState.method_26204());
    }

    public static void tick(class_1937 pLevel, class_2338 pPos, class_2680 pState, PresentBlockEntity pBlockEntity) {
        pBlockEntity.updateAnimation(pLevel, pPos, pState);
    }

    private void updateAnimation(class_1937 pLevel, class_2338 pPos, class_2680 pState) {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (this.progress >= 1.0f) {
                    this.animationStatus = AnimationStatus.OPENED;
                    this.progress = 1.0f;
                    PresentBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
                }
                this.moveCollidedEntities(pLevel, pPos, pState);
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = AnimationStatus.CLOSED;
                this.progress = 0.0f;
                PresentBlockEntity.doNeighborUpdates(pLevel, pPos, pState);
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
            }
        }
    }

    public AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    private void moveCollidedEntities(class_1937 pLevel, class_2338 pPos, class_2680 pState) {
    }

    public int method_5439() {
        return this.itemStacks.size();
    }

    public boolean method_11004(int pId, int pType) {
        if (pId == 1) {
            this.openCount = pType;
            if (pType == 0) {
                this.animationStatus = AnimationStatus.CLOSING;
                PresentBlockEntity.doNeighborUpdates(this.method_10997(), this.field_11867, this.method_11010());
            }
            if (pType == 1) {
                this.animationStatus = AnimationStatus.OPENING;
                PresentBlockEntity.doNeighborUpdates(this.method_10997(), this.field_11867, this.method_11010());
            }
            return true;
        }
        return super.method_11004(pId, pType);
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        this.method_11007(tag);
        return tag;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    private static void doNeighborUpdates(class_1937 pLevel, class_2338 pPos, class_2680 pState) {
        pState.method_30101((class_1936)pLevel, pPos, 3);
    }

    public void method_5435(class_1657 pPlayer) {
        if (!this.field_11865 && !pPlayer.method_7325()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            this.field_11863.method_8427(this.field_11867, this.method_11010().method_26204(), 1, this.openCount);
            if (this.openCount == 1) {
                this.field_11863.method_33596((class_1297)pPlayer, class_5712.field_28176, this.field_11867);
                this.field_11863.method_8396((class_1657)null, this.field_11867, class_3417.field_14825, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
            }
        }
    }

    public void method_5432(class_1657 pPlayer) {
        if (!this.field_11865 && !pPlayer.method_7325()) {
            --this.openCount;
            this.field_11863.method_8427(this.field_11867, this.method_11010().method_26204(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.field_11863.method_33596((class_1297)pPlayer, class_5712.field_28177, this.field_11867);
                this.field_11863.method_8396((class_1657)null, this.field_11867, class_3417.field_14751, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
            }
        }
    }

    public void method_11014(class_2487 pTag) {
        super.method_11014(pTag);
        this.loadFromTag(pTag);
    }

    protected void method_11007(class_2487 pTag) {
        super.method_11007(pTag);
        if (!this.method_11286(pTag)) {
            class_1262.method_5427((class_2487)pTag, this.itemStacks, (boolean)false);
            if (this.itemStacks.stream().filter(is -> !is.method_7960()).count() > 0L) {
                pTag.method_10556("PreventRenameGiftForTheft", true);
            }
        }
        if (this.giftGiver != null) {
            pTag.method_25927("GiftGiver", this.giftGiver);
        }
        if (this.giftGiverName != null) {
            pTag.method_10582("GiverName", class_2561.class_2562.method_10867((class_2561)this.giftGiverName));
        }
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"giftsofgiving.container.present");
    }

    public void loadFromTag(class_2487 pTag) {
        this.itemStacks = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_11283(pTag) && pTag.method_10573(ITEMS_TAG, 9)) {
            class_1262.method_5429((class_2487)pTag, this.itemStacks);
        }
        if (pTag.method_10545("GiftGiver")) {
            this.giftGiver = pTag.method_25926("GiftGiver");
        }
        if (pTag.method_10573("GiverName", 8)) {
            this.giftGiverName = class_2561.class_2562.method_10877((String)pTag.method_10558("GiverName"));
        }
    }

    protected class_2371<class_1799> method_11282() {
        return this.itemStacks;
    }

    protected void method_11281(class_2371<class_1799> pItems) {
        this.itemStacks = pItems;
    }

    public int[] method_5494(class_2350 pSide) {
        return new int[0];
    }

    public boolean method_5492(int pIndex, class_1799 pItemStack, @javax.annotation.Nullable class_2350 pDirection) {
        return false;
    }

    public boolean method_5493(int pIndex, class_1799 pStack, class_2350 pDirection) {
        return false;
    }

    public float getProgress(float pPartialTicks) {
        return class_3532.method_16439((float)pPartialTicks, (float)this.progressOld, (float)this.progress);
    }

    @javax.annotation.Nullable
    public class_1767 getColor() {
        return this.color;
    }

    public boolean isGiftGiver(class_1657 player) {
        return player.method_5667().equals(this.giftGiver);
    }

    public void setGiftGiver(class_1657 giftGiver) {
        this.giftGiver = giftGiver.method_5667();
        this.giftGiverName = giftGiver.method_5476();
    }

    public class_2561 getGiftGiverName() {
        return this.giftGiverName;
    }

    protected class_1703 method_5465(int pId, class_1661 pPlayer) {
        PresentBoxMenu menu = new PresentBoxMenu(pId, pPlayer, (class_1263)this);
        menu.setGifter(this.giftGiverName);
        menu.setGiftee(this.method_5476());
        return menu;
    }

    public boolean isClosed() {
        return this.animationStatus == AnimationStatus.CLOSED;
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

