/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsmultiloader.registration.fabric;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.nyfaria.nyfsmultiloader.registration.registries.DatapackRegistry;
import com.nyfaria.nyfsmultiloader.registration.registries.DatapackRegistryBuilder;
import com.nyfaria.nyfsmultiloader.registration.registries.DatapackRegistryBuilder$;
import com.nyfaria.nyfsmultiloader.registration.util.DatapackRegistryGenerator;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7655;
import net.minecraft.class_7782;
import net.minecraft.class_7877;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

@ParametersAreNonnullByDefault
public class FabricDatapackRegistryBuilder<T>
implements DatapackRegistryBuilder<T> {
    private static final Unsafe UNSAFE;
    private static final MethodHandles.Lookup IMPL_LOOKUP;
    private static final Field WORLDGEN_REGISTRIES;
    private static final Field NETWORKABLE_REGISTRIES;
    private static final long offset$WORLDGEN_REGISTRIES;
    private static final long offset$NETWORKABLE_REGISTRIES;
    private static final MethodHandle new$NetworkedRegistryData;
    public static final Set<class_2960> OWNED_REGISTRIES;
    private final class_5321<class_2378<T>> key;
    private Codec<T> elementCodec;
    @Nullable
    private Codec<T> networkCodec;
    @Nullable
    private class_7877.class_7882<T> bootstrap;

    private FabricDatapackRegistryBuilder(class_5321<class_2378<T>> key) {
        this.key = Objects.requireNonNull(key, "registry key must not be null");
    }

    @Override
    public DatapackRegistryBuilder<T> withElementCodec(@NotNull Codec<T> codec) {
        this.elementCodec = Objects.requireNonNull(codec, "element codec must not be null");
        return this;
    }

    @Override
    public DatapackRegistryBuilder<T> withNetworkCodec(@Nullable Codec<T> codec) {
        this.networkCodec = codec;
        return this;
    }

    @Override
    public DatapackRegistryBuilder<T> withBootstrap(@Nullable class_7877.class_7882<T> bootstrap) {
        this.bootstrap = bootstrap;
        return this;
    }

    @Override
    public DatapackRegistry<T> build() {
        Objects.requireNonNull(this.elementCodec, "element codec must not be null");
        OWNED_REGISTRIES.add(this.key.method_29177());
        try {
            ArrayList<class_7655.class_7657> mutableCopy = new ArrayList<class_7655.class_7657>(class_7655.field_39968);
            mutableCopy.add(new class_7655.class_7657(this.key, this.elementCodec));
            UNSAFE.putObject(class_7655.class, offset$WORLDGEN_REGISTRIES, List.copyOf(mutableCopy));
            if (this.networkCodec != null) {
                Object data = new$NetworkedRegistryData.invoke(this.key, this.networkCodec);
                Map registries = (Map)UNSAFE.getObject(class_7782.class, offset$NETWORKABLE_REGISTRIES);
                if (registries == null) {
                    UNSAFE.allocateInstance(class_7782.class);
                    registries = (Map)UNSAFE.getObject(class_7782.class, offset$NETWORKABLE_REGISTRIES);
                }
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.putAll(registries);
                builder.put(this.key, data);
                UNSAFE.putObject(class_7782.class, offset$NETWORKABLE_REGISTRIES, builder.build());
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Could not register datapack registry: ", throwable);
        }
        return new DatapackRegistry<T>(){

            @Override
            public class_5321<class_2378<T>> key() {
                return FabricDatapackRegistryBuilder.this.key;
            }

            @Override
            public class_2405.class_7857<class_2405> bootstrapDataGenerator(CompletableFuture<class_7225.class_7874> lookupProvider) {
                return packOutput -> new DatapackRegistryGenerator(packOutput, lookupProvider, registryData -> registryData.comp_985() == this.key());
            }

            @Override
            public void addToSet(class_7877 builder) {
                builder.method_46777(FabricDatapackRegistryBuilder.this.key, FabricDatapackRegistryBuilder.this.bootstrap == null ? ctx -> {} : FabricDatapackRegistryBuilder.this.bootstrap);
            }

            @Override
            public class_2378<T> get(class_5455 registryAccess) {
                return registryAccess.method_30530(FabricDatapackRegistryBuilder.this.key);
            }
        };
    }

    private static Object getStaticOrNull(Field field) {
        try {
            return field.get(null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    static {
        OWNED_REGISTRIES = new HashSet<class_2960>();
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
            IMPL_LOOKUP = (MethodHandles.Lookup)UNSAFE.getObject(MethodHandles.Lookup.class, UNSAFE.staticFieldOffset(MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP")));
            WORLDGEN_REGISTRIES = Stream.of(class_7655.class.getDeclaredFields()).filter(fld -> Modifier.isStatic(fld.getModifiers()) && fld.getType() == List.class).filter(fld -> FabricDatapackRegistryBuilder.getStaticOrNull(fld) == class_7655.field_39968).findFirst().orElseThrow();
            offset$WORLDGEN_REGISTRIES = UNSAFE.staticFieldOffset(WORLDGEN_REGISTRIES);
            NETWORKABLE_REGISTRIES = Stream.of(class_7782.class.getDeclaredFields()).filter(it -> it.getType() == Map.class).findFirst().orElseThrow();
            offset$NETWORKABLE_REGISTRIES = UNSAFE.staticFieldOffset(NETWORKABLE_REGISTRIES);
            Class networkedRegistryData = Stream.of(class_7782.class.getDeclaredClasses()).filter(Class::isRecord).findFirst().orElseThrow();
            new$NetworkedRegistryData = IMPL_LOOKUP.findConstructor(networkedRegistryData, MethodType.methodType(Void.TYPE, class_5321.class, Codec.class));
        }
        catch (Exception ex) {
            throw new RuntimeException("Barf!", ex);
        }
    }

    @AutoService(value={DatapackRegistryBuilder$.Factory.class})
    public static final class Factory
    implements DatapackRegistryBuilder$.Factory {
        @Override
        public <T> DatapackRegistryBuilder<T> newBuilder(class_5321<class_2378<T>> key) {
            return new FabricDatapackRegistryBuilder<T>(key);
        }
    }
}

