/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.core.ModEntities;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.trades.EntityTrades;
import com.mrcrayfish.goblintraders.trades.IRaritySettings;
import com.mrcrayfish.goblintraders.trades.TradeManager;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.util.Utils;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3853;

public class VeinGoblinTrader
extends AbstractGoblinEntity {
    private static final class_2960 TEXTURE = Utils.resource("textures/entity/vein_goblin_trader.png");

    public VeinGoblinTrader(class_1937 level) {
        super((class_1299<? extends TraderCreatureEntity>)((class_1299)ModEntities.VEIN_GOBLIN_TRADER.get()), level);
    }

    @Override
    public class_2960 getTexture() {
        return TEXTURE;
    }

    @Override
    protected void populateTradeData() {
        class_1916 offers = this.method_8264();
        EntityTrades entityTrades = TradeManager.instance().getTrades((class_1299<? extends TraderCreatureEntity>)((class_1299)ModEntities.VEIN_GOBLIN_TRADER.get()));
        if (entityTrades != null) {
            Map<TradeRarity, List<class_3853.class_1652>> tradeMap = entityTrades.getTradeMap();
            for (TradeRarity rarity : TradeRarity.values()) {
                IRaritySettings settings = Config.ENTITIES.veinGoblinTrader.trades.getSettings(rarity);
                if (settings.includeChance() <= 0.0 || settings.includeChance() < 1.0 && this.method_6051().method_43058() > settings.includeChance()) continue;
                List<class_3853.class_1652> trades = tradeMap.get((Object)rarity);
                int min = Math.min(settings.getMinValue(), settings.getMaxValue());
                int max = Math.max(settings.getMinValue(), settings.getMaxValue());
                int count = min + this.method_6051().method_43048(max - min + 1);
                this.addTrades(offers, trades, count, rarity.shouldShuffle());
            }
        }
    }

    @Override
    public class_1799 getFavouriteFood() {
        return new class_1799((class_1935)class_1802.field_8179);
    }

    public void method_6007() {
        if (this.method_38069() && this.field_6012 % 2 == 0) {
            this.method_37908().method_8406((class_2394)class_2398.field_11240, this.method_23317() - 0.5 + this.method_6051().method_43058(), this.method_23318() + 0.5 - 0.5 + this.method_6051().method_43058(), this.method_23321() - 0.5 + this.method_6051().method_43058(), 0.0, 0.0, 0.0);
        }
        super.method_6007();
    }

    public boolean method_5753() {
        return true;
    }

    @Override
    protected int getMaxRestockDelay() {
        return (Integer)Config.ENTITIES.veinGoblinTrader.restockDelay.get();
    }

    @Override
    public boolean canAttackBack() {
        return (Boolean)Config.ENTITIES.veinGoblinTrader.canAttackBack.get();
    }

    public int method_5970() {
        return (Integer)Config.ENTITIES.veinGoblinTrader.gruntNoiseInterval.get();
    }
}

