/*
 * Decompiled with CFR 0.152.
 */
package de.mschae23.grindenchantments.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public final class GrindstoneEvents {
    public static final Event<CanInsert> CAN_INSERT = EventFactory.createArrayBacked(CanInsert.class, callbacks -> (stack, other, slotId) -> {
        for (CanInsert callback : callbacks) {
            if (!callback.canInsert(stack, other, slotId)) continue;
            return true;
        }
        return false;
    });
    public static final Event<UpdateResult> UPDATE_RESULT = EventFactory.createArrayBacked(UpdateResult.class, callbacks -> (input1, input2, player) -> {
        for (UpdateResult callback : callbacks) {
            class_1799 result = callback.onUpdateResult(input1, input2, player);
            if (result == null) continue;
            return result;
        }
        return null;
    });
    public static final Event<CanTakeResult> CAN_TAKE_RESULT = EventFactory.createArrayBacked(CanTakeResult.class, callbacks -> (input1, input2, player) -> {
        for (CanTakeResult callback : callbacks) {
            if (callback.canTakeResult(input1, input2, player)) continue;
            return false;
        }
        return true;
    });
    public static final Event<TakeResult> TAKE_RESULT = EventFactory.createArrayBacked(TakeResult.class, callbacks -> (input1, input2, resultStack, player, input) -> {
        for (TakeResult callback : callbacks) {
            if (!callback.onTakeResult(input1, input2, resultStack, player, input)) continue;
            return true;
        }
        return false;
    });
    public static final Event<LevelCost> LEVEL_COST = EventFactory.createArrayBacked(LevelCost.class, callbacks -> (input1, input2, player) -> {
        for (LevelCost callback : callbacks) {
            int cost = callback.getLevelCost(input1, input2, player);
            if (cost == -1) continue;
            return cost;
        }
        return -1;
    });

    private GrindstoneEvents() {
    }

    public static <T extends CanInsert & UpdateResult & TakeResult> void registerAll(T listener) {
        CAN_INSERT.register(listener);
        UPDATE_RESULT.register((Object)listener);
        CAN_TAKE_RESULT.register((Object)((CanTakeResult)listener));
        TAKE_RESULT.register((Object)listener);
        LEVEL_COST.register((Object)((LevelCost)listener));
    }

    public static interface UpdateResult {
        @Nullable
        public class_1799 onUpdateResult(class_1799 var1, class_1799 var2, class_1657 var3);
    }

    public static interface CanTakeResult {
        public boolean canTakeResult(class_1799 var1, class_1799 var2, class_1657 var3);
    }

    public static interface TakeResult {
        public boolean onTakeResult(class_1799 var1, class_1799 var2, class_1799 var3, class_1657 var4, class_1263 var5);
    }

    public static interface LevelCost {
        public int getLevelCost(class_1799 var1, class_1799 var2, class_1657 var3);
    }

    public static interface CanInsert {
        public boolean canInsert(class_1799 var1, class_1799 var2, int var3);
    }
}

