/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.harvest_with_ease.api.event;

import it.crystalnest.harvest_with_ease.api.event.HarvestEvent;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class HarvestEvents {
    public static final class_2960 PRIORITY_PHASE = new class_2960("harvest_with_ease", "priority");
    public static final class_2960 DEFERRED_PHASE = new class_2960("harvest_with_ease", "deferred");
    public static final Event<HarvestCheck> CHECK = EventFactory.createArrayBacked(HarvestCheck.class, listeners -> event -> {
        for (HarvestCheck listener : listeners) {
            if (listener.check(event)) continue;
            return false;
        }
        return true;
    });
    public static final Event<BeforeHarvest> BEFORE = EventFactory.createWithPhases(BeforeHarvest.class, listeners -> event -> {
        for (BeforeHarvest listener : listeners) {
            listener.beforeHarvest(event);
        }
    }, (class_2960[])new class_2960[]{PRIORITY_PHASE, Event.DEFAULT_PHASE, DEFERRED_PHASE});
    public static final Event<HarvestDrops> DROPS = EventFactory.createWithPhases(HarvestDrops.class, listeners -> event -> {
        for (HarvestDrops listener : listeners) {
            event.setDrops(listener.getResult(event).getDrops());
            if (!event.canceled) continue;
            return event;
        }
        return event;
    }, (class_2960[])new class_2960[]{PRIORITY_PHASE, Event.DEFAULT_PHASE, DEFERRED_PHASE});
    public static final Event<AfterHarvest> AFTER = EventFactory.createWithPhases(AfterHarvest.class, listeners -> event -> {
        for (AfterHarvest listener : listeners) {
            listener.afterHarvest(event);
        }
    }, (class_2960[])new class_2960[]{PRIORITY_PHASE, Event.DEFAULT_PHASE, DEFERRED_PHASE});

    private HarvestEvents() {
    }

    @FunctionalInterface
    public static interface AfterHarvest {
        public void afterHarvest(AfterHarvestEvent var1);
    }

    public static class AfterHarvestEvent
    extends FabricHarvestEvent<class_3222, class_3218>
    implements HarvestEvent.AfterHarvestEvent {
        AfterHarvestEvent(class_3218 level, class_2680 crop, class_2338 pos, class_2350 face, @Nullable class_3965 hitResult, class_3222 entity, class_1268 hand) {
            super(level, crop, pos, face, hitResult, entity, hand);
        }
    }

    @FunctionalInterface
    public static interface HarvestDrops {
        public HarvestDropsEvent getResult(HarvestDropsEvent var1);
    }

    public static class HarvestDropsEvent
    extends FabricHarvestEvent<class_3222, class_3218>
    implements HarvestEvent.HarvestDropsEvent {
        private final List<class_1799> defaultDrops;
        private List<class_1799> drops;
        private boolean canceled;

        HarvestDropsEvent(class_3218 level, class_2680 crop, class_2338 pos, class_2350 face, @Nullable class_3965 hitResult, class_3222 entity, class_1268 hand) {
            super(level, crop, pos, face, hitResult, entity, hand);
            this.defaultDrops = this.initDefaultDrops(level, crop, pos, hand);
            this.drops = new ArrayList<class_1799>(this.defaultDrops.stream().map(class_1799::method_7972).toList());
        }

        @Override
        public List<class_1799> getDefaultDrops() {
            return this.defaultDrops;
        }

        @Override
        public List<class_1799> getDrops() {
            return this.drops;
        }

        @Override
        @ApiStatus.Internal
        public void setDrops(List<class_1799> drops) {
            this.drops = drops;
        }

        @Override
        public void cancel() {
            this.canceled = true;
        }
    }

    @FunctionalInterface
    public static interface BeforeHarvest {
        public void beforeHarvest(BeforeHarvestEvent var1);
    }

    public static class BeforeHarvestEvent
    extends FabricHarvestEvent<class_3222, class_3218>
    implements HarvestEvent.BeforeHarvestEvent {
        BeforeHarvestEvent(class_3218 level, class_2680 crop, class_2338 pos, class_2350 face, @Nullable class_3965 hitResult, class_3222 entity, class_1268 hand) {
            super(level, crop, pos, face, hitResult, entity, hand);
        }
    }

    @FunctionalInterface
    public static interface HarvestCheck {
        public boolean check(HarvestCheckEvent var1);
    }

    public static class HarvestCheckEvent
    extends FabricHarvestEvent<class_1657, class_1937>
    implements HarvestEvent.HarvestCheckEvent {
        private boolean canHarvest = true;

        HarvestCheckEvent(class_1937 level, class_2680 crop, class_2338 pos, class_2350 face, @Nullable class_3965 hitResult, class_1657 entity, class_1268 hand) {
            super(level, crop, pos, face, hitResult, entity, hand);
        }

        @Override
        public boolean canHarvest() {
            return this.canHarvest;
        }

        @Override
        @ApiStatus.Internal
        public void preventHarvest() {
            this.canHarvest = false;
        }
    }

    public static abstract class FabricHarvestEvent<P extends class_1657, L extends class_1937>
    implements HarvestEvent<P, L> {
        protected final L level;
        protected final class_2680 crop;
        protected final class_2338 pos;
        protected final class_2350 face;
        @Nullable
        protected final class_3965 hitResult;
        protected final P entity;
        protected final class_1268 hand;

        protected FabricHarvestEvent(L level, class_2680 crop, class_2338 pos, class_2350 face, @Nullable class_3965 hitResult, P entity, class_1268 hand) {
            this.level = level;
            this.crop = crop;
            this.pos = pos;
            this.face = face;
            this.hitResult = hitResult;
            this.entity = entity;
            this.hand = hand;
        }

        @Override
        public P getEntity() {
            return this.entity;
        }

        @Override
        public L getLevel() {
            return this.level;
        }

        @Override
        public class_2680 getCrop() {
            return this.crop;
        }

        @Override
        public class_2338 getPos() {
            return this.pos;
        }

        @Override
        public class_2350 getFace() {
            return this.face;
        }

        @Override
        @Nullable
        public class_3965 getHitResult() {
            return this.hitResult;
        }

        @Override
        public class_1268 getHand() {
            return this.hand;
        }
    }
}

