/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.harvest_with_ease.config;

import it.crystalnest.cobweb.api.config.CommonConfig;
import it.crystalnest.cobweb.api.item.TierUtils;
import it.crystalnest.harvest_with_ease.config.AreaSize;
import it.crystalnest.harvest_with_ease.config.AreaStep;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1834;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ModConfig
extends CommonConfig {
    public static final ModConfig CONFIG = (ModConfig)ModConfig.register((String)"harvest_with_ease", ModConfig::new);
    private ForgeConfigSpec.ConfigValue<List<? extends String>> crops;
    private ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
    private ForgeConfigSpec.BooleanValue requireHoe;
    private ForgeConfigSpec.IntValue damageOnHarvest;
    private ForgeConfigSpec.DoubleValue exhaustionMultiplier;
    private ForgeConfigSpec.IntValue grantedExp;
    private ForgeConfigSpec.BooleanValue gatherDrops;
    private ForgeConfigSpec.ConfigValue<String> multiHarvestStartingTier;
    private ForgeConfigSpec.EnumValue<AreaSize> areaStartingSize;
    private ForgeConfigSpec.EnumValue<AreaStep> areaIncrementStep;

    private ModConfig(ForgeConfigSpec.Builder builder) {
        super(builder);
    }

    public static List<? extends String> getCrops() {
        return (List)ModConfig.CONFIG.crops.get();
    }

    public static List<? extends String> getBlacklist() {
        return (List)ModConfig.CONFIG.blacklist.get();
    }

    public static Boolean getRequireHoe() {
        return (Boolean)ModConfig.CONFIG.requireHoe.get();
    }

    public static Integer getDamageOnHarvest() {
        return (Integer)ModConfig.CONFIG.damageOnHarvest.get();
    }

    public static BigDecimal getExhaustionMultiplier() {
        return BigDecimal.valueOf((Double)ModConfig.CONFIG.exhaustionMultiplier.get()).setScale(2, RoundingMode.HALF_UP);
    }

    public static Integer getGrantedExp() {
        return (Integer)ModConfig.CONFIG.grantedExp.get();
    }

    public static Boolean getGatherDrops() {
        return (Boolean)ModConfig.CONFIG.gatherDrops.get();
    }

    public static String getMultiHarvestStartingTier() {
        return (String)ModConfig.CONFIG.multiHarvestStartingTier.get();
    }

    public static AreaSize getAreaStartingSize() {
        return (AreaSize)((Object)ModConfig.CONFIG.areaStartingSize.get());
    }

    public static AreaStep getAreaIncrementStep() {
        return (AreaStep)((Object)ModConfig.CONFIG.areaIncrementStep.get());
    }

    private static String[] getAreaSizeComments() {
        AreaSize[] sizes = AreaSize.values();
        String[] comments = new String[3 + sizes.length];
        comments[0] = " Starting multi-harvest area size (square side length).";
        comments[1] = " The area is always a square centered on the right-clicked crop.";
        comments[2] = " Setting this to \"" + AreaSize.SINGLE + "\" and [area increment step] to \"" + AreaStep.NONE + "\" will effectively disable multi-harvest.";
        for (int i = 0; i < sizes.length; ++i) {
            comments[i + 3] = " \"" + sizes[i] + "\" - " + sizes[i] + " harvest area size, a " + sizes[i].size + "x" + sizes[i].size + " square.";
        }
        return comments;
    }

    private static String[] getAreaStepComments() {
        AreaStep[] steps = AreaStep.values();
        String[] comments = new String[2 + steps.length];
        comments[0] = " Increment step for the harvest area size with higher tool tiers.";
        comments[1] = " Setting this to \"" + AreaStep.NONE + "\" and [starting harvest area size] to \"" + AreaSize.SINGLE + "\" will effectively disable multi-harvest.";
        comments[2] = " \"" + steps[0] + "\" - no increment, the area stays the same (as defined by [starting harvest area size]) regardless of the tool used, if any.";
        for (int i = 1; i < steps.length; ++i) {
            comments[i + 2] = " \"" + steps[i] + "\" - " + steps[i] + " increment, the size of the area, starting from [starting harvest area size], increases by " + steps[i].step + " with each higher tier.E.g. 1x1 -> " + (1 + steps[i].step) + "x" + (1 + steps[i].step) + " -> " + (1 + steps[i].step * 2) + "x" + (1 + steps[i].step * 2) + " -> ...";
        }
        return comments;
    }

    protected void define(ForgeConfigSpec.Builder builder) {
        builder.comment(" Compatibility settings").push("compatibility");
        this.crops = builder.comment(" List of in-game IDs of additional crops that are not supported out of the box.").defineListAllowEmpty(List.of("crops"), () -> List.of("neapolitan:adzuki_sprouts"), x$0 -> this.stringListValidator(x$0));
        this.blacklist = builder.comment(" List of in-game IDs for crops that under no condition can be right-click harvested.").defineListAllowEmpty(List.of("blacklist"), Collections::emptyList, x$0 -> this.stringListValidator(x$0));
        this.requireHoe = builder.comment(" Require holding a hoe (either hands) to right-click harvest.").define("require hoe", false);
        this.damageOnHarvest = builder.comment(" If [require hoe] is set to true, damage the hoe of the given amount (0 to disable, must be an integer).").defineInRange("damage on harvest", 0, 0, Integer.MAX_VALUE);
        this.exhaustionMultiplier = builder.comment(new String[]{" Multiplier for the exhaustion caused when right-click harvesting (0 to disable, 1 for the same exhaustion regular block breaking causes).", " Testing is advised. Follow the table below for some approximate info (note that a player has up to 20 hunger points):", " Multiplier value | Hunger points per crop harvested | Crops required to deplete 1 hunger/saturation point", " 0.0                0                                  -", " 1.0                0.001                              800", " 5.0                0.006                              160", " 10.0               0.013                              80", " 50.0               0.063                              16", " 100.0              0.125                              8", " 200.0              0.25                               4", " 400.0              0.5                                2"}).defineInRange("exhaustion multiplier", 1.0, 0.0, 400.0);
        this.grantedExp = builder.comment(" Amount of experience points to grant on harvest (0 to disable, must be an integer).").defineInRange("exp on harvest", 0, 0, Integer.MAX_VALUE);
        this.gatherDrops = builder.comment(" Whether to gather drops near the player when harvesting.").define("gather drops", false);
        builder.pop();
        builder.comment("Multi-harvest settings").push("multiharvest");
        this.multiHarvestStartingTier = builder.comment(new String[]{" Tool tier starting from which it is possible to harvest multiple crops at once.", " All tiers that cannot multi-harvest will have a 1x1 square area of effect (a single crop).", " If [starting harvest area size] is set to \"" + AreaSize.SINGLE + "\" and [area increment step] to \"" + AreaStep.NONE + "\" multi-harvest will be effectively disabled, regardless of this config option value.", " From lesser to greater, Vanilla tiers are: " + String.join((CharSequence)", ", (CharSequence[])Stream.of(class_1834.values()).sorted(TierUtils::compare).map(tier -> "\"" + tier.toString().toLowerCase() + "\"").toArray(String[]::new)) + ".", " When set to \"none\", multi-harvest will be enabled without a tool too. Note that [require hoe] takes precedence.", " The tier can be specified with either the name of the tier, e.g. \"iron\", or the id of the tier, e.g. \"minecraft:iron\"."}).define("multi-harvest starting tier", (Object)class_1834.field_8922.toString().toLowerCase(), value -> {
            String string;
            return value instanceof String && ("none".equalsIgnoreCase(string = (String)value) || TierUtils.getAllTiers().isEmpty() || TierUtils.isIn((Collection)TierUtils.getAllTiers(), (String)string));
        });
        this.areaStartingSize = builder.comment(ModConfig.getAreaSizeComments()).defineEnum("starting harvest area size", (Enum)AreaSize.SINGLE, (Enum[])AreaSize.values());
        this.areaIncrementStep = builder.comment(ModConfig.getAreaStepComments()).defineEnum("area increment step", (Enum)AreaStep.NONE, (Enum[])AreaStep.values());
        builder.pop();
    }
}

