/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import immersive_aircraft.client.render.entity.renderer.utils.BBModelRenderer;
import immersive_aircraft.client.render.entity.renderer.utils.ModelPartRenderHandler;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.resources.BBModelLoader;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.resources.bbmodel.BBModel;
import immersive_aircraft.resources.bbmodel.BBObject;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

public abstract class VehicleEntityRenderer<T extends VehicleEntity>
extends class_897<T> {
    private static final class_2960 TEXTURE = new class_2960("invalid");

    public VehicleEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    protected abstract ModelPartRenderHandler<T> getModel(T var1);

    protected abstract class_2960 getModelId();

    public void render(T entity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        class_4587.class_4665 peek = matrixStack.method_23760();
        matrixStack.method_22903();
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-yaw));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(entity.method_5695(tickDelta)));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(((VehicleEntity)((Object)entity)).getRoll(tickDelta)));
        this.renderLocal(entity, yaw, tickDelta, matrixStack, peek, vertexConsumerProvider, light);
        matrixStack.method_22909();
        super.method_3936(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
    }

    public void renderLocal(T entity, float yaw, float tickDelta, class_4587 matrixStack, class_4587.class_4665 peek, class_4597 vertexConsumerProvider, int light) {
        float h = (float)((VehicleEntity)((Object)entity)).getDamageWobbleTicks() - tickDelta;
        float j = ((VehicleEntity)((Object)entity)).getDamageWobbleStrength() - tickDelta;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)h) * h * j / 10.0f * (float)((VehicleEntity)((Object)entity)).getDamageWobbleSide()));
        }
        float time = ((float)(entity.method_37908().method_8510() % 24000L) + tickDelta) / 20.0f;
        BBAnimationVariables.set("time", time);
        ((VehicleEntity)((Object)entity)).setAnimationVariables(tickDelta);
        BBModel bbModel = BBModelLoader.MODELS.get(this.getModelId());
        if (bbModel != null) {
            float health = ((VehicleEntity)((Object)entity)).getHealth();
            float r = health * 0.6f + 0.4f;
            float g = health * 0.4f + 0.6f;
            float b = health * 0.4f + 0.6f;
            BBModelRenderer.renderModel(bbModel, matrixStack, vertexConsumerProvider, light, time, entity, this.getModel(entity), r, g, b, 1.0f);
        }
    }

    public void renderOptionalObject(String name, BBModel model, class_4597 vertexConsumerProvider, T entity, class_4587 matrixStack, int light, float time) {
        this.renderOptionalObject(name, model, vertexConsumerProvider, entity, matrixStack, light, time, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderOptionalObject(String name, BBModel model, class_4597 vertexConsumerProvider, T entity, class_4587 matrixStack, int light, float time, float red, float green, float blue, float alpha) {
        BBObject object = model.objectsByName.get(name);
        if (object != null) {
            BBModelRenderer.renderObject(model, object, matrixStack, vertexConsumerProvider, light, time, entity, null, red, green, blue, alpha);
        }
    }

    public boolean shouldRender(T entity, class_4604 frustum, double x, double y, double z) {
        if (!entity.method_5727(x, y, z)) {
            return false;
        }
        class_238 box = ((VehicleEntity)((Object)entity)).method_5830().method_1014(this.getCullingBoundingBoxInflation());
        return frustum.method_23093(box);
    }

    protected double getCullingBoundingBoxInflation() {
        return 1.0;
    }

    public class_2960 getTextureLocation(@NotNull T aircraft) {
        return TEXTURE;
    }
}

