/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.book;

import com.google.common.base.Preconditions;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.book.BookLoader;
import io.wispforest.lavender.client.LavenderBookScreen;
import io.wispforest.owo.nbt.NbtKey;
import io.wispforest.owo.ops.TextOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LavenderBookItem
extends class_1792 {
    public static final NbtKey<class_2960> BOOK_ID = new NbtKey("BookId", NbtKey.Type.IDENTIFIER);
    public static final LavenderBookItem DYNAMIC_BOOK = new LavenderBookItem(null, new class_1792.class_1793().method_7889(1));
    private static final Map<class_2960, LavenderBookItem> BOOK_ITEMS = new HashMap<class_2960, LavenderBookItem>();
    @Nullable
    private final class_2960 bookId;

    private LavenderBookItem(@Nullable class_2960 bookId, class_1792.class_1793 settings) {
        super(settings);
        this.bookId = bookId;
    }

    protected LavenderBookItem(class_1792.class_1793 settings, @NotNull class_2960 bookId) {
        super(settings);
        this.bookId = (class_2960)Preconditions.checkNotNull((Object)bookId, (Object)"Book-specific book items must have a non-null book ID");
    }

    @NotNull
    protected class_2960 bookId() {
        return this.bookId;
    }

    public static LavenderBookItem registerForBook(@NotNull class_2960 bookId, class_1792.class_1793 settings) {
        return LavenderBookItem.registerForBook(bookId, bookId, settings);
    }

    public static LavenderBookItem registerForBook(@NotNull class_2960 bookId, @NotNull class_2960 itemId, class_1792.class_1793 settings) {
        return LavenderBookItem.registerForBook((LavenderBookItem)((Object)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)itemId, (Object)((Object)new LavenderBookItem(bookId, settings)))));
    }

    public static LavenderBookItem registerForBook(LavenderBookItem item) {
        BOOK_ITEMS.put(item.bookId(), item);
        return item;
    }

    @Nullable
    public static class_2960 bookIdOf(class_1799 bookStack) {
        class_1792 class_17922 = bookStack.method_7909();
        if (!(class_17922 instanceof LavenderBookItem)) {
            return null;
        }
        LavenderBookItem book = (LavenderBookItem)class_17922;
        return book.bookId != null ? book.bookId : (class_2960)bookStack.get(BOOK_ID);
    }

    @Nullable
    public static Book bookOf(class_1799 bookStack) {
        class_2960 bookId = LavenderBookItem.bookIdOf(bookStack);
        if (bookId == null) {
            return null;
        }
        return BookLoader.get(bookId);
    }

    public static class_1799 itemOf(Book book) {
        LavenderBookItem bookItem = BOOK_ITEMS.get(book.id());
        if (bookItem != null) {
            return bookItem.method_7854();
        }
        return LavenderBookItem.createDynamic(book);
    }

    public class_2561 method_7864(class_1799 stack) {
        if (this.bookId != null) {
            return super.method_7864(stack);
        }
        Book book = LavenderBookItem.bookOf(stack);
        if (book == null || book.dynamicBookName() == null) {
            return super.method_7864(stack);
        }
        return book.dynamicBookName();
    }

    public static class_1799 createDynamic(Book book) {
        class_1799 stack = DYNAMIC_BOOK.method_7854();
        stack.put(BOOK_ID, (Object)book.id());
        return stack;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 playerStack = user.method_5998(hand);
        class_2960 bookId = LavenderBookItem.bookIdOf(playerStack);
        if (bookId == null) {
            return class_1271.method_22430((Object)playerStack);
        }
        Book book = BookLoader.get(bookId);
        if (book == null) {
            Lavender.LOGGER.warn("Player {} tried to open unknown book with id '{}'", (Object)user.method_7334().getName(), (Object)bookId);
            return class_1271.method_22430((Object)playerStack);
        }
        if (!world.field_9236) {
            return class_1271.method_22427((Object)playerStack);
        }
        LavenderBookItem.openBookScreen(book);
        return class_1271.method_22427((Object)playerStack);
    }

    @Environment(value=EnvType.CLIENT)
    private static void openBookScreen(Book book) {
        class_310.method_1551().method_1507((class_437)new LavenderBookScreen(book));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        class_2960 bookId = LavenderBookItem.bookIdOf(stack);
        if (bookId == null) {
            tooltip.add((class_2561)TextOps.withFormatting((String)"\u26a0 \u00a7No associated book", (class_124[])new class_124[]{class_124.field_1061, class_124.field_1063}));
        } else {
            Book book = BookLoader.get(bookId);
            if (book != null) {
                return;
            }
            tooltip.add((class_2561)TextOps.withFormatting((String)("\u26a0 \u00a7Unknown book \"" + String.valueOf(bookId) + "\""), (class_124[])new class_124[]{class_124.field_1061, class_124.field_1063}));
        }
    }
}

