/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards;

import com.leclowndu93150.leaderboards.VanillaStatsRegistry;
import com.leclowndu93150.leaderboards.data.Leaderboard;
import com.leclowndu93150.leaderboards.data.PlayerDataTracker;
import com.leclowndu93150.leaderboards.data.PlayerStatsWrapper;
import com.leclowndu93150.leaderboards.integration.FTBQuestsIntegration;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3468;

public class LeaderboardRegistry {
    public static final Map<class_2960, Leaderboard> LEADERBOARDS = new LinkedHashMap<class_2960, Leaderboard>();

    public static void register() {
        LEADERBOARDS.put(new class_2960("leaderboards", "deaths"), new Leaderboard.FromStat(new class_2960("leaderboards", "deaths"), (class_2561)class_2561.method_43471((String)"leaderboard.leaderboards.deaths"), class_3468.field_15419.method_14956((Object)class_3468.field_15421), false));
        LEADERBOARDS.put(new class_2960("leaderboards", "mob_kills"), new Leaderboard.FromStat(new class_2960("leaderboards", "mob_kills"), (class_2561)class_2561.method_43471((String)"leaderboard.leaderboards.mob_kills"), class_3468.field_15419.method_14956((Object)class_3468.field_15414), false));
        LEADERBOARDS.put(new class_2960("leaderboards", "player_kills"), new Leaderboard.FromStat(new class_2960("leaderboards", "player_kills"), (class_2561)class_2561.method_43471((String)"leaderboard.leaderboards.player_kills"), class_3468.field_15419.method_14956((Object)class_3468.field_15404), false));
        LEADERBOARDS.put(new class_2960("leaderboards", "time_played"), new Leaderboard.FromStat(new class_2960("leaderboards", "time_played"), (class_2561)class_2561.method_43471((String)"leaderboard.leaderboards.time_played"), class_3468.field_15419.method_14956((Object)class_3468.field_15417), false, Leaderboard.FromStat.TIME));
        LEADERBOARDS.put(new class_2960("leaderboards", "jumps"), new Leaderboard.FromStat(new class_2960("leaderboards", "jumps"), (class_2561)class_2561.method_43471((String)"leaderboard.leaderboards.jumps"), class_3468.field_15419.method_14956((Object)class_3468.field_15428), false));
        LEADERBOARDS.put(new class_2960("leaderboards", "distance_walked"), new Leaderboard.FromStat(new class_2960("leaderboards", "distance_walked"), (class_2561)class_2561.method_43471((String)"leaderboard.leaderboards.distance_walked"), class_3468.field_15419.method_14956((Object)class_3468.field_15377), false, Leaderboard.FromStat.DISTANCE));
        LEADERBOARDS.put(new class_2960("leaderboards", "distance_sprinted"), new Leaderboard.FromStat(new class_2960("leaderboards", "distance_sprinted"), (class_2561)class_2561.method_43471((String)"leaderboard.leaderboards.distance_sprinted"), class_3468.field_15419.method_14956((Object)class_3468.field_15364), false, Leaderboard.FromStat.DISTANCE));
        LEADERBOARDS.put(new class_2960("leaderboards", "deaths_per_hour"), new Leaderboard(new class_2960("leaderboards", "deaths_per_hour"), (class_2561)class_2561.method_43471((String)"leaderboard.leaderboards.deaths_per_hour"), player -> {
            double dph = LeaderboardRegistry.getDPH(player);
            return class_2561.method_43470((String)(dph < 0.0 ? "-" : String.format("%.2f", dph)));
        }, Comparator.comparingDouble(LeaderboardRegistry::getDPH).reversed(), player -> LeaderboardRegistry.getDPH(player) >= 0.0));
        LEADERBOARDS.put(new class_2960("leaderboards", "last_seen"), new Leaderboard(new class_2960("leaderboards", "last_seen"), (class_2561)class_2561.method_43471((String)"leaderboard.leaderboards.last_seen"), player -> {
            if (player.server.method_3760().method_14602(player.getUUID()) != null) {
                return class_2561.method_43471((String)"gui.online").method_27692(class_124.field_1060);
            }
            long lastSeen = PlayerDataTracker.getLastSeen(player.getUUID());
            if (lastSeen == 0L) {
                return class_2561.method_43470((String)"-");
            }
            long worldTime = player.server.method_30002().method_8510();
            int time = (int)(worldTime - lastSeen);
            return Leaderboard.FromStat.TIME.apply(time);
        }, Comparator.comparingLong(p -> {
            if (p.server.method_3760().method_14602(p.getUUID()) != null) {
                return 0L;
            }
            return p.server.method_30002().method_8510() - PlayerDataTracker.getLastSeen(p.getUUID());
        }), player -> PlayerDataTracker.getLastSeen(player.getUUID()) != 0L || player.server.method_3760().method_14602(player.getUUID()) != null));
        if (FTBQuestsIntegration.isAvailable()) {
            LEADERBOARDS.put(new class_2960("leaderboards", "quest_completions"), new Leaderboard(new class_2960("leaderboards", "quest_completions"), (class_2561)class_2561.method_43471((String)"leaderboard.leaderboards.quest_completions"), player -> class_2561.method_43470((String)String.valueOf(FTBQuestsIntegration.getPlayerQuestCompletions(player))), Comparator.comparingInt(FTBQuestsIntegration::getPlayerQuestCompletions).reversed(), player -> FTBQuestsIntegration.getPlayerQuestCompletions(player) > 0));
            LEADERBOARDS.put(new class_2960("leaderboards", "quest_completion_percentage"), new Leaderboard(new class_2960("leaderboards", "quest_completion_percentage"), (class_2561)class_2561.method_43471((String)"leaderboard.leaderboards.quest_completion_percentage"), player -> {
                double percentage = FTBQuestsIntegration.getQuestCompletionPercentage(player);
                return class_2561.method_43470((String)String.format("%.1f%%", percentage));
            }, Comparator.comparingDouble(FTBQuestsIntegration::getQuestCompletionPercentage).reversed(), player -> FTBQuestsIntegration.getPlayerQuestCompletions(player) > 0));
        }
        VanillaStatsRegistry.register();
    }

    private static double getDPH(PlayerStatsWrapper player) {
        double hours;
        int playTime = player.getStats().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15417));
        if (playTime > 0 && (hours = (double)playTime / 72000.0) >= 1.0) {
            return (double)player.getStats().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15421)) / hours;
        }
        return -1.0;
    }
}

