/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards.data;

import com.leclowndu93150.leaderboards.data.PlayerStatsWrapper;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3445;

public class Leaderboard {
    public final class_2960 id;
    private final class_2561 title;
    private final Function<PlayerStatsWrapper, class_2561> playerToValue;
    private final Comparator<PlayerStatsWrapper> comparator;
    private final Predicate<PlayerStatsWrapper> validValue;

    public Leaderboard(class_2960 id, class_2561 title, Function<PlayerStatsWrapper, class_2561> valueFunction, Comparator<PlayerStatsWrapper> comparator, Predicate<PlayerStatsWrapper> validValue) {
        this.id = id;
        this.title = title;
        this.playerToValue = valueFunction;
        this.comparator = comparator.thenComparing((p1, p2) -> p1.getGameProfile().getName().compareToIgnoreCase(p2.getGameProfile().getName()));
        this.validValue = validValue;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public Comparator<PlayerStatsWrapper> getComparator() {
        return this.comparator;
    }

    public class_2561 createValue(PlayerStatsWrapper player) {
        return this.playerToValue.apply(player);
    }

    public boolean hasValidValue(PlayerStatsWrapper player) {
        return this.validValue.test(player);
    }

    public static class FromStat
    extends Leaderboard {
        public static final IntFunction<class_2561> DEFAULT = value -> class_2561.method_43470((String)(value <= 0 ? "0" : Integer.toString(value)));
        public static final IntFunction<class_2561> TIME = value -> {
            if (value <= 0) {
                return class_2561.method_43470((String)"0");
            }
            int hours = (int)((double)value / 72000.0 + 0.5);
            int ticks = value % 24000;
            int seconds = ticks / 20;
            int minutes = seconds / 60;
            int displayHours = minutes / 60;
            return class_2561.method_43470((String)String.format("[%dh] %02d:%02d:%02d", hours, displayHours, minutes %= 60, seconds %= 60));
        };
        public static final IntFunction<class_2561> DISTANCE = value -> {
            if (value <= 0) {
                return class_2561.method_43470((String)"0");
            }
            double blocks = (double)value / 100.0;
            if (blocks >= 1000.0) {
                return class_2561.method_43470((String)String.format("%.2f km", blocks / 1000.0));
            }
            return class_2561.method_43470((String)String.format("%.1f m", blocks));
        };
        public static final IntFunction<class_2561> DAMAGE = value -> {
            if (value <= 0) {
                return class_2561.method_43470((String)"0");
            }
            double damage = (double)value / 10.0;
            return class_2561.method_43470((String)String.format("%.1f", damage));
        };

        public FromStat(class_2960 id, class_2561 title, class_3445<?> stat, boolean ascending, IntFunction<class_2561> valueFormatter) {
            super(id, title, (PlayerStatsWrapper player) -> (class_2561)valueFormatter.apply(player.getStats().method_15025(stat)), (p1, p2) -> {
                int result = Integer.compare(p1.getStats().method_15025(stat), p2.getStats().method_15025(stat));
                return ascending ? result : -result;
            }, (PlayerStatsWrapper player) -> player.getStats().method_15025(stat) > 0);
        }

        public FromStat(class_2960 id, class_2561 title, class_3445<?> stat, boolean ascending) {
            this(id, title, stat, ascending, DEFAULT);
        }
    }
}

