/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public class PlayerDataTracker
extends class_18 {
    private static final String DATA_NAME = "leaderboards_player_data";
    private final Map<UUID, Long> lastSeenTimes = new HashMap<UUID, Long>();
    private static PlayerDataTracker instance;

    public static PlayerDataTracker create() {
        return new PlayerDataTracker();
    }

    public static PlayerDataTracker load(class_2487 tag) {
        PlayerDataTracker data = new PlayerDataTracker();
        class_2487 playerData = tag.method_10562("PlayerData");
        for (String key : playerData.method_10541()) {
            try {
                UUID uuid = UUID.fromString(key);
                long lastSeen = playerData.method_10537(key);
                data.lastSeenTimes.put(uuid, lastSeen);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return data;
    }

    public class_2487 method_75(class_2487 tag) {
        class_2487 playerData = new class_2487();
        for (Map.Entry<UUID, Long> entry : this.lastSeenTimes.entrySet()) {
            playerData.method_10544(entry.getKey().toString(), entry.getValue().longValue());
        }
        tag.method_10566("PlayerData", (class_2520)playerData);
        return tag;
    }

    public static PlayerDataTracker get(class_3218 level) {
        return (PlayerDataTracker)level.method_17983().method_17924(PlayerDataTracker::load, PlayerDataTracker::create, DATA_NAME);
    }

    public void updateLastSeen(UUID uuid, long time) {
        this.lastSeenTimes.put(uuid, time);
        this.method_80();
    }

    public static long getLastSeen(UUID uuid) {
        return PlayerDataTracker.getInstance().lastSeenTimes.getOrDefault(uuid, 0L);
    }

    public Set<UUID> getAllPlayerUUIDs() {
        return this.lastSeenTimes.keySet();
    }

    public static void setInstance(PlayerDataTracker tracker) {
        instance = tracker;
    }

    private static PlayerDataTracker getInstance() {
        return instance;
    }
}

