/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards.network;

import com.leclowndu93150.leaderboards.data.Leaderboard;
import com.leclowndu93150.leaderboards.data.LeaderboardValue;
import com.leclowndu93150.leaderboards.data.PlayerDataTracker;
import com.leclowndu93150.leaderboards.data.PlayerStatsWrapper;
import com.leclowndu93150.leaderboards.gui.LeaderboardScreen;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3442;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class LeaderboardResponsePacket {
    private final class_2561 title;
    private final List<LeaderboardValue> values;

    public LeaderboardResponsePacket(class_2561 title, List<LeaderboardValue> values) {
        this.title = title;
        this.values = values;
    }

    public LeaderboardResponsePacket(class_3222 requestingPlayer, Leaderboard leaderboard) {
        this(leaderboard.getTitle(), LeaderboardResponsePacket.createValues(requestingPlayer, leaderboard));
    }

    public static void encode(LeaderboardResponsePacket packet, class_2540 buf) {
        buf.method_10805(packet.title);
        buf.method_10804(packet.values.size());
        for (LeaderboardValue value : packet.values) {
            buf.method_10814(value.username);
            buf.method_10805(value.value);
            buf.writeByte(value.color.method_536());
        }
    }

    public static LeaderboardResponsePacket decode(class_2540 buf) {
        class_2561 title = buf.method_10808();
        int size = buf.method_10816();
        ArrayList<LeaderboardValue> values = new ArrayList<LeaderboardValue>();
        for (int i = 0; i < size; ++i) {
            LeaderboardValue value = new LeaderboardValue();
            value.username = buf.method_19772();
            value.value = buf.method_10808();
            value.color = class_124.method_534((int)buf.readByte());
            values.add(value);
        }
        return new LeaderboardResponsePacket(title, values);
    }

    private static class_3442 loadPlayerStats(MinecraftServer server, UUID uuid) {
        File statsDir = server.method_27050(class_5218.field_24181).toFile();
        File statsFile = new File(statsDir, uuid.toString() + ".json");
        return new class_3442(server, statsFile);
    }

    private static List<LeaderboardValue> createValues(class_3222 requestingPlayer, Leaderboard leaderboard) {
        ArrayList<LeaderboardValue> values = new ArrayList<LeaderboardValue>();
        ArrayList<PlayerStatsWrapper> players = new ArrayList<PlayerStatsWrapper>();
        PlayerDataTracker tracker = PlayerDataTracker.get(requestingPlayer.field_13995.method_30002());
        for (class_3222 onlinePlayer : requestingPlayer.field_13995.method_3760().method_14571()) {
            players.add(new PlayerStatsWrapper(onlinePlayer));
        }
        tracker.getAllPlayerUUIDs().forEach(uuid -> {
            GameProfile profile;
            if (requestingPlayer.field_13995.method_3760().method_14602(uuid) == null && (profile = (GameProfile)requestingPlayer.field_13995.method_3793().method_14512(uuid).orElse(null)) != null) {
                class_3442 stats = LeaderboardResponsePacket.loadPlayerStats(requestingPlayer.field_13995, uuid);
                players.add(new PlayerStatsWrapper((UUID)uuid, profile, stats, requestingPlayer.field_13995));
            }
        });
        players.sort(leaderboard.getComparator());
        for (int i = 0; i < players.size(); ++i) {
            PlayerStatsWrapper player = (PlayerStatsWrapper)players.get(i);
            LeaderboardValue value = new LeaderboardValue();
            value.username = player.getGameProfile().getName();
            value.value = leaderboard.createValue(player);
            value.color = player.getUUID().equals(requestingPlayer.method_5667()) ? class_124.field_1077 : (!leaderboard.hasValidValue(player) ? class_124.field_1063 : (i < 3 ? class_124.field_1065 : class_124.field_1070));
            values.add(value);
        }
        return values;
    }

    public static void handle(class_2540 buf, class_310 client) {
        LeaderboardResponsePacket packet = LeaderboardResponsePacket.decode(buf);
        client.execute(() -> {
            LeaderboardScreen screen = new LeaderboardScreen(packet.title, packet.values);
            screen.openGui();
        });
    }
}

