/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.ledger.actions;

import com.github.quiltservertools.ledger.actions.AbstractActionType;
import com.github.quiltservertools.ledger.utility.ExtensionsKt;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_3218;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\n\u0010\tR\u001a\u0010\u000b\u001a\u00020\u00028\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lcom/github/quiltservertools/ledger/actions/EntityKillActionType;", "Lcom/github/quiltservertools/ledger/actions/AbstractActionType;", "", "getTranslationType", "()Ljava/lang/String;", "Lnet/minecraft/server/MinecraftServer;", "server", "", "restore", "(Lnet/minecraft/server/MinecraftServer;)Z", "rollback", "identifier", "Ljava/lang/String;", "getIdentifier", "<init>", "()V", "ledger"})
public final class EntityKillActionType
extends AbstractActionType {
    @NotNull
    private final String identifier;

    public EntityKillActionType() {
        this.identifier = "entity-kill";
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @NotNull
    public String getTranslationType() {
        return "entity";
    }

    @Override
    public boolean rollback(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_3218 world = ExtensionsKt.getWorld(server, this.getWorld());
        Optional entityType = class_7923.field_41177.method_17966(this.getObjectIdentifier());
        if (entityType.isPresent()) {
            class_1309 class_13092 = (class_1309)((class_1299)entityType.get()).method_5883((class_1937)world);
            Intrinsics.checkNotNull((Object)class_13092);
            class_1309 entity = class_13092;
            entity.method_5651(class_2522.method_10718((String)this.getExtraData()));
            entity.method_6033((float)entity.field_6269);
            entity.method_18799(class_243.field_1353);
            entity.method_20803(0);
            class_3218 class_32182 = world;
            if (class_32182 != null) {
                class_32182.method_8649((class_1297)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean restore(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_3218 world = ExtensionsKt.getWorld(server, this.getWorld());
        class_2487 tag = class_2522.method_10718((String)this.getExtraData());
        if (tag.method_25928("UUID")) {
            class_1297 entity;
            UUID uuid = tag.method_25926("UUID");
            class_3218 class_32182 = world;
            Object object = entity = class_32182 != null ? class_32182.method_14190(uuid) : null;
            if (entity != null) {
                entity.method_5650(class_1297.class_5529.field_26999);
                return true;
            }
        }
        return false;
    }
}

