/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.libs.com.fasterxml.jackson.databind.jsontype;

import com.github.quiltservertools.libs.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.github.quiltservertools.libs.com.fasterxml.jackson.core.JsonGenerator;
import com.github.quiltservertools.libs.com.fasterxml.jackson.core.JsonToken;
import com.github.quiltservertools.libs.com.fasterxml.jackson.core.type.WritableTypeId;
import com.github.quiltservertools.libs.com.fasterxml.jackson.core.util.VersionUtil;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.BeanProperty;
import com.github.quiltservertools.libs.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import java.io.IOException;

public abstract class TypeSerializer {
    public abstract TypeSerializer forProperty(BeanProperty var1);

    public abstract JsonTypeInfo.As getTypeInclusion();

    public abstract String getPropertyName();

    public abstract TypeIdResolver getTypeIdResolver();

    public WritableTypeId typeId(Object value2, JsonToken valueShape) {
        WritableTypeId typeIdDef = new WritableTypeId(value2, valueShape);
        switch (this.getTypeInclusion()) {
            case EXISTING_PROPERTY: {
                typeIdDef.include = WritableTypeId.Inclusion.PAYLOAD_PROPERTY;
                typeIdDef.asProperty = this.getPropertyName();
                break;
            }
            case EXTERNAL_PROPERTY: {
                typeIdDef.include = WritableTypeId.Inclusion.PARENT_PROPERTY;
                typeIdDef.asProperty = this.getPropertyName();
                break;
            }
            case PROPERTY: {
                typeIdDef.include = WritableTypeId.Inclusion.METADATA_PROPERTY;
                typeIdDef.asProperty = this.getPropertyName();
                break;
            }
            case WRAPPER_ARRAY: {
                typeIdDef.include = WritableTypeId.Inclusion.WRAPPER_ARRAY;
                break;
            }
            case WRAPPER_OBJECT: {
                typeIdDef.include = WritableTypeId.Inclusion.WRAPPER_OBJECT;
                break;
            }
            default: {
                VersionUtil.throwInternal();
            }
        }
        return typeIdDef;
    }

    public WritableTypeId typeId(Object value2, JsonToken valueShape, Object id2) {
        WritableTypeId typeId = this.typeId(value2, valueShape);
        typeId.id = id2;
        return typeId;
    }

    public WritableTypeId typeId(Object value2, Class<?> typeForId, JsonToken valueShape) {
        WritableTypeId typeId = this.typeId(value2, valueShape);
        typeId.forValueType = typeForId;
        return typeId;
    }

    public abstract WritableTypeId writeTypePrefix(JsonGenerator var1, WritableTypeId var2) throws IOException;

    public abstract WritableTypeId writeTypeSuffix(JsonGenerator var1, WritableTypeId var2) throws IOException;

    @Deprecated
    public void writeTypePrefixForScalar(Object value2, JsonGenerator g) throws IOException {
        this.writeTypePrefix(g, this.typeId(value2, JsonToken.VALUE_STRING));
    }

    @Deprecated
    public void writeTypePrefixForObject(Object value2, JsonGenerator g) throws IOException {
        this.writeTypePrefix(g, this.typeId(value2, JsonToken.START_OBJECT));
    }

    @Deprecated
    public void writeTypePrefixForArray(Object value2, JsonGenerator g) throws IOException {
        this.writeTypePrefix(g, this.typeId(value2, JsonToken.START_ARRAY));
    }

    @Deprecated
    public void writeTypeSuffixForScalar(Object value2, JsonGenerator g) throws IOException {
        this._writeLegacySuffix(g, this.typeId(value2, JsonToken.VALUE_STRING));
    }

    @Deprecated
    public void writeTypeSuffixForObject(Object value2, JsonGenerator g) throws IOException {
        this._writeLegacySuffix(g, this.typeId(value2, JsonToken.START_OBJECT));
    }

    @Deprecated
    public void writeTypeSuffixForArray(Object value2, JsonGenerator g) throws IOException {
        this._writeLegacySuffix(g, this.typeId(value2, JsonToken.START_ARRAY));
    }

    @Deprecated
    public void writeTypePrefixForScalar(Object value2, JsonGenerator g, Class<?> type) throws IOException {
        this.writeTypePrefix(g, this.typeId(value2, type, JsonToken.VALUE_STRING));
    }

    @Deprecated
    public void writeTypePrefixForObject(Object value2, JsonGenerator g, Class<?> type) throws IOException {
        this.writeTypePrefix(g, this.typeId(value2, type, JsonToken.START_OBJECT));
    }

    @Deprecated
    public void writeTypePrefixForArray(Object value2, JsonGenerator g, Class<?> type) throws IOException {
        this.writeTypePrefix(g, this.typeId(value2, type, JsonToken.START_ARRAY));
    }

    @Deprecated
    public void writeCustomTypePrefixForScalar(Object value2, JsonGenerator g, String typeId) throws IOException {
        this.writeTypePrefix(g, this.typeId(value2, JsonToken.VALUE_STRING, typeId));
    }

    @Deprecated
    public void writeCustomTypePrefixForObject(Object value2, JsonGenerator g, String typeId) throws IOException {
        this.writeTypePrefix(g, this.typeId(value2, JsonToken.START_OBJECT, typeId));
    }

    @Deprecated
    public void writeCustomTypePrefixForArray(Object value2, JsonGenerator g, String typeId) throws IOException {
        this.writeTypePrefix(g, this.typeId(value2, JsonToken.START_ARRAY, typeId));
    }

    @Deprecated
    public void writeCustomTypeSuffixForScalar(Object value2, JsonGenerator g, String typeId) throws IOException {
        this._writeLegacySuffix(g, this.typeId(value2, JsonToken.VALUE_STRING, typeId));
    }

    @Deprecated
    public void writeCustomTypeSuffixForObject(Object value2, JsonGenerator g, String typeId) throws IOException {
        this._writeLegacySuffix(g, this.typeId(value2, JsonToken.START_OBJECT, typeId));
    }

    @Deprecated
    public void writeCustomTypeSuffixForArray(Object value2, JsonGenerator g, String typeId) throws IOException {
        this._writeLegacySuffix(g, this.typeId(value2, JsonToken.START_ARRAY, typeId));
    }

    protected final void _writeLegacySuffix(JsonGenerator g, WritableTypeId typeId) throws IOException {
        typeId.wrapperWritten = !g.canWriteTypeId();
        this.writeTypeSuffix(g, typeId);
    }
}

