/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.libs.javassist.tools.reflect;

import com.github.quiltservertools.libs.javassist.tools.reflect.CannotInvokeException;
import com.github.quiltservertools.libs.javassist.tools.reflect.ClassMetaobject;
import com.github.quiltservertools.libs.javassist.tools.reflect.Metalevel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Metaobject
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ClassMetaobject classmetaobject;
    protected Metalevel baseobject;
    protected Method[] methods;

    public Metaobject(Object self, Object[] args) {
        this.baseobject = (Metalevel)self;
        this.classmetaobject = this.baseobject._getClass();
        this.methods = this.classmetaobject.getReflectiveMethods();
    }

    protected Metaobject() {
        this.baseobject = null;
        this.classmetaobject = null;
        this.methods = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.baseobject);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.baseobject = (Metalevel)in.readObject();
        this.classmetaobject = this.baseobject._getClass();
        this.methods = this.classmetaobject.getReflectiveMethods();
    }

    public final ClassMetaobject getClassMetaobject() {
        return this.classmetaobject;
    }

    public final Object getObject() {
        return this.baseobject;
    }

    public final void setObject(Object self) {
        this.baseobject = (Metalevel)self;
        this.classmetaobject = this.baseobject._getClass();
        this.methods = this.classmetaobject.getReflectiveMethods();
        this.baseobject._setMetaobject(this);
    }

    public final String getMethodName(int identifier2) {
        char c;
        String mname = this.methods[identifier2].getName();
        int j = 3;
        while ((c = mname.charAt(j++)) >= '0' && '9' >= c) {
        }
        return mname.substring(j);
    }

    public final Class<?>[] getParameterTypes(int identifier2) {
        return this.methods[identifier2].getParameterTypes();
    }

    public final Class<?> getReturnType(int identifier2) {
        return this.methods[identifier2].getReturnType();
    }

    public Object trapFieldRead(String name) {
        Class<?> jc = this.getClassMetaobject().getJavaClass();
        try {
            return jc.getField(name).get(this.getObject());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void trapFieldWrite(String name, Object value2) {
        Class<?> jc = this.getClassMetaobject().getJavaClass();
        try {
            jc.getField(name).set(this.getObject(), value2);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Object trapMethodcall(int identifier2, Object[] args) throws Throwable {
        try {
            return this.methods[identifier2].invoke(this.getObject(), args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            throw new CannotInvokeException(e);
        }
    }
}

