/*
 * Decompiled with CFR 0.152.
 */
package com.github.quiltservertools.libs.org.reflections.vfs;

import com.github.quiltservertools.libs.org.reflections.Reflections;
import com.github.quiltservertools.libs.org.reflections.ReflectionsException;
import com.github.quiltservertools.libs.org.reflections.vfs.Vfs;
import com.github.quiltservertools.libs.org.reflections.vfs.ZipDir;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlTypeVFS
implements Vfs.UrlType {
    public static final String[] REPLACE_EXTENSION = new String[]{".ear/", ".jar/", ".war/", ".sar/", ".har/", ".par/"};
    final String VFSZIP = "vfszip";
    final String VFSFILE = "vfsfile";
    Predicate<File> realFile = file2 -> file2.exists() && file2.isFile();

    @Override
    public boolean matches(URL url2) {
        return "vfszip".equals(url2.getProtocol()) || "vfsfile".equals(url2.getProtocol());
    }

    @Override
    public Vfs.Dir createDir(URL url2) {
        try {
            URL adaptedUrl = this.adaptURL(url2);
            return new ZipDir(new JarFile(adaptedUrl.getFile()));
        }
        catch (Exception e) {
            try {
                return new ZipDir(new JarFile(url2.getFile()));
            }
            catch (IOException e1) {
                if (Reflections.log != null) {
                    Reflections.log.warn("Could not get URL", (Throwable)e);
                    Reflections.log.warn("Could not get URL", (Throwable)e1);
                }
                return null;
            }
        }
    }

    public URL adaptURL(URL url2) throws MalformedURLException {
        if ("vfszip".equals(url2.getProtocol())) {
            return this.replaceZipSeparators(url2.getPath(), this.realFile);
        }
        if ("vfsfile".equals(url2.getProtocol())) {
            return new URL(url2.toString().replace("vfsfile", "file"));
        }
        return url2;
    }

    URL replaceZipSeparators(String path, Predicate<File> acceptFile) throws MalformedURLException {
        int pos = 0;
        while (pos != -1) {
            File file2;
            if ((pos = this.findFirstMatchOfDeployableExtention(path, pos)) <= 0 || !acceptFile.test(file2 = new File(path.substring(0, pos - 1)))) continue;
            return this.replaceZipSeparatorStartingFrom(path, pos);
        }
        throw new ReflectionsException("Unable to identify the real zip file in path '" + path + "'.");
    }

    int findFirstMatchOfDeployableExtention(String path, int pos) {
        Pattern p = Pattern.compile("\\.[ejprw]ar/");
        Matcher m = p.matcher(path);
        if (m.find(pos)) {
            return m.end();
        }
        return -1;
    }

    URL replaceZipSeparatorStartingFrom(String path, int pos) throws MalformedURLException {
        String zipFile = path.substring(0, pos - 1);
        String zipPath = path.substring(pos);
        int numSubs = 1;
        for (String ext : REPLACE_EXTENSION) {
            while (zipPath.contains(ext)) {
                zipPath = zipPath.replace(ext, ext.substring(0, 4) + "!");
                ++numSubs;
            }
        }
        String prefix2 = "";
        for (int i = 0; i < numSubs; ++i) {
            prefix2 = prefix2 + "zip:";
        }
        if (zipPath.trim().length() == 0) {
            return new URL(prefix2 + "/" + zipFile);
        }
        return new URL(prefix2 + "/" + zipFile + "!" + zipPath);
    }
}

