/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.statements.api.ExposedBlob;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ)\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/exposed/sql/BlobColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "", "value", "", "nonNullValueToString", "(Ljava/lang/Object;)Ljava/lang/String;", "notNullValueToDB", "(Ljava/lang/Object;)Ljava/lang/Object;", "Ljava/sql/ResultSet;", "rs", "", "index", "Lorg/jetbrains/exposed/sql/statements/api/ExposedBlob;", "readObject", "(Ljava/sql/ResultSet;I)Lorg/jetbrains/exposed/sql/statements/api/ExposedBlob;", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "stmt", "", "setParameter", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;ILjava/lang/Object;)V", "sqlType", "()Ljava/lang/String;", "valueFromDB", "(Ljava/lang/Object;)Lorg/jetbrains/exposed/sql/statements/api/ExposedBlob;", "<init>", "()V", "exposed-core"})
public final class BlobColumnType
extends ColumnType {
    public BlobColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().blobType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ExposedBlob valueFromDB(@NotNull Object value2) {
        ExposedBlob exposedBlob;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof ExposedBlob) {
            exposedBlob = (ExposedBlob)value2;
        } else if (object instanceof Blob) {
            Closeable closeable = ((Blob)value2).getBinaryStream();
            Throwable throwable = null;
            try {
                Object it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                it = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object object2 = it;
            exposedBlob = new ExposedBlob((byte[])object2);
        } else if (object instanceof InputStream) {
            byte[] byArray;
            Closeable closeable = (Closeable)value2;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                byArray = ByteStreamsKt.readBytes((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            byte[] byArray2 = byArray;
            exposedBlob = new ExposedBlob(byArray2);
        } else if (object instanceof byte[]) {
            exposedBlob = new ExposedBlob((byte[])value2);
        } else {
            throw new IllegalStateException(("Unexpected value of type Blob: " + value2 + " of " + Reflection.getOrCreateKotlinClass(value2.getClass()).getQualifiedName()).toString());
        }
        return exposedBlob;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (value2 instanceof Blob) {
            InputStream inputStream = ((Blob)value2).getBinaryStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"{\n            value.binaryStream\n        }");
            object = inputStream;
        } else {
            object = value2;
        }
        return object;
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return "?";
    }

    @Override
    @Nullable
    public ExposedBlob readObject(@NotNull ResultSet rs, int index) {
        ExposedBlob exposedBlob;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        byte[] byArray = rs.getBytes(index);
        if (byArray != null) {
            byte[] p0 = byArray;
            boolean bl = false;
            exposedBlob = new ExposedBlob(p0);
        } else {
            exposedBlob = null;
        }
        return exposedBlob;
    }

    @Override
    public void setParameter(@NotNull PreparedStatementApi stmt, int index, @Nullable Object value2) {
        byte[] byArray;
        Object toSetValue;
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        ExposedBlob exposedBlob = value2 instanceof ExposedBlob ? (ExposedBlob)value2 : null;
        Object object = toSetValue = exposedBlob != null && (byArray = exposedBlob.getBytes()) != null ? new ByteArrayInputStream(byArray) : value2;
        if (toSetValue instanceof InputStream) {
            stmt.setInputStream(index, (InputStream)toSetValue);
        } else {
            Object object2 = toSetValue;
            if (object2 == null ? true : object2 instanceof Op.NULL) {
                stmt.setNull(index, this);
            } else {
                super.setParameter(stmt, index, toSetValue);
            }
        }
    }
}

