/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001f\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b \u0010!J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0004J.\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u0004R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001a\u001a\u0004\b\u001b\u0010\u0004R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001a\u001a\u0004\b\u001c\u0010\u0004R\u001a\u0010\u001d\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001a\u001a\u0004\b\u001e\u0010\u0004R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001a\u001a\u0004\b\u001f\u0010\u0004\u00a8\u0006#"}, d2={"Lorg/jetbrains/exposed/sql/CheckConstraint;", "Lorg/jetbrains/exposed/sql/DdlAware;", "", "component1", "()Ljava/lang/String;", "component2", "component3", "tableName", "checkName", "checkOp", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lorg/jetbrains/exposed/sql/CheckConstraint;", "", "createStatement", "()Ljava/util/List;", "dropStatement", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "modifyStatement", "toString", "Ljava/lang/String;", "getCheckName", "getCheckOp", "checkPart", "getCheckPart$exposed_core", "getTableName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Companion", "exposed-core"})
public final class CheckConstraint
implements DdlAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tableName;
    @NotNull
    private final String checkName;
    @NotNull
    private final String checkOp;
    @NotNull
    private final String checkPart;

    public CheckConstraint(@NotNull String tableName, @NotNull String checkName, @NotNull String checkOp) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)checkName, (String)"checkName");
        Intrinsics.checkNotNullParameter((Object)checkOp, (String)"checkOp");
        this.tableName = tableName;
        this.checkName = checkName;
        this.checkOp = checkOp;
        this.checkPart = "CONSTRAINT " + this.checkName + " CHECK (" + this.checkOp + ')';
    }

    @NotNull
    public final String getTableName() {
        return this.tableName;
    }

    @NotNull
    public final String getCheckName() {
        return this.checkName;
    }

    @NotNull
    public final String getCheckOp() {
        return this.checkOp;
    }

    @NotNull
    public final String getCheckPart$exposed_core() {
        return this.checkPart;
    }

    @Override
    @NotNull
    public List<String> createStatement() {
        List list2;
        if (DefaultKt.getCurrentDialect() instanceof MysqlDialect) {
            SQLLogKt.getExposedLogger().warn("Creation of CHECK constraints is not currently supported by MySQL");
            list2 = CollectionsKt.emptyList();
        } else {
            list2 = CollectionsKt.listOf((Object)("ALTER TABLE " + this.tableName + " ADD " + this.checkPart));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<String> modifyStatement() {
        return CollectionsKt.plus((Collection)this.dropStatement(), (Iterable)this.createStatement());
    }

    @Override
    @NotNull
    public List<String> dropStatement() {
        List list2;
        if (DefaultKt.getCurrentDialect() instanceof MysqlDialect) {
            SQLLogKt.getExposedLogger().warn("Deletion of CHECK constraints is not currently supported by MySQL");
            list2 = CollectionsKt.emptyList();
        } else {
            list2 = CollectionsKt.listOf((Object)("ALTER TABLE " + this.tableName + " DROP CONSTRAINT " + this.checkName));
        }
        return list2;
    }

    @NotNull
    public final String component1() {
        return this.tableName;
    }

    @NotNull
    public final String component2() {
        return this.checkName;
    }

    @NotNull
    public final String component3() {
        return this.checkOp;
    }

    @NotNull
    public final CheckConstraint copy(@NotNull String tableName, @NotNull String checkName, @NotNull String checkOp) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)checkName, (String)"checkName");
        Intrinsics.checkNotNullParameter((Object)checkOp, (String)"checkOp");
        return new CheckConstraint(tableName, checkName, checkOp);
    }

    public static /* synthetic */ CheckConstraint copy$default(CheckConstraint checkConstraint, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = checkConstraint.tableName;
        }
        if ((n & 2) != 0) {
            string2 = checkConstraint.checkName;
        }
        if ((n & 4) != 0) {
            string3 = checkConstraint.checkOp;
        }
        return checkConstraint.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "CheckConstraint(tableName=" + this.tableName + ", checkName=" + this.checkName + ", checkOp=" + this.checkOp + ')';
    }

    public int hashCode() {
        int result2 = this.tableName.hashCode();
        result2 = result2 * 31 + this.checkName.hashCode();
        result2 = result2 * 31 + this.checkOp.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CheckConstraint)) {
            return false;
        }
        CheckConstraint checkConstraint = (CheckConstraint)other;
        if (!Intrinsics.areEqual((Object)this.tableName, (Object)checkConstraint.tableName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.checkName, (Object)checkConstraint.checkName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.checkOp, (Object)checkConstraint.checkOp);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ-\u0010\f\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/exposed/sql/CheckConstraint$Companion;", "", "Lorg/jetbrains/exposed/sql/Table;", "table", "", "name", "Lorg/jetbrains/exposed/sql/Op;", "", "op", "Lorg/jetbrains/exposed/sql/CheckConstraint;", "from$exposed_core", "(Lorg/jetbrains/exposed/sql/Table;Ljava/lang/String;Lorg/jetbrains/exposed/sql/Op;)Lorg/jetbrains/exposed/sql/CheckConstraint;", "from", "<init>", "()V", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CheckConstraint from$exposed_core(@NotNull Table table, @NotNull String name, @NotNull Op<Boolean> op) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(op, (String)"op");
            if (!(!StringsKt.isBlank((CharSequence)name))) {
                boolean $i$a$-require-CheckConstraint$Companion$from$22 = false;
                String $i$a$-require-CheckConstraint$Companion$from$22 = "Check constraint name cannot be blank";
                throw new IllegalArgumentException($i$a$-require-CheckConstraint$Companion$from$22.toString());
            }
            Transaction tr = TransactionManager.Companion.current();
            IdentifierManagerApi identifierManager2 = tr.getDb().getIdentifierManager();
            String tableName = tr.identity(table);
            String checkOpSQL = StringsKt.replace$default((String)op.toString(), (String)(tableName + '.'), (String)"", (boolean)false, (int)4, null);
            return new CheckConstraint(tableName, identifierManager2.cutIfNecessaryAndQuote(name), checkOpSQL);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

