/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.DatabaseConfig;
import org.jetbrains.exposed.sql.DatabaseConnectionAutoRegistration;
import org.jetbrains.exposed.sql.DatabaseKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u001c\u0018\u0000 H2\u00020\u0001:\u0001HB/\b\u0002\u0012\n\b\u0002\u0010.\u001a\u0004\u0018\u00010-\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0018\u00a2\u0006\u0004\bF\u0010GJ\u0017\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ.\u0010\u0012\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000b2\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0002\b\u000eH\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0014\u001a\u00020\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u00188\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR(\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001f\u001a\u0004\b \u0010!R\u001b\u0010'\u001a\u00020\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u001b\u0010,\u001a\u00020(8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010$\u001a\u0004\b*\u0010+R\u0016\u0010.\u001a\u0004\u0018\u00010-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u001b\u00103\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010$\u001a\u0004\b1\u00102R\u001b\u00106\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010$\u001a\u0004\b5\u00102R\u001b\u0010:\u001a\u00020-8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010$\u001a\u0004\b8\u00109R*\u0010;\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b8\u0006@GX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010<\u001a\u0004\b=\u00102\"\u0004\b>\u0010?R\u001b\u0010B\u001a\u00020-8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010$\u001a\u0004\bA\u00109R\u001b\u0010\u0007\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u0010$\u001a\u0004\bD\u0010E\u00a8\u0006I"}, d2={"Lorg/jetbrains/exposed/sql/Database;", "", "", "size", "defaultFetchSize", "(I)Lorg/jetbrains/exposed/sql/Database;", "Ljava/math/BigDecimal;", "version", "", "isVersionCovers", "(Ljava/math/BigDecimal;)Z", "T", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "Lkotlin/ExtensionFunctionType;", "body", "metadata$exposed_core", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "metadata", "Lorg/jetbrains/exposed/sql/DatabaseConfig;", "config", "Lorg/jetbrains/exposed/sql/DatabaseConfig;", "getConfig", "()Lorg/jetbrains/exposed/sql/DatabaseConfig;", "Lkotlin/Function0;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "connector", "Lkotlin/jvm/functions/Function0;", "getConnector", "()Lkotlin/jvm/functions/Function0;", "<set-?>", "Ljava/lang/Integer;", "getDefaultFetchSize", "()Ljava/lang/Integer;", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "dialect$delegate", "Lkotlin/Lazy;", "getDialect", "()Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "dialect", "Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager$delegate", "getIdentifierManager", "()Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager", "", "resolvedVendor", "Ljava/lang/String;", "supportsAlterTableWithAddColumn$delegate", "getSupportsAlterTableWithAddColumn", "()Z", "supportsAlterTableWithAddColumn", "supportsMultipleResultSets$delegate", "getSupportsMultipleResultSets", "supportsMultipleResultSets", "url$delegate", "getUrl", "()Ljava/lang/String;", "url", "useNestedTransactions", "Z", "getUseNestedTransactions", "setUseNestedTransactions", "(Z)V", "vendor$delegate", "getVendor", "vendor", "version$delegate", "getVersion", "()Ljava/math/BigDecimal;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/DatabaseConfig;Lkotlin/jvm/functions/Function0;)V", "Companion", "exposed-core"})
public final class Database {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String resolvedVendor;
    @NotNull
    private final DatabaseConfig config;
    @NotNull
    private final Function0<ExposedConnection<?>> connector;
    private boolean useNestedTransactions;
    @NotNull
    private final Lazy url$delegate;
    @NotNull
    private final Lazy vendor$delegate;
    @NotNull
    private final Lazy dialect$delegate;
    @NotNull
    private final Lazy version$delegate;
    @NotNull
    private final Lazy supportsAlterTableWithAddColumn$delegate;
    @NotNull
    private final Lazy supportsMultipleResultSets$delegate;
    @NotNull
    private final Lazy identifierManager$delegate;
    @Nullable
    private Integer defaultFetchSize;
    @NotNull
    private static final ConcurrentHashMap<String, Function0<DatabaseDialect>> dialects = new ConcurrentHashMap();
    @NotNull
    private static final DatabaseConnectionAutoRegistration connectionInstanceImpl;
    @NotNull
    private static final Map<String, String> driverMapping;
    @NotNull
    private static final Map<String, String> dialectMapping;

    private Database(String resolvedVendor, DatabaseConfig config2, Function0<? extends ExposedConnection<?>> connector) {
        this.resolvedVendor = resolvedVendor;
        this.config = config2;
        this.connector = connector;
        this.useNestedTransactions = this.config.getUseNestedTransactions();
        this.url$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Database this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return (String)this.this$0.metadata$exposed_core(url.1.INSTANCE);
            }
        }));
        this.vendor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Database this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = Database.access$getResolvedVendor$p(this.this$0);
                if (string == null) {
                    string = (String)this.this$0.metadata$exposed_core(vendor.1.INSTANCE);
                }
                return string;
            }
        }));
        this.dialect$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DatabaseDialect>(this){
            final /* synthetic */ Database this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DatabaseDialect invoke() {
                DatabaseDialect databaseDialect = this.this$0.getConfig().getExplicitDialect();
                if (databaseDialect == null) {
                    ConcurrentHashMap concurrentHashMap = Database.access$getDialects$cp();
                    String string = this.this$0.getVendor().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    Function0 function0 = (Function0)concurrentHashMap.get(string);
                    databaseDialect = function0 != null ? (DatabaseDialect)function0.invoke() : null;
                    if (databaseDialect == null) {
                        throw new IllegalStateException(("No dialect registered for " + DatabaseKt.getName(this.this$0) + ". URL=" + this.this$0.getUrl()).toString());
                    }
                }
                return databaseDialect;
            }
        }));
        this.version$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BigDecimal>(this){
            final /* synthetic */ Database this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BigDecimal invoke() {
                return (BigDecimal)this.this$0.metadata$exposed_core(version.1.INSTANCE);
            }
        }));
        this.supportsAlterTableWithAddColumn$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ Database this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return (Boolean)this.this$0.metadata$exposed_core(supportsAlterTableWithAddColumn.1.INSTANCE);
            }
        }));
        this.supportsMultipleResultSets$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ Database this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return (Boolean)this.this$0.metadata$exposed_core(supportsMultipleResultSets.1.INSTANCE);
            }
        }));
        this.identifierManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IdentifierManagerApi>(this){
            final /* synthetic */ Database this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IdentifierManagerApi invoke() {
                return (IdentifierManagerApi)this.this$0.metadata$exposed_core(identifierManager.1.INSTANCE);
            }
        }));
        this.defaultFetchSize = this.config.getDefaultFetchSize();
    }

    /* synthetic */ Database(String string, DatabaseConfig databaseConfig, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string, databaseConfig, function0);
    }

    @NotNull
    public final DatabaseConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Function0<ExposedConnection<?>> getConnector() {
        return this.connector;
    }

    public final boolean getUseNestedTransactions() {
        return this.useNestedTransactions;
    }

    @Deprecated(message="Use DatabaseConfig to define the useNestedTransactions")
    public final void setUseNestedTransactions(boolean bl) {
        this.useNestedTransactions = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T metadata$exposed_core(@NotNull Function1<? super ExposedDatabaseMetadata, ? extends T> body) {
        T t;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Transaction transaction2 = TransactionManager.Companion.currentOrNull();
        if (transaction2 == null) {
            T t2;
            try (ExposedConnection connection = (ExposedConnection)this.connector.invoke();){
                t2 = connection.metadata(body);
            }
            t = t2;
        } else {
            t = transaction2.getConnection().metadata(body);
        }
        return t;
    }

    @NotNull
    public final String getUrl() {
        Lazy lazy2 = this.url$delegate;
        return (String)lazy2.getValue();
    }

    @NotNull
    public final String getVendor() {
        Lazy lazy2 = this.vendor$delegate;
        return (String)lazy2.getValue();
    }

    @NotNull
    public final DatabaseDialect getDialect() {
        Lazy lazy2 = this.dialect$delegate;
        return (DatabaseDialect)lazy2.getValue();
    }

    @NotNull
    public final BigDecimal getVersion() {
        Lazy lazy2 = this.version$delegate;
        return (BigDecimal)lazy2.getValue();
    }

    public final boolean isVersionCovers(@NotNull BigDecimal version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return this.getVersion().compareTo(version2) >= 0;
    }

    public final boolean getSupportsAlterTableWithAddColumn() {
        Lazy lazy2 = this.supportsAlterTableWithAddColumn$delegate;
        return (Boolean)lazy2.getValue();
    }

    public final boolean getSupportsMultipleResultSets() {
        Lazy lazy2 = this.supportsMultipleResultSets$delegate;
        return (Boolean)lazy2.getValue();
    }

    @NotNull
    public final IdentifierManagerApi getIdentifierManager() {
        Lazy lazy2 = this.identifierManager$delegate;
        return (IdentifierManagerApi)lazy2.getValue();
    }

    @Nullable
    public final Integer getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    @Deprecated(message="Use DatabaseConfig to define the defaultFetchSize")
    @NotNull
    public final Database defaultFetchSize(int size) {
        this.defaultFetchSize = size;
        return this;
    }

    public /* synthetic */ Database(String resolvedVendor, DatabaseConfig config2, Function0 connector, DefaultConstructorMarker $constructor_marker) {
        this(resolvedVendor, config2, connector);
    }

    public static final /* synthetic */ DatabaseConnectionAutoRegistration access$getConnectionInstanceImpl$cp() {
        return connectionInstanceImpl;
    }

    public static final /* synthetic */ String access$getResolvedVendor$p(Database $this) {
        return $this.resolvedVendor;
    }

    static {
        ServiceLoader<DatabaseConnectionAutoRegistration> serviceLoader = ServiceLoader.load(DatabaseConnectionAutoRegistration.class, Database.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(DatabaseConnectionA\u2026::class.java.classLoader)");
        DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration = (DatabaseConnectionAutoRegistration)CollectionsKt.firstOrNull((Iterable)serviceLoader);
        if (databaseConnectionAutoRegistration == null) {
            throw new IllegalStateException(("Can't load implementation for " + Reflection.getOrCreateKotlinClass(DatabaseConnectionAutoRegistration.class).getSimpleName()).toString());
        }
        connectionInstanceImpl = databaseConnectionAutoRegistration;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"jdbc:h2", (Object)"org.h2.Driver"), TuplesKt.to((Object)"jdbc:postgresql", (Object)"org.postgresql.Driver"), TuplesKt.to((Object)"jdbc:pgsql", (Object)"com.impossibl.postgres.jdbc.PGDriver"), TuplesKt.to((Object)"jdbc:mysql", (Object)"com.mysql.cj.jdbc.Driver"), TuplesKt.to((Object)"jdbc:mariadb", (Object)"org.mariadb.jdbc.Driver"), TuplesKt.to((Object)"jdbc:oracle", (Object)"oracle.jdbc.OracleDriver"), TuplesKt.to((Object)"jdbc:sqlite", (Object)"org.sqlite.JDBC"), TuplesKt.to((Object)"jdbc:sqlserver", (Object)"com.microsoft.sqlserver.jdbc.SQLServerDriver")};
        driverMapping = MapsKt.mutableMapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"jdbc:h2", (Object)"h2"), TuplesKt.to((Object)"jdbc:postgresql", (Object)"postgresql"), TuplesKt.to((Object)"jdbc:pgsql", (Object)"pgsql"), TuplesKt.to((Object)"jdbc:mysql", (Object)"mysql"), TuplesKt.to((Object)"jdbc:mariadb", (Object)"mariadb"), TuplesKt.to((Object)"jdbc:oracle", (Object)"oracle"), TuplesKt.to((Object)"jdbc:sqlite", (Object)"sqlite"), TuplesKt.to((Object)"jdbc:sqlserver", (Object)"sqlserver")};
        dialectMapping = MapsKt.mutableMapOf((Pair[])pairArray);
        Companion.registerDialect("h2", (Function0<? extends DatabaseDialect>)((Function0)Companion.1.INSTANCE));
        Companion.registerDialect("mysql", (Function0<? extends DatabaseDialect>)((Function0)Companion.2.INSTANCE));
        Companion.registerDialect("postgresql", (Function0<? extends DatabaseDialect>)((Function0)Companion.3.INSTANCE));
        Companion.registerDialect("pgsql", (Function0<? extends DatabaseDialect>)((Function0)Companion.4.INSTANCE));
        Companion.registerDialect("sqlite", (Function0<? extends DatabaseDialect>)((Function0)Companion.5.INSTANCE));
        Companion.registerDialect("oracle", (Function0<? extends DatabaseDialect>)((Function0)Companion.6.INSTANCE));
        Companion.registerDialect("sqlserver", (Function0<? extends DatabaseDialect>)((Function0)Companion.7.INSTANCE));
        Companion.registerDialect("mariadb", (Function0<? extends DatabaseDialect>)((Function0)Companion.8.INSTANCE));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b8\u00109J=\u0010\u000b\u001a\u00020\b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJO\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u00072\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0007\u00a2\u0006\u0004\b\u000b\u0010\u0011JM\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00122\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u00072\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\u000b\u0010\u0013Jk\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00142\b\b\u0002\u0010\u0017\u001a\u00020\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u00142\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u00072\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\u000b\u0010\u0019JM\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u00072\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\u001a\u0010\u0011J]\u0010\u001d\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u00072\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\b\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010%\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b%\u0010$J#\u0010)\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u00142\f\u0010(\u001a\b\u0012\u0004\u0012\u00020'0\u0002\u00a2\u0006\u0004\b)\u0010*J%\u0010,\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0014\u00a2\u0006\u0004\b,\u0010-R\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R \u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R&\u00105\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u0002048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R \u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00103\u00a8\u0006:"}, d2={"Lorg/jetbrains/exposed/sql/Database$Companion;", "", "Lkotlin/Function0;", "Ljava/sql/Connection;", "getNewConnection", "Lorg/jetbrains/exposed/sql/DatabaseConfig;", "databaseConfig", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/Database;", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "manager", "connect", "(Lkotlin/jvm/functions/Function0;Lorg/jetbrains/exposed/sql/DatabaseConfig;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/sql/Database;", "Ljavax/sql/ConnectionPoolDataSource;", "datasource", "", "setupConnection", "(Ljavax/sql/ConnectionPoolDataSource;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/exposed/sql/DatabaseConfig;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/sql/Database;", "Ljavax/sql/DataSource;", "(Ljavax/sql/DataSource;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/exposed/sql/DatabaseConfig;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/sql/Database;", "", "url", "driver", "user", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/exposed/sql/DatabaseConfig;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/sql/Database;", "connectPool", "explicitVendor", "config", "doConnect", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/DatabaseConfig;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/exposed/sql/Database;", "db", "", "getDefaultIsolationLevel", "(Lorg/jetbrains/exposed/sql/Database;)I", "getDialectName", "(Ljava/lang/String;)Ljava/lang/String;", "getDriver", "prefix", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "dialect", "registerDialect", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "driverClassName", "registerJdbcDriver", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lorg/jetbrains/exposed/sql/DatabaseConnectionAutoRegistration;", "connectionInstanceImpl", "Lorg/jetbrains/exposed/sql/DatabaseConnectionAutoRegistration;", "", "dialectMapping", "Ljava/util/Map;", "Ljava/util/concurrent/ConcurrentHashMap;", "dialects", "Ljava/util/concurrent/ConcurrentHashMap;", "driverMapping", "<init>", "()V", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerDialect(@NotNull String prefix2, @NotNull Function0<? extends DatabaseDialect> dialect2) {
            Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
            Intrinsics.checkNotNullParameter(dialect2, (String)"dialect");
            ((Map)dialects).put(prefix2, dialect2);
        }

        public final void registerJdbcDriver(@NotNull String prefix2, @NotNull String driverClassName, @NotNull String dialect2) {
            Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)driverClassName, (String)"driverClassName");
            Intrinsics.checkNotNullParameter((Object)dialect2, (String)"dialect");
            driverMapping.put(prefix2, driverClassName);
            dialectMapping.put(prefix2, dialect2);
        }

        private final Database doConnect(String explicitVendor, DatabaseConfig config2, Function0<? extends Connection> getNewConnection, Function1<? super Connection, Unit> setupConnection, Function1<? super Database, ? extends TransactionManager> manager) {
            Database database;
            DatabaseConfig databaseConfig = config2;
            if (databaseConfig == null) {
                databaseConfig = DatabaseConfig.Companion.invoke$default(DatabaseConfig.Companion, null, 1, null);
            }
            Database $this$doConnect_u24lambda_u2d0 = database = new Database(explicitVendor, databaseConfig, new Function0<ExposedConnection<?>>(getNewConnection, setupConnection){
                final /* synthetic */ Function0<Connection> $getNewConnection;
                final /* synthetic */ Function1<Connection, Unit> $setupConnection;
                {
                    this.$getNewConnection = $getNewConnection;
                    this.$setupConnection = $setupConnection;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final ExposedConnection<?> invoke() {
                    void $this$invoke_u24lambda_u2d0;
                    Object object = this.$getNewConnection.invoke();
                    Function1<Connection, Unit> function1 = this.$setupConnection;
                    Connection connection = (Connection)object;
                    DatabaseConnectionAutoRegistration databaseConnectionAutoRegistration = Database.access$getConnectionInstanceImpl$cp();
                    boolean bl = false;
                    function1.invoke((Object)$this$invoke_u24lambda_u2d0);
                    return (ExposedConnection)databaseConnectionAutoRegistration.invoke(object);
                }
            }, null);
            boolean bl = false;
            TransactionManager.Companion.registerManager($this$doConnect_u24lambda_u2d0, (TransactionManager)manager.invoke((Object)$this$doConnect_u24lambda_u2d0));
            return database;
        }

        static /* synthetic */ Database doConnect$default(Companion companion, String string, DatabaseConfig databaseConfig, Function0 function0, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = doConnect.1.INSTANCE;
            }
            if ((n & 0x10) != 0) {
                function12 = doConnect.2.INSTANCE;
            }
            return companion.doConnect(string, databaseConfig, (Function0<? extends Connection>)function0, (Function1<? super Connection, Unit>)function1, (Function1<? super Database, ? extends TransactionManager>)function12);
        }

        @NotNull
        public final Database connect(@NotNull DataSource datasource, @NotNull Function1<? super Connection, Unit> setupConnection, @Nullable DatabaseConfig databaseConfig, @NotNull Function1<? super Database, ? extends TransactionManager> manager) {
            Intrinsics.checkNotNullParameter((Object)datasource, (String)"datasource");
            Intrinsics.checkNotNullParameter(setupConnection, (String)"setupConnection");
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            return this.doConnect(null, databaseConfig, (Function0<? extends Connection>)((Function0)new Function0<Connection>(datasource){
                final /* synthetic */ DataSource $datasource;
                {
                    this.$datasource = $datasource;
                    super(0);
                }

                @NotNull
                public final Connection invoke() {
                    Connection connection = this.$datasource.getConnection();
                    Intrinsics.checkNotNull((Object)connection);
                    return connection;
                }
            }), setupConnection, manager);
        }

        public static /* synthetic */ Database connect$default(Companion companion, DataSource dataSource, Function1 function1, DatabaseConfig databaseConfig, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = connect.1.INSTANCE;
            }
            if ((n & 4) != 0) {
                databaseConfig = null;
            }
            if ((n & 8) != 0) {
                function12 = connect.2.INSTANCE;
            }
            return companion.connect(dataSource, (Function1<? super Connection, Unit>)function1, databaseConfig, (Function1<? super Database, ? extends TransactionManager>)function12);
        }

        @Deprecated(message="Use connectPool instead", replaceWith=@ReplaceWith(expression="connectPool(datasource, setupConnection, manager)", imports={}), level=DeprecationLevel.ERROR)
        @NotNull
        public final Database connect(@NotNull ConnectionPoolDataSource datasource, @NotNull Function1<? super Connection, Unit> setupConnection, @Nullable DatabaseConfig databaseConfig, @NotNull Function1<? super Database, ? extends TransactionManager> manager) {
            Intrinsics.checkNotNullParameter((Object)datasource, (String)"datasource");
            Intrinsics.checkNotNullParameter(setupConnection, (String)"setupConnection");
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            return this.doConnect(null, databaseConfig, (Function0<? extends Connection>)((Function0)new Function0<Connection>(datasource){
                final /* synthetic */ ConnectionPoolDataSource $datasource;
                {
                    this.$datasource = $datasource;
                    super(0);
                }

                @NotNull
                public final Connection invoke() {
                    Connection connection = this.$datasource.getPooledConnection().getConnection();
                    Intrinsics.checkNotNull((Object)connection);
                    return connection;
                }
            }), setupConnection, manager);
        }

        public static /* synthetic */ Database connect$default(Companion companion, ConnectionPoolDataSource connectionPoolDataSource, Function1 function1, DatabaseConfig databaseConfig, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = connect.4.INSTANCE;
            }
            if ((n & 4) != 0) {
                databaseConfig = null;
            }
            if ((n & 8) != 0) {
                function12 = connect.5.INSTANCE;
            }
            return companion.connect(connectionPoolDataSource, (Function1<? super Connection, Unit>)function1, databaseConfig, (Function1<? super Database, ? extends TransactionManager>)function12);
        }

        @NotNull
        public final Database connectPool(@NotNull ConnectionPoolDataSource datasource, @NotNull Function1<? super Connection, Unit> setupConnection, @Nullable DatabaseConfig databaseConfig, @NotNull Function1<? super Database, ? extends TransactionManager> manager) {
            Intrinsics.checkNotNullParameter((Object)datasource, (String)"datasource");
            Intrinsics.checkNotNullParameter(setupConnection, (String)"setupConnection");
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            return this.doConnect(null, databaseConfig, (Function0<? extends Connection>)((Function0)new Function0<Connection>(datasource){
                final /* synthetic */ ConnectionPoolDataSource $datasource;
                {
                    this.$datasource = $datasource;
                    super(0);
                }

                @NotNull
                public final Connection invoke() {
                    Connection connection = this.$datasource.getPooledConnection().getConnection();
                    Intrinsics.checkNotNull((Object)connection);
                    return connection;
                }
            }), setupConnection, manager);
        }

        public static /* synthetic */ Database connectPool$default(Companion companion, ConnectionPoolDataSource connectionPoolDataSource, Function1 function1, DatabaseConfig databaseConfig, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = connectPool.1.INSTANCE;
            }
            if ((n & 4) != 0) {
                databaseConfig = null;
            }
            if ((n & 8) != 0) {
                function12 = connectPool.2.INSTANCE;
            }
            return companion.connectPool(connectionPoolDataSource, (Function1<? super Connection, Unit>)function1, databaseConfig, (Function1<? super Database, ? extends TransactionManager>)function12);
        }

        @NotNull
        public final Database connect(@NotNull Function0<? extends Connection> getNewConnection, @Nullable DatabaseConfig databaseConfig, @NotNull Function1<? super Database, ? extends TransactionManager> manager) {
            Intrinsics.checkNotNullParameter(getNewConnection, (String)"getNewConnection");
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            return org.jetbrains.exposed.sql.Database$Companion.doConnect$default(this, null, databaseConfig, getNewConnection, null, manager, 8, null);
        }

        public static /* synthetic */ Database connect$default(Companion companion, Function0 function0, DatabaseConfig databaseConfig, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                databaseConfig = null;
            }
            if ((n & 4) != 0) {
                function1 = connect.7.INSTANCE;
            }
            return companion.connect((Function0<? extends Connection>)function0, databaseConfig, (Function1<? super Database, ? extends TransactionManager>)function1);
        }

        @NotNull
        public final Database connect(@NotNull String url2, @NotNull String driver, @NotNull String user, @NotNull String password, @NotNull Function1<? super Connection, Unit> setupConnection, @Nullable DatabaseConfig databaseConfig, @NotNull Function1<? super Database, ? extends TransactionManager> manager) {
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Intrinsics.checkNotNullParameter(setupConnection, (String)"setupConnection");
            Intrinsics.checkNotNullParameter(manager, (String)"manager");
            Class.forName(driver).newInstance();
            String string = this.getDialectName(url2);
            if (string == null) {
                throw new IllegalStateException(("Can't resolve dialect for connection: " + url2).toString());
            }
            String dialectName = string;
            return this.doConnect(dialectName, databaseConfig, (Function0<? extends Connection>)((Function0)new Function0<Connection>(url2, user, password){
                final /* synthetic */ String $url;
                final /* synthetic */ String $user;
                final /* synthetic */ String $password;
                {
                    this.$url = $url;
                    this.$user = $user;
                    this.$password = $password;
                    super(0);
                }

                @NotNull
                public final Connection invoke() {
                    Connection connection = DriverManager.getConnection(this.$url, this.$user, this.$password);
                    Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(url, user, password)");
                    return connection;
                }
            }), setupConnection, manager);
        }

        public static /* synthetic */ Database connect$default(Companion companion, String string, String string2, String string3, String string4, Function1 function1, DatabaseConfig databaseConfig, Function1 function12, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = companion.getDriver(string);
            }
            if ((n & 4) != 0) {
                string3 = "";
            }
            if ((n & 8) != 0) {
                string4 = "";
            }
            if ((n & 0x10) != 0) {
                function1 = connect.8.INSTANCE;
            }
            if ((n & 0x20) != 0) {
                databaseConfig = null;
            }
            if ((n & 0x40) != 0) {
                function12 = connect.9.INSTANCE;
            }
            return companion.connect(string, string2, string3, string4, (Function1<? super Connection, Unit>)function1, databaseConfig, (Function1<? super Database, ? extends TransactionManager>)function12);
        }

        public final int getDefaultIsolationLevel(@NotNull Database db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            DatabaseDialect databaseDialect = db.getDialect();
            return databaseDialect instanceof SQLiteDialect ? 8 : (databaseDialect instanceof MysqlDialect ? 4 : 2);
        }

        private final String getDriver(String url2) {
            String string;
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = driverMapping.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    String prefix2 = (String)entry.getKey();
                    if (!StringsKt.startsWith$default((String)url2, (String)prefix2, (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            if (entry == null || (string = (String)entry.getValue()) == null) {
                throw new IllegalStateException(("Database driver not found for " + url2).toString());
            }
            return string;
        }

        @Nullable
        public final String getDialectName(@NotNull String url2) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
                Iterable $this$firstOrNull$iv = dialectMapping.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    String prefix2 = (String)entry.getKey();
                    if (!StringsKt.startsWith$default((String)url2, (String)prefix2, (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            return entry != null ? (String)entry.getValue() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

