/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002\u0012\u0006\u0010\u000e\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b.\u0010/J\u001a\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\n\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\u000bJF\u0010\u0011\u001a\u00020\u00002\u0012\b\u0002\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\b\b\u0002\u0010\u000e\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0005J\u0015\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0002H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0005J\u001a\u0010\u0017\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0096\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u0002H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0005J\u0015\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001f\u0010\u000bR!\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010 \u001a\u0004\b!\u0010\u0005R\u0019\u0010\u000f\u001a\u0004\u0018\u00010\t8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\"\u001a\u0004\b#\u0010\u000bR\u0011\u0010%\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000bR\u0019\u0010\u0010\u001a\u0004\u0018\u00010\t8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\"\u001a\u0004\b&\u0010\u000bR\u0017\u0010(\u001a\u00020'8\u0006\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+R\u0017\u0010\u000e\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010,\u001a\u0004\b-\u0010\b\u00a8\u00060"}, d2={"Lorg/jetbrains/exposed/sql/Index;", "Lorg/jetbrains/exposed/sql/DdlAware;", "", "Lorg/jetbrains/exposed/sql/Column;", "component1", "()Ljava/util/List;", "", "component2", "()Z", "", "component3", "()Ljava/lang/String;", "component4", "columns", "unique", "customName", "indexType", "copy", "(Ljava/util/List;ZLjava/lang/String;Ljava/lang/String;)Lorg/jetbrains/exposed/sql/Index;", "createStatement", "dropStatement", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "modifyStatement", "onlyNameDiffer", "(Lorg/jetbrains/exposed/sql/Index;)Z", "toString", "Ljava/util/List;", "getColumns", "Ljava/lang/String;", "getCustomName", "getIndexName", "indexName", "getIndexType", "Lorg/jetbrains/exposed/sql/Table;", "table", "Lorg/jetbrains/exposed/sql/Table;", "getTable", "()Lorg/jetbrains/exposed/sql/Table;", "Z", "getUnique", "<init>", "(Ljava/util/List;ZLjava/lang/String;Ljava/lang/String;)V", "exposed-core"})
public final class Index
implements DdlAware {
    @NotNull
    private final List<Column<?>> columns;
    private final boolean unique;
    @Nullable
    private final String customName;
    @Nullable
    private final String indexType;
    @NotNull
    private final Table table;

    public Index(@NotNull List<? extends Column<?>> columns2, boolean unique, @Nullable String customName, @Nullable String indexType) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        this.columns = columns2;
        this.unique = unique;
        this.customName = customName;
        this.indexType = indexType;
        if (!(!((Collection)this.columns).isEmpty())) {
            boolean $i$a$-require-Index$22 = false;
            String $i$a$-require-Index$22 = "At least one column is required to create an index";
            throw new IllegalArgumentException($i$a$-require-Index$22.toString());
        }
        Iterable $this$distinctBy$iv = this.columns;
        boolean $i$f$distinctBy = false;
        HashSet<Table> set$iv = new HashSet<Table>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Column it = (Column)e$iv;
            boolean bl = false;
            Table key$iv = it.getTable();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        Column column = (Column)CollectionsKt.singleOrNull((List)list$iv);
        Table table = column != null ? column.getTable() : null;
        if (table == null) {
            boolean bl = false;
            String string = "Columns from different tables can't persist in one index";
            throw new IllegalArgumentException(string.toString());
        }
        this.table = table;
    }

    public /* synthetic */ Index(List list2, boolean bl, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(list2, bl, string, string2);
    }

    @NotNull
    public final List<Column<?>> getColumns() {
        return this.columns;
    }

    public final boolean getUnique() {
        return this.unique;
    }

    @Nullable
    public final String getCustomName() {
        return this.customName;
    }

    @Nullable
    public final String getIndexType() {
        return this.indexType;
    }

    @NotNull
    public final Table getTable() {
        return this.table;
    }

    @NotNull
    public final String getIndexName() {
        String string = this.customName;
        if (string == null) {
            StringBuilder stringBuilder;
            StringBuilder $this$_get_indexName__u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$_get_indexName__u24lambda_u2d0.append(this.table.nameInDatabaseCase());
            $this$_get_indexName__u24lambda_u2d0.append('_');
            $this$_get_indexName__u24lambda_u2d0.append(DefaultKt.inProperCase(CollectionsKt.joinToString$default((Iterable)this.columns, (CharSequence)"_", null, null, (int)0, null, (Function1)indexName.1.1.INSTANCE, (int)30, null)));
            if (this.unique) {
                $this$_get_indexName__u24lambda_u2d0.append(DefaultKt.inProperCase("_unique"));
            }
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> createStatement() {
        return CollectionsKt.listOf((Object)DefaultKt.getCurrentDialect().createIndex(this));
    }

    @Override
    @NotNull
    public List<String> modifyStatement() {
        return CollectionsKt.plus((Collection)this.dropStatement(), (Iterable)this.createStatement());
    }

    @Override
    @NotNull
    public List<String> dropStatement() {
        return CollectionsKt.listOf((Object)DefaultKt.getCurrentDialect().dropIndex(this.table.nameInDatabaseCase(), this.getIndexName()));
    }

    public final boolean onlyNameDiffer(@NotNull Index other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return !Intrinsics.areEqual((Object)this.getIndexName(), (Object)other.getIndexName()) && Intrinsics.areEqual(this.columns, other.columns) && this.unique == other.unique;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Index)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getIndexName(), (Object)((Index)other).getIndexName())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.columns, ((Index)other).columns)) {
            return false;
        }
        return this.unique == ((Index)other).unique;
    }

    public int hashCode() {
        int result2 = this.getIndexName().hashCode();
        result2 = 31 * result2 + ((Object)this.columns).hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.unique);
        return result2;
    }

    @NotNull
    public String toString() {
        return (this.unique ? "Unique " : "") + "Index '" + this.getIndexName() + "' for '" + this.table.nameInDatabaseCase() + "' on columns " + CollectionsKt.joinToString$default((Iterable)this.columns, null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    public final List<Column<?>> component1() {
        return this.columns;
    }

    public final boolean component2() {
        return this.unique;
    }

    @Nullable
    public final String component3() {
        return this.customName;
    }

    @Nullable
    public final String component4() {
        return this.indexType;
    }

    @NotNull
    public final Index copy(@NotNull List<? extends Column<?>> columns2, boolean unique, @Nullable String customName, @Nullable String indexType) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        return new Index(columns2, unique, customName, indexType);
    }

    public static /* synthetic */ Index copy$default(Index index, List list2, boolean bl, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = index.columns;
        }
        if ((n & 2) != 0) {
            bl = index.unique;
        }
        if ((n & 4) != 0) {
            string = index.customName;
        }
        if ((n & 8) != 0) {
            string2 = index.indexType;
        }
        return index.copy(list2, bl, string, string2);
    }
}

