/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\u00020\u00158\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaInstantColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "", "value", "", "nonNullValueToString", "(Ljava/lang/Object;)Ljava/lang/String;", "notNullValueToDB", "(Ljava/lang/Object;)Ljava/lang/Object;", "Ljava/sql/ResultSet;", "rs", "", "index", "readObject", "(Ljava/sql/ResultSet;I)Ljava/lang/Object;", "sqlType", "()Ljava/lang/String;", "Ljava/time/Instant;", "valueFromDB", "(Ljava/lang/Object;)Ljava/time/Instant;", "", "hasTimePart", "Z", "getHasTimePart", "()Z", "<init>", "()V", "Companion", "exposed-java-time"})
public final class JavaInstantColumnType
extends ColumnType
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaInstantColumnType INSTANCE = new JavaInstantColumnType();

    public JavaInstantColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().dateTimeType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value2) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof String) {
            return (String)value2;
        }
        if (object instanceof Instant) {
            instant = (Instant)value2;
        } else if (object instanceof Timestamp) {
            instant = ((Timestamp)value2).toInstant();
        } else {
            throw new IllegalStateException(("Unexpected value: " + value2 + " of " + Reflection.getOrCreateKotlinClass(value2.getClass()).getQualifiedName()).toString());
        }
        Instant instant2 = instant;
        return DefaultKt.getCurrentDialect() instanceof OracleDialect ? '\'' + JavaDateColumnTypeKt.getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(instant2) + '\'' : '\'' + JavaDateColumnTypeKt.getDEFAULT_DATE_TIME_STRING_FORMATTER().format(instant2) + '\'';
    }

    @Override
    @NotNull
    public Instant valueFromDB(@NotNull Object value2) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof Timestamp) {
            Instant instant2 = ((Timestamp)value2).toInstant();
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"value.toInstant()");
        } else if (object instanceof String) {
            Instant instant3 = Instant.parse((CharSequence)value2);
            instant = instant3;
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"parse(value)");
        } else {
            instant = this.valueFromDB(value2.toString());
        }
        return instant;
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return rs.getTimestamp(index);
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (value2 instanceof Instant && DefaultKt.getCurrentDialect() instanceof SQLiteDialect) {
            String string = JavaDateColumnTypeKt.getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format((TemporalAccessor)value2);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SQLITE_AND_ORACLE_DATE_T\u2026G_FORMATTER.format(value)");
        } else if (value2 instanceof Instant) {
            Timestamp timestamp = Timestamp.from((Instant)value2);
            object = timestamp;
            Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"from(value)");
        } else {
            object = value2;
        }
        return object;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaInstantColumnType$Companion;", "", "Lorg/jetbrains/exposed/sql/javatime/JavaInstantColumnType;", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaInstantColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaInstantColumnType;", "<init>", "()V", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaInstantColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

