/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.javatime;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0014\u001a\u00020\u00138\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "", "instant", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "longToLocalDate", "(J)Ljava/time/LocalDate;", "", "value", "", "nonNullValueToString", "(Ljava/lang/Object;)Ljava/lang/String;", "notNullValueToDB", "(Ljava/lang/Object;)Ljava/lang/Object;", "sqlType", "()Ljava/lang/String;", "valueFromDB", "", "hasTimePart", "Z", "getHasTimePart", "()Z", "<init>", "()V", "Companion", "exposed-java-time"})
public final class JavaLocalDateColumnType
extends ColumnType
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaLocalDateColumnType INSTANCE = new JavaLocalDateColumnType();

    public JavaLocalDateColumnType() {
        super(false, 1, null);
    }

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return "DATE";
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value2) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        if (object instanceof String) {
            return (String)value2;
        }
        if (object instanceof LocalDate) {
            instant = Instant.from(((LocalDate)value2).atStartOfDay(ZoneId.systemDefault()));
        } else if (object instanceof Date) {
            instant = Instant.ofEpochMilli(((Date)value2).getTime());
        } else if (object instanceof Timestamp) {
            instant = Instant.ofEpochSecond(((Timestamp)value2).getTime() / (long)1000, ((Timestamp)value2).getNanos());
        } else {
            throw new IllegalStateException(("Unexpected value: " + value2 + " of " + Reflection.getOrCreateKotlinClass(value2.getClass()).getQualifiedName()).toString());
        }
        Instant instant2 = instant;
        return '\'' + JavaDateColumnTypeKt.getDEFAULT_DATE_STRING_FORMATTER().format(instant2) + '\'';
    }

    @Override
    @NotNull
    public Object valueFromDB(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Object object = value2;
        Object object2 = object instanceof LocalDate ? value2 : (object instanceof Date ? this.longToLocalDate(((Date)value2).getTime()) : (object instanceof Timestamp ? this.longToLocalDate(((Timestamp)value2).getTime()) : (object instanceof Integer ? this.longToLocalDate(((Number)value2).intValue()) : (object instanceof Long ? this.longToLocalDate(((Number)value2).longValue()) : (object instanceof String ? (DefaultKt.getCurrentDialect() instanceof SQLiteDialect ? LocalDate.parse((CharSequence)value2) : value2) : LocalDate.parse(value2.toString()))))));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"when (value) {\n        i\u2026e(value.toString())\n    }");
        return object2;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return value2 instanceof LocalDate ? new Date(JavaDateColumnTypeKt.getMillis((LocalDate)value2)) : value2;
    }

    private final LocalDate longToLocalDate(long instant) {
        return Instant.ofEpochMilli(instant).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateColumnType$Companion;", "", "Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateColumnType;", "INSTANCE", "Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateColumnType;", "<init>", "()V", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaLocalDateColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

