/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.AbstractQuery;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011\u0012\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001b\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b \u0010!J)\u0010\u0007\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00040\u00030\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u0002*\u00020\u000e2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R!\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0018\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0018\u0010\u001aR\u001b\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006\""}, d2={"Lorg/jetbrains/exposed/sql/statements/InsertSelectStatement;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "arguments", "()Ljava/lang/Iterable;", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "", "prepareSQL", "(Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "executeInternal", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Integer;", "", "Lorg/jetbrains/exposed/sql/Column;", "columns", "Ljava/util/List;", "getColumns", "()Ljava/util/List;", "", "isIgnore", "Z", "()Z", "Lorg/jetbrains/exposed/sql/AbstractQuery;", "selectQuery", "Lorg/jetbrains/exposed/sql/AbstractQuery;", "getSelectQuery", "()Lorg/jetbrains/exposed/sql/AbstractQuery;", "<init>", "(Ljava/util/List;Lorg/jetbrains/exposed/sql/AbstractQuery;Z)V", "exposed-core"})
public class InsertSelectStatement
extends Statement<Integer> {
    @NotNull
    private final List<Column<?>> columns;
    @NotNull
    private final AbstractQuery<?> selectQuery;
    private final boolean isIgnore;

    public InsertSelectStatement(@NotNull List<? extends Column<?>> columns2, @NotNull AbstractQuery<?> selectQuery, boolean isIgnore) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Intrinsics.checkNotNullParameter(selectQuery, (String)"selectQuery");
        super(StatementType.INSERT, CollectionsKt.listOf((Object)((Column)CollectionsKt.first(columns2)).getTable()));
        this.columns = columns2;
        this.selectQuery = selectQuery;
        this.isIgnore = isIgnore;
        if (this.columns.isEmpty()) {
            throw new IllegalStateException("Can't insert without provided columns".toString());
        }
        Iterable $this$distinctBy$iv = this.columns;
        boolean $i$f$distinctBy = false;
        HashSet<Table> set$iv = new HashSet<Table>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Column it = (Column)e$iv;
            boolean bl = false;
            Table key$iv = it.getTable();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List tables = list$iv;
        if (((Collection)tables).size() > 1) {
            throw new IllegalStateException(("Can't insert to different tables " + CollectionsKt.joinToString$default((Iterable)tables, null, null, null, (int)0, null, (Function1)1.INSTANCE, (int)31, null) + " from single select").toString());
        }
        if (this.columns.size() != this.selectQuery.getSet().getFields().size()) {
            throw new IllegalStateException("Columns count doesn't equal to query columns count".toString());
        }
    }

    public /* synthetic */ InsertSelectStatement(List list2, AbstractQuery abstractQuery, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(list2, abstractQuery, bl);
    }

    @NotNull
    public final List<Column<?>> getColumns() {
        return this.columns;
    }

    @NotNull
    public final AbstractQuery<?> getSelectQuery() {
        return this.selectQuery;
    }

    public final boolean isIgnore() {
        return this.isIgnore;
    }

    @Override
    @Nullable
    public Integer executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)$this$executeInternal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        return $this$executeInternal.executeUpdate();
    }

    @Override
    @NotNull
    public Iterable<Iterable<Pair<IColumnType, Object>>> arguments() {
        return this.selectQuery.arguments();
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        return transaction2.getDb().getDialect().getFunctionProvider().insert(this.isIgnore, (Table)CollectionsKt.single(this.getTargets()), this.columns, this.selectQuery.prepareSQL(transaction2), transaction2);
    }
}

