/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.transactions;

import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.ExposedSavepoint;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b \u0010!J\u0019\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R*\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t8V@WX\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R*\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t8\u0016@WX\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006#"}, d2={"Lorg/jetbrains/exposed/sql/transactions/ThreadLocalTransactionManager;", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "", "bindTransactionToThread", "(Lorg/jetbrains/exposed/sql/Transaction;)V", "currentOrNull", "()Lorg/jetbrains/exposed/sql/Transaction;", "", "isolation", "outerTransaction", "newTransaction", "(ILorg/jetbrains/exposed/sql/Transaction;)Lorg/jetbrains/exposed/sql/Transaction;", "Lorg/jetbrains/exposed/sql/Database;", "db", "Lorg/jetbrains/exposed/sql/Database;", "<set-?>", "defaultIsolationLevel", "I", "getDefaultIsolationLevel", "()I", "setDefaultIsolationLevel", "(I)V", "defaultRepetitionAttempts", "getDefaultRepetitionAttempts", "setDefaultRepetitionAttempts", "Ljava/lang/ThreadLocal;", "threadLocal", "Ljava/lang/ThreadLocal;", "getThreadLocal", "()Ljava/lang/ThreadLocal;", "<init>", "(Lorg/jetbrains/exposed/sql/Database;)V", "ThreadLocalTransaction", "exposed-core"})
public final class ThreadLocalTransactionManager
implements TransactionManager {
    @NotNull
    private final Database db;
    private volatile int defaultRepetitionAttempts;
    private volatile int defaultIsolationLevel;
    @NotNull
    private final ThreadLocal<Transaction> threadLocal;

    public ThreadLocalTransactionManager(@NotNull Database db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.db = db;
        this.defaultRepetitionAttempts = this.db.getConfig().getDefaultRepetitionAttempts();
        this.defaultIsolationLevel = this.db.getConfig().getDefaultIsolationLevel();
        this.threadLocal = new ThreadLocal();
    }

    @Override
    public int getDefaultRepetitionAttempts() {
        return this.defaultRepetitionAttempts;
    }

    @Override
    @Deprecated(message="Use DatabaseConfig to define the defaultRepetitionAttempts")
    public void setDefaultRepetitionAttempts(int n) {
        this.defaultRepetitionAttempts = n;
    }

    @Override
    public int getDefaultIsolationLevel() {
        if (this.defaultIsolationLevel == -1) {
            this.defaultIsolationLevel = Database.Companion.getDefaultIsolationLevel(this.db);
        }
        return this.defaultIsolationLevel;
    }

    @Override
    @Deprecated(message="Use DatabaseConfig to define the defaultIsolationLevel")
    public void setDefaultIsolationLevel(int n) {
        this.defaultIsolationLevel = n;
    }

    @NotNull
    public final ThreadLocal<Transaction> getThreadLocal() {
        return this.threadLocal;
    }

    @Override
    @NotNull
    public Transaction newTransaction(int isolation, @Nullable Transaction outerTransaction) {
        Transaction transaction2;
        Transaction transaction3;
        block3: {
            block2: {
                Transaction transaction4;
                transaction3 = outerTransaction;
                if (transaction3 == null) break block2;
                Transaction it = transaction4 = transaction3;
                boolean bl = false;
                transaction3 = !this.db.getUseNestedTransactions() ? transaction4 : null;
                if (transaction3 != null) break block3;
            }
            Transaction transaction5 = outerTransaction;
            transaction3 = new Transaction(new ThreadLocalTransaction(this.db, transaction5 != null ? transaction5.getTransactionIsolation() : isolation, this.threadLocal, outerTransaction));
        }
        Transaction $this$newTransaction_u24lambda_u2d1 = transaction2 = transaction3;
        boolean bl = false;
        this.bindTransactionToThread($this$newTransaction_u24lambda_u2d1);
        return transaction2;
    }

    @Override
    @Nullable
    public Transaction currentOrNull() {
        return this.threadLocal.get();
    }

    @Override
    public void bindTransactionToThread(@Nullable Transaction transaction2) {
        if (transaction2 != null) {
            this.threadLocal.set(transaction2);
        } else {
            this.threadLocal.remove();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010&\u001a\u00020%\u0012\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140 \u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0004R\u0018\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\"\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u00070\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\u00020\u000f8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00148\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001f\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140 8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u001a\u0010&\u001a\u00020%8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,\u00a8\u0006/"}, d2={"Lorg/jetbrains/exposed/sql/transactions/ThreadLocalTransactionManager$ThreadLocalTransaction;", "Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;", "", "close", "()V", "commit", "rollback", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "getConnection", "()Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "connection", "Lkotlin/Lazy;", "", "connectionLazy", "Lkotlin/Lazy;", "Lorg/jetbrains/exposed/sql/Database;", "db", "Lorg/jetbrains/exposed/sql/Database;", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "Lorg/jetbrains/exposed/sql/Transaction;", "outerTransaction", "Lorg/jetbrains/exposed/sql/Transaction;", "getOuterTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedSavepoint;", "savepoint", "Lorg/jetbrains/exposed/sql/statements/api/ExposedSavepoint;", "", "getSavepointName", "()Ljava/lang/String;", "savepointName", "Ljava/lang/ThreadLocal;", "threadLocal", "Ljava/lang/ThreadLocal;", "getThreadLocal", "()Ljava/lang/ThreadLocal;", "", "transactionIsolation", "I", "getTransactionIsolation", "()I", "", "useSavePoints", "Z", "<init>", "(Lorg/jetbrains/exposed/sql/Database;ILjava/lang/ThreadLocal;Lorg/jetbrains/exposed/sql/Transaction;)V", "exposed-core"})
    private static final class ThreadLocalTransaction
    implements TransactionInterface {
        @NotNull
        private final Database db;
        private final int transactionIsolation;
        @NotNull
        private final ThreadLocal<Transaction> threadLocal;
        @Nullable
        private final Transaction outerTransaction;
        @NotNull
        private final Lazy<ExposedConnection<? extends Object>> connectionLazy;
        private final boolean useSavePoints;
        @Nullable
        private ExposedSavepoint savepoint;

        public ThreadLocalTransaction(@NotNull Database db, int transactionIsolation, @NotNull ThreadLocal<Transaction> threadLocal, @Nullable Transaction outerTransaction) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Intrinsics.checkNotNullParameter(threadLocal, (String)"threadLocal");
            this.db = db;
            this.transactionIsolation = transactionIsolation;
            this.threadLocal = threadLocal;
            this.outerTransaction = outerTransaction;
            this.connectionLazy = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<ExposedConnection<? extends Object>>(this){
                final /* synthetic */ ThreadLocalTransaction this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final ExposedConnection<? extends Object> invoke() {
                    Object object = this.this$0.getOuterTransaction();
                    if (object == null || (object = ((Transaction)object).getConnection()) == null) {
                        Object object2 = this.this$0.getDb().getConnector().invoke();
                        ThreadLocalTransaction threadLocalTransaction = this.this$0;
                        ExposedConnection $this$invoke_u24lambda_u2d0 = (ExposedConnection)object2;
                        boolean bl = false;
                        $this$invoke_u24lambda_u2d0.setAutoCommit(false);
                        $this$invoke_u24lambda_u2d0.setTransactionIsolation(threadLocalTransaction.getTransactionIsolation());
                        object = (ExposedConnection)object2;
                    }
                    return object;
                }
            }));
            this.useSavePoints = this.getOuterTransaction() != null && this.getDb().getUseNestedTransactions();
            this.savepoint = this.useSavePoints ? this.getConnection().setSavepoint(this.getSavepointName()) : null;
        }

        @Override
        @NotNull
        public Database getDb() {
            return this.db;
        }

        @Override
        public int getTransactionIsolation() {
            return this.transactionIsolation;
        }

        @NotNull
        public final ThreadLocal<Transaction> getThreadLocal() {
            return this.threadLocal;
        }

        @Override
        @Nullable
        public Transaction getOuterTransaction() {
            return this.outerTransaction;
        }

        @Override
        @NotNull
        public ExposedConnection<?> getConnection() {
            return (ExposedConnection)this.connectionLazy.getValue();
        }

        @Override
        public void commit() {
            if (this.connectionLazy.isInitialized() && !this.useSavePoints) {
                this.getConnection().commit();
            }
        }

        @Override
        public void rollback() {
            if (this.connectionLazy.isInitialized() && !this.getConnection().isClosed()) {
                if (this.useSavePoints && this.savepoint != null) {
                    ExposedConnection<?> exposedConnection = this.getConnection();
                    ExposedSavepoint exposedSavepoint = this.savepoint;
                    Intrinsics.checkNotNull((Object)exposedSavepoint);
                    exposedConnection.rollback(exposedSavepoint);
                    this.savepoint = this.getConnection().setSavepoint(this.getSavepointName());
                } else {
                    this.getConnection().rollback();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                if (!this.useSavePoints) {
                    if (this.connectionLazy.isInitialized()) {
                        this.getConnection().close();
                    }
                } else {
                    ExposedSavepoint exposedSavepoint = this.savepoint;
                    if (exposedSavepoint != null) {
                        ExposedSavepoint it = exposedSavepoint;
                        boolean bl = false;
                        this.getConnection().releaseSavepoint(it);
                        this.savepoint = null;
                    }
                }
            }
            finally {
                this.threadLocal.set(this.getOuterTransaction());
            }
        }

        private final String getSavepointName() {
            int nestedLevel = 0;
            Transaction currenTransaction = this.getOuterTransaction();
            while (true) {
                Transaction transaction2 = currenTransaction;
                if ((transaction2 != null ? transaction2.getOuterTransaction() : null) == null) break;
                ++nestedLevel;
                currenTransaction = currenTransaction.getOuterTransaction();
            }
            return "Exposed_savepoint_" + nestedLevel;
        }
    }
}

