/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.transactions;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.NotInitializedManager;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000e\bf\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016J\u0019\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u0007\u001a\u0004\u0018\u00010\u0002H&\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\f\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0002H&\u00a2\u0006\u0004\b\f\u0010\rR\u001c\u0010\u0012\u001a\u00020\t8&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0015\u001a\u00020\t8&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "", "bindTransactionToThread", "(Lorg/jetbrains/exposed/sql/Transaction;)V", "currentOrNull", "()Lorg/jetbrains/exposed/sql/Transaction;", "", "isolation", "outerTransaction", "newTransaction", "(ILorg/jetbrains/exposed/sql/Transaction;)Lorg/jetbrains/exposed/sql/Transaction;", "getDefaultIsolationLevel", "()I", "setDefaultIsolationLevel", "(I)V", "defaultIsolationLevel", "getDefaultRepetitionAttempts", "setDefaultRepetitionAttempts", "defaultRepetitionAttempts", "Companion", "exposed-core"})
public interface TransactionManager {
    @NotNull
    public static final Companion Companion = org.jetbrains.exposed.sql.transactions.TransactionManager$Companion.$$INSTANCE;

    public int getDefaultIsolationLevel();

    public void setDefaultIsolationLevel(int var1);

    public int getDefaultRepetitionAttempts();

    public void setDefaultRepetitionAttempts(int var1);

    @NotNull
    public Transaction newTransaction(int var1, @Nullable Transaction var2);

    @Nullable
    public Transaction currentOrNull();

    public void bindTransactionToThread(@Nullable Transaction var1);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u00011B\t\b\u0002\u00a2\u0006\u0004\b/\u00100J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u000e\u0010\tJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0018\u0010\u0019R \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R(\u0010)\u001a\u0004\u0018\u00010\u00022\b\u0010%\u001a\u0004\u0018\u00010\u00028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R \u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00120,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u00062"}, d2={"Lorg/jetbrains/exposed/sql/transactions/TransactionManager$Companion;", "", "Lorg/jetbrains/exposed/sql/Database;", "database", "", "closeAndUnregister", "(Lorg/jetbrains/exposed/sql/Database;)V", "Lorg/jetbrains/exposed/sql/Transaction;", "current", "()Lorg/jetbrains/exposed/sql/Transaction;", "", "isolation", "currentOrNew", "(I)Lorg/jetbrains/exposed/sql/Transaction;", "currentOrNull", "", "isInitialized", "()Z", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "managerFor", "(Lorg/jetbrains/exposed/sql/Database;)Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "manager", "registerManager", "(Lorg/jetbrains/exposed/sql/Database;Lorg/jetbrains/exposed/sql/transactions/TransactionManager;)V", "resetCurrent", "(Lorg/jetbrains/exposed/sql/transactions/TransactionManager;)V", "Ljava/util/concurrent/atomic/AtomicReference;", "currentDefaultDatabase", "Ljava/util/concurrent/atomic/AtomicReference;", "getCurrentDefaultDatabase$exposed_core", "()Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager$Companion$TransactionManagerThreadLocal;", "currentThreadManager", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager$Companion$TransactionManagerThreadLocal;", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "databases", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "value", "getDefaultDatabase", "()Lorg/jetbrains/exposed/sql/Database;", "setDefaultDatabase", "defaultDatabase", "getManager", "()Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "Ljava/util/concurrent/ConcurrentHashMap;", "registeredDatabases", "Ljava/util/concurrent/ConcurrentHashMap;", "<init>", "()V", "TransactionManagerThreadLocal", "exposed-core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final AtomicReference<Database> currentDefaultDatabase;
        @NotNull
        private static final ConcurrentLinkedDeque<Database> databases;
        @NotNull
        private static final ConcurrentHashMap<Database, TransactionManager> registeredDatabases;
        @NotNull
        private static final TransactionManagerThreadLocal currentThreadManager;

        private Companion() {
        }

        @NotNull
        public final AtomicReference<Database> getCurrentDefaultDatabase$exposed_core() {
            return currentDefaultDatabase;
        }

        @Nullable
        public final synchronized Database getDefaultDatabase() {
            Database database = currentDefaultDatabase.get();
            if (database == null) {
                database = (Database)CollectionsKt.firstOrNull((Iterable)databases);
            }
            return database;
        }

        public final synchronized void setDefaultDatabase(@Nullable Database value2) {
            currentDefaultDatabase.set(value2);
        }

        public final synchronized void registerManager(@NotNull Database database, @NotNull TransactionManager manager) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            if (this.getDefaultDatabase() == null) {
                currentThreadManager.remove();
            }
            if (!registeredDatabases.containsKey(database)) {
                databases.push(database);
            }
            ((Map)registeredDatabases).put(database, manager);
        }

        public final synchronized void closeAndUnregister(@NotNull Database database) {
            block1: {
                TransactionManager manager;
                Intrinsics.checkNotNullParameter((Object)database, (String)"database");
                TransactionManager transactionManager = manager = registeredDatabases.get(database);
                if (transactionManager == null) break block1;
                TransactionManager it = transactionManager;
                boolean bl = false;
                registeredDatabases.remove(database);
                databases.remove(database);
                currentDefaultDatabase.compareAndSet(database, null);
                if (currentThreadManager.isInitialized() && Intrinsics.areEqual(currentThreadManager.get(), (Object)it)) {
                    currentThreadManager.remove();
                }
            }
        }

        @Nullable
        public final TransactionManager managerFor(@Nullable Database database) {
            Database database2 = database;
            return database2 != null ? registeredDatabases.get(database2) : this.getManager();
        }

        @NotNull
        public final TransactionManager getManager() {
            Object t = currentThreadManager.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"currentThreadManager.get()");
            return (TransactionManager)t;
        }

        public final void resetCurrent(@Nullable TransactionManager manager) {
            Unit unit;
            TransactionManager transactionManager = manager;
            if (transactionManager != null) {
                TransactionManager it = transactionManager;
                boolean bl = false;
                currentThreadManager.set(it);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                currentThreadManager.remove();
            }
        }

        @NotNull
        public final Transaction currentOrNew(int isolation) {
            Transaction transaction2 = this.currentOrNull();
            if (transaction2 == null) {
                transaction2 = DefaultImpls.newTransaction$default(this.getManager(), isolation, null, 2, null);
            }
            return transaction2;
        }

        @Nullable
        public final Transaction currentOrNull() {
            return this.getManager().currentOrNull();
        }

        @NotNull
        public final Transaction current() {
            Transaction transaction2 = this.currentOrNull();
            if (transaction2 == null) {
                throw new IllegalStateException("No transaction in context.".toString());
            }
            return transaction2;
        }

        public final boolean isInitialized() {
            return this.getDefaultDatabase() != null;
        }

        static {
            $$INSTANCE = new Companion();
            currentDefaultDatabase = new AtomicReference();
            databases = new ConcurrentLinkedDeque();
            registeredDatabases = new ConcurrentHashMap();
            currentThreadManager = new TransactionManagerThreadLocal();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0007J\u000f\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\t\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/exposed/sql/transactions/TransactionManager$Companion$TransactionManagerThreadLocal;", "Ljava/lang/ThreadLocal;", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "initialValue", "()Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "", "remove", "()V", "value", "set", "(Lorg/jetbrains/exposed/sql/transactions/TransactionManager;)V", "", "isInitialized", "Z", "()Z", "setInitialized", "(Z)V", "<init>", "exposed-core"})
        private static final class TransactionManagerThreadLocal
        extends ThreadLocal<TransactionManager> {
            private boolean isInitialized;

            public final boolean isInitialized() {
                return this.isInitialized;
            }

            public final void setInitialized(boolean bl) {
                this.isInitialized = bl;
            }

            @Override
            @NotNull
            protected TransactionManager initialValue() {
                Object object;
                block3: {
                    block2: {
                        this.isInitialized = true;
                        object = $$INSTANCE.getDefaultDatabase();
                        if (object == null) break block2;
                        Database it = object;
                        boolean bl = false;
                        TransactionManager transactionManager = (TransactionManager)MapsKt.getValue((Map)registeredDatabases, (Object)it);
                        object = transactionManager;
                        if (transactionManager != null) break block3;
                    }
                    object = NotInitializedManager.INSTANCE;
                }
                return object;
            }

            @Override
            public void set(@Nullable TransactionManager value2) {
                this.isInitialized = true;
                super.set(value2);
            }

            @Override
            public void remove() {
                this.isInitialized = false;
                super.remove();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ Transaction newTransaction$default(TransactionManager transactionManager, int n, Transaction transaction2, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newTransaction");
            }
            if ((n2 & 1) != 0) {
                n = transactionManager.getDefaultIsolationLevel();
            }
            if ((n2 & 2) != 0) {
                transaction2 = null;
            }
            return transactionManager.newTransaction(n, transaction2);
        }
    }
}

