/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TextColumnType;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.H2DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0016\u0018\u0000 82\u00020\u0001:\u000289B\u0007\u00a2\u0006\u0004\b6\u00107J\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u0005J\u0017\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ5\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00130\u00122\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0019\u001a\u00020\u00182\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ)\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u001b\u0010%\u001a\u00020\u00188@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u0011\u0010&\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R\u001b\u0010+\u001a\u00020'8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\"\u001a\u0004\b)\u0010*R\u0014\u0010\u0003\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u00188\u0016X\u0096D\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u0010$R\u0014\u00102\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010$R\u001b\u00105\u001a\u00020\u00028@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\"\u001a\u0004\b4\u0010-\u00a8\u0006:"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "", "name", "createDatabase", "(Ljava/lang/String;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/Index;", "index", "createIndex", "(Lorg/jetbrains/exposed/sql/Index;)Ljava/lang/String;", "dropDatabase", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "exactH2Version", "(Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "", "Lorg/jetbrains/exposed/sql/Table;", "tables", "", "", "existingIndices", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "Lorg/jetbrains/exposed/sql/Expression;", "e", "", "isAllowedAsColumnDefault", "(Lorg/jetbrains/exposed/sql/Expression;)Z", "Lorg/jetbrains/exposed/sql/Column;", "column", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "columnDiff", "modifyColumn", "(Lorg/jetbrains/exposed/sql/Column;Lorg/jetbrains/exposed/sql/ColumnDiff;)Ljava/util/List;", "isMySQLMode$delegate", "Lkotlin/Lazy;", "isMySQLMode$exposed_core", "()Z", "isMySQLMode", "isSecondVersion", "Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2MajorVersion;", "majorVersion$delegate", "getMajorVersion$exposed_core", "()Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2MajorVersion;", "majorVersion", "getName", "()Ljava/lang/String;", "supportsMultipleGeneratedKeys", "Z", "getSupportsMultipleGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys", "version$delegate", "getVersion$exposed_core", "version", "<init>", "()V", "Companion", "H2MajorVersion", "exposed-core"})
public class H2Dialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy version$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final String invoke() {
            return H2Dialect.access$exactH2Version(this.this$0, TransactionManager.Companion.current());
        }
    }));
    @NotNull
    private final Lazy majorVersion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<H2MajorVersion>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final H2MajorVersion invoke() {
            H2MajorVersion h2MajorVersion;
            if (StringsKt.startsWith$default((String)this.this$0.getVersion$exposed_core(), (String)"1.", (boolean)false, (int)2, null)) {
                h2MajorVersion = H2MajorVersion.One;
            } else if (StringsKt.startsWith$default((String)this.this$0.getVersion$exposed_core(), (String)"2.", (boolean)false, (int)2, null)) {
                h2MajorVersion = H2MajorVersion.Two;
            } else {
                throw new IllegalStateException(("Unsupported H2 version: " + this.this$0.getVersion$exposed_core()).toString());
            }
            return h2MajorVersion;
        }
    }));
    @NotNull
    private final Lazy isMySQLMode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ H2Dialect this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final Boolean invoke() {
            Pair pair;
            switch (isMySQLMode.WhenMappings.$EnumSwitchMapping$0[this.this$0.getMajorVersion$exposed_core().ordinal()]) {
                case 1: {
                    pair = TuplesKt.to((Object)"NAME", (Object)"VALUE");
                    break;
                }
                case 2: {
                    pair = TuplesKt.to((Object)"SETTING_NAME", (Object)"SETTING_VALUE");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Pair pair2 = pair;
            String settingNameField = (String)pair2.component1();
            String settingValueField = (String)pair2.component2();
            String mySQLModeQuery = "SELECT " + settingValueField + " FROM INFORMATION_SCHEMA.SETTINGS WHERE " + settingNameField + " = 'MODE'";
            String mySQLMode2 = (String)Transaction.exec$default(TransactionManager.Companion.current(), mySQLModeQuery, null, null, (Function1)new Function1<ResultSet, String>(settingValueField){
                final /* synthetic */ String $settingValueField;
                {
                    this.$settingValueField = $settingValueField;
                    super(1);
                }

                public final String invoke(@NotNull ResultSet rs) {
                    Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                    rs.next();
                    return rs.getString(this.$settingValueField);
                }
            }, 6, null);
            return StringsKt.equals((String)mySQLMode2, (String)"MySQL", (boolean)true);
        }
    }));
    private final boolean supportsMultipleGeneratedKeys;
    @NotNull
    public static final String dialectName = "h2";

    public H2Dialect() {
        super(dialectName, H2DataTypeProvider.INSTANCE, H2FunctionProvider.INSTANCE);
    }

    @NotNull
    public final String getVersion$exposed_core() {
        Lazy lazy2 = this.version$delegate;
        return (String)lazy2.getValue();
    }

    @NotNull
    public final H2MajorVersion getMajorVersion$exposed_core() {
        Lazy lazy2 = this.majorVersion$delegate;
        return (H2MajorVersion)((Object)lazy2.getValue());
    }

    public final boolean isSecondVersion() {
        return this.getMajorVersion$exposed_core() == H2MajorVersion.Two;
    }

    private final String exactH2Version(Transaction transaction2) {
        return (String)transaction2.getDb().metadata$exposed_core(exactH2Version.1.INSTANCE);
    }

    public final boolean isMySQLMode$exposed_core() {
        Lazy lazy2 = this.isMySQLMode$delegate;
        return (Boolean)lazy2.getValue();
    }

    @Override
    @NotNull
    public String getName() {
        Transaction transaction2 = TransactionManager.Companion.currentOrNull();
        return Intrinsics.areEqual((Object)(transaction2 != null ? Boolean.valueOf(H2Kt.access$isMySQLMode(transaction2)) : null), (Object)true) ? "h2 (Mysql Mode)" : dialectName;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return !H2Kt.access$isMySQLMode(TransactionManager.Companion.current());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        Map<Table, List<Index>> $this$mapValues$iv = super.existingIndices(Arrays.copyOf(tables, tables.length));
        boolean $i$f$mapValues = false;
        Map<Table, List<Index>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterNotTo$iv$iv;
            void entry;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Iterable $this$filterNot$iv = (Iterable)entry.getValue();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Index it = (Index)element$iv$iv;
                boolean bl3 = false;
                if (StringsKt.startsWith$default((String)it.getIndexName(), (String)"PRIMARY_KEY_", (boolean)false, (int)2, null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv2;
            map4.put(k, list2);
        }
        Map $this$filterValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List it = (List)entry$iv.getValue();
            boolean bl = false;
            boolean bl4 = !((Collection)it).isEmpty();
            if (!bl4) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return true;
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Iterable $this$any$iv = index.getColumns();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Column it = (Column)element$iv;
                    boolean bl2 = false;
                    if (!(it.getColumnType() instanceof TextColumnType)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            SQLLogKt.getExposedLogger().warn("Index on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default((Iterable)index.getColumns(), null, null, null, (int)0, null, (Function1)createIndex.2.INSTANCE, (int)31, null) + " can't be created in H2");
            return "";
        }
        if (index.getIndexType() != null) {
            SQLLogKt.getExposedLogger().warn("Index of type " + index.getIndexType() + " on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default((Iterable)index.getColumns(), null, null, null, (int)0, null, (Function1)createIndex.3.INSTANCE, (int)31, null) + " can't be created in H2");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "CREATE SCHEMA IF NOT EXISTS " + DefaultKt.inProperCase(name);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
        Iterable $this$map$iv = super.modifyColumn(column, columnDiff);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, (String)"MODIFY COLUMN", (String)"ALTER COLUMN", (boolean)false, (int)4, null));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "DROP SCHEMA IF EXISTS " + DefaultKt.inProperCase(name);
    }

    public static final /* synthetic */ String access$exactH2Version(H2Dialect $this, Transaction transaction2) {
        return $this.exactH2Version(transaction2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect$H2MajorVersion;", "", "<init>", "(Ljava/lang/String;I)V", "One", "Two", "exposed-core"})
    public static final class H2MajorVersion
    extends Enum<H2MajorVersion> {
        public static final /* enum */ H2MajorVersion One = new H2MajorVersion();
        public static final /* enum */ H2MajorVersion Two = new H2MajorVersion();
        private static final /* synthetic */ H2MajorVersion[] $VALUES;

        public static H2MajorVersion[] values() {
            return (H2MajorVersion[])$VALUES.clone();
        }

        public static H2MajorVersion valueOf(String value2) {
            return Enum.valueOf(H2MajorVersion.class, value2);
        }

        static {
            $VALUES = h2MajorVersionArray = new H2MajorVersion[]{H2MajorVersion.One, H2MajorVersion.Two};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect$Companion;", "", "", "dialectName", "Ljava/lang/String;", "<init>", "()V", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

