/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.GroupConcat;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteFunctionProvider;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b<\u0010=J;\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u001a\u0010\b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\"\u0006\u0012\u0002\b\u00030\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ+\u0010\r\u001a\u00020\t\"\u0004\b\u0000\u0010\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ;\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00022\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J1\u0010\u001b\u001a\u00020\t\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ+\u0010\u001d\u001a\u00020\t\"\u0004\b\u0000\u0010\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u000eJA\u0010!\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b!\u0010\"J+\u0010#\u001a\u00020\t\"\u0004\b\u0000\u0010\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b#\u0010\u000eJ+\u0010$\u001a\u00020\t\"\u0004\b\u0000\u0010\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b$\u0010\u000eJG\u0010(\u001a\u00020\t\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b(\u0010)J?\u0010-\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00112\u001e\u0010,\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f\u0012\u0006\u0012\u0004\u0018\u00010+0*0\u001e2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b-\u0010.J+\u0010/\u001a\u00020\t\"\u0004\b\u0000\u0010\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b/\u0010\u000eJU\u00104\u001a\u00020\t\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b4\u00105JY\u00109\u001a\u00020\u00022\u0006\u00106\u001a\u00020\u00112\u001e\u00107\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f\u0012\u0006\u0012\u0004\u0018\u00010+0*0\u001e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u0001082\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b9\u0010:J+\u0010;\u001a\u00020\t\"\u0004\b\u0000\u0010\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b;\u0010\u000e\u00a8\u0006>"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLiteFunctionProvider;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "", "separator", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "queryBuilder", "", "Lorg/jetbrains/exposed/sql/Expression;", "expr", "", "concat", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/QueryBuilder;[Lorg/jetbrains/exposed/sql/Expression;)V", "T", "day", "(Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "", "ignore", "Lorg/jetbrains/exposed/sql/Table;", "table", "where", "", "limit", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "delete", "(ZLorg/jetbrains/exposed/sql/Table;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "Lorg/jetbrains/exposed/sql/GroupConcat;", "groupConcat", "(Lorg/jetbrains/exposed/sql/GroupConcat;Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "hour", "", "Lorg/jetbrains/exposed/sql/Column;", "columns", "insert", "(ZLorg/jetbrains/exposed/sql/Table;Ljava/util/List;Ljava/lang/String;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "minute", "month", "expr1", "pattern", "caseSensitive", "regexp", "(Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/Expression;ZLorg/jetbrains/exposed/sql/QueryBuilder;)V", "Lkotlin/Pair;", "", "data", "replace", "(Lorg/jetbrains/exposed/sql/Table;Ljava/util/List;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "second", "start", "length", "builder", "prefix", "substring", "(Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/QueryBuilder;Ljava/lang/String;)V", "target", "columnsAndValues", "Lorg/jetbrains/exposed/sql/Op;", "update", "(Lorg/jetbrains/exposed/sql/Table;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "year", "<init>", "()V", "exposed-core"})
public final class SQLiteFunctionProvider
extends FunctionProvider {
    @NotNull
    public static final SQLiteFunctionProvider INSTANCE = new SQLiteFunctionProvider();

    private SQLiteFunctionProvider() {
    }

    @Override
    public <T extends String> void substring(@NotNull Expression<T> expr, @NotNull Expression<Integer> start, @NotNull Expression<Integer> length, @NotNull QueryBuilder builder, @NotNull String prefix2) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(length, (String)"length");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        super.substring(expr, start, length, builder, "substr");
    }

    @Override
    public void concat(@NotNull String separator, @NotNull QueryBuilder queryBuilder, Expression<?> ... expr) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(separator, expr){
            final /* synthetic */ String $separator;
            final /* synthetic */ Expression<?>[] $expr;
            {
                this.$separator = $separator;
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                if (Intrinsics.areEqual((Object)this.$separator, (Object)"")) {
                    ExpressionKt.appendTo$default(ArraysKt.toList((Object[])this.$expr), $this$invoke, " || ", null, null, concat.1.INSTANCE, 12, null);
                } else {
                    ExpressionKt.appendTo$default(ArraysKt.toList((Object[])this.$expr), $this$invoke, " || '" + this.$separator + "' || ", null, null, concat.2.INSTANCE, 12, null);
                }
            }
        }));
    }

    @Override
    public <T extends String> void groupConcat(@NotNull GroupConcat<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Transaction tr = TransactionManager.Companion.current();
        if (!(expr.getOrderBy().length == 0)) {
            ExceptionsKt.throwUnsupportedException(tr, "SQLite doesn't support ORDER BY in GROUP_CONCAT function.");
            throw new KotlinNothingValueException();
        }
        if (expr.getDistinct()) {
            ExceptionsKt.throwUnsupportedException(tr, "SQLite doesn't support DISTINCT in GROUP_CONCAT function.");
            throw new KotlinNothingValueException();
        }
        super.groupConcat(expr, queryBuilder);
    }

    @Override
    public <T extends String> void regexp(@NotNull Expression<T> expr1, @NotNull Expression<String> pattern, boolean caseSensitive, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr1, (String)"expr1");
        Intrinsics.checkNotNullParameter(pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        ExceptionsKt.throwUnsupportedException(TransactionManager.Companion.current(), "SQLite doesn't provide built in REGEXP expression, use LIKE instead.");
        throw new KotlinNothingValueException();
    }

    @Override
    public <T> void year(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                $this$invoke.append("STRFTIME('%Y',");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        }));
    }

    @Override
    public <T> void month(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                $this$invoke.append("STRFTIME('%m',");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        }));
    }

    @Override
    public <T> void day(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                $this$invoke.append("STRFTIME('%d',");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        }));
    }

    @Override
    public <T> void hour(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                $this$invoke.append("STRFTIME('%H',");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        }));
    }

    @Override
    public <T> void minute(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                $this$invoke.append("STRFTIME('%M',");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        }));
    }

    @Override
    public <T> void second(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
                $this$invoke.append("STRFTIME('%S',");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        }));
    }

    @Override
    @NotNull
    public String insert(boolean ignore, @NotNull Table table, @NotNull List<? extends Column<?>> columns2, @NotNull String expr, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        String def = super.insert(false, table, columns2, expr, transaction2);
        return ignore ? StringsKt.replaceFirst$default((String)def, (String)"INSERT", (String)"INSERT OR IGNORE", (boolean)false, (int)4, null) : def;
    }

    @Override
    @NotNull
    public String update(@NotNull Table target, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(columnsAndValues, (String)"columnsAndValues");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        if (!SQLiteDialect.Companion.getENABLE_UPDATE_DELETE_LIMIT() && limit != null) {
            ExceptionsKt.throwUnsupportedException(transaction2, "SQLite doesn't support LIMIT in UPDATE clause.");
            throw new KotlinNothingValueException();
        }
        return super.update(target, columnsAndValues, limit, where, transaction2);
    }

    @Override
    @NotNull
    public String replace(@NotNull Table table, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> data, @NotNull Transaction transaction2) {
        QueryBuilder queryBuilder;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        QueryBuilder builder = new QueryBuilder(true);
        String columns2 = CollectionsKt.joinToString$default((Iterable)data, null, null, null, (int)0, null, (Function1)new Function1<Pair<? extends Column<?>, ? extends Object>, CharSequence>(transaction2){
            final /* synthetic */ Transaction $transaction;
            {
                this.$transaction = $transaction;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Pair<? extends Column<?>, ? extends Object> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$transaction.identity((Column)it.getFirst());
            }
        }, (int)31, null);
        QueryBuilder $this$replace_u24lambda_u2d0 = queryBuilder = builder;
        boolean bl = false;
        QueryBuilder.appendTo$default($this$replace_u24lambda_u2d0, data, null, null, null, (Function2)replace.values.1.1.INSTANCE, 7, null);
        String values2 = queryBuilder.toString();
        return "INSERT OR REPLACE INTO " + transaction2.identity(table) + " (" + columns2 + ") VALUES (" + values2 + ')';
    }

    @Override
    @NotNull
    public String delete(boolean ignore, @NotNull Table table, @Nullable String where, @Nullable Integer limit, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        if (!SQLiteDialect.Companion.getENABLE_UPDATE_DELETE_LIMIT() && limit != null) {
            ExceptionsKt.throwUnsupportedException(transaction2, "SQLite doesn't support LIMIT in DELETE clause.");
            throw new KotlinNothingValueException();
        }
        String def = super.delete(false, table, where, limit, transaction2);
        return ignore ? StringsKt.replaceFirst$default((String)def, (String)"DELETE", (String)"DELETE OR IGNORE", (boolean)false, (int)4, null) : def;
    }
}

