/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteConnection;
import org.sqlite.SQLiteJDBCLoader;
import org.sqlite.jdbc4.JDBC4Connection;

public class JDBC
implements Driver {
    public static final String PREFIX = "jdbc:sqlite:";

    @Override
    public int getMajorVersion() {
        return SQLiteJDBCLoader.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return SQLiteJDBCLoader.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public boolean acceptsURL(String url2) {
        return JDBC.isValidURL(url2);
    }

    public static boolean isValidURL(String url2) {
        return url2 != null && url2.toLowerCase().startsWith(PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url2, Properties info2) throws SQLException {
        return SQLiteConfig.getDriverPropertyInfo();
    }

    @Override
    public Connection connect(String url2, Properties info2) throws SQLException {
        return JDBC.createConnection(url2, info2);
    }

    static String extractAddress(String url2) {
        return url2.substring(PREFIX.length());
    }

    public static SQLiteConnection createConnection(String url2, Properties prop) throws SQLException {
        if (!JDBC.isValidURL(url2)) {
            return null;
        }
        url2 = url2.trim();
        return new JDBC4Connection(url2, JDBC.extractAddress(url2), prop);
    }

    static {
        try {
            DriverManager.registerDriver(new JDBC());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

