/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.worldgen.structures;

import com.jtorleonstudios.libraryferret.LibraryFerret;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function8;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2382;
import net.minecraft.class_2919;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6872;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7059;
import net.minecraft.class_7869;
import net.minecraft.class_7924;

public abstract class AwesomePlacementRndSpread
extends class_6872 {
    protected final int spacing;
    protected final int separation;
    protected final int salt;
    protected final class_6873 spreadType;
    protected final class_2382 locateOffset;
    protected final String uniqueIdentifier;
    protected final boolean useValueFromConfiguration;
    protected final Optional<SuperExclusionZone> superExclusionZone;

    public static <T extends AwesomePlacementRndSpread> Codec<T> createCodec(Function8<Integer, Integer, class_6873, Integer, class_2382, String, Boolean, Optional<SuperExclusionZone>, T> awsRandomSpread) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(AwesomePlacementRndSpread::spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(AwesomePlacementRndSpread::separation), (App)class_6873.field_36423.optionalFieldOf("spread_type", (Object)class_6873.field_36421).forGetter(AwesomePlacementRndSpread::spreadType), (App)class_5699.field_33441.fieldOf("salt").forGetter(AwesomePlacementRndSpread::salt), (App)class_2382.method_39677((int)16).optionalFieldOf("locate_offset", (Object)class_2382.field_11176).forGetter(AwesomePlacementRndSpread::locateOffset), (App)Codec.STRING.optionalFieldOf("unique_identifier", (Object)"").forGetter(AwesomePlacementRndSpread::uniqueIdentifier), (App)Codec.BOOL.optionalFieldOf("use_value_from_config_file", (Object)false).forGetter(AwesomePlacementRndSpread::useValueFromConfiguration), (App)SuperExclusionZone.CODEC.optionalFieldOf("super_exclusion_zone").forGetter(AwesomePlacementRndSpread::superExclusionZone)).apply((Applicative)i, i.stable((Object)awsRandomSpread))).flatXmap(r -> r.spacing <= r.separation ? DataResult.error(() -> "Spacing has to be larger than separation") : (r.useValueFromConfiguration && r.uniqueIdentifier.length() <= 1 ? DataResult.error(() -> "Require String field `unique_identifier` if use value from configuration") : DataResult.success((Object)r)), DataResult::success).codec();
    }

    public AwesomePlacementRndSpread(int spacing, int separation, class_6873 spreadType, int salt, class_2382 locateOffset, String uniqueIdentifier, boolean useValueFromConfiguration, Optional<SuperExclusionZone> superExclusionZone) {
        this(locateOffset, class_6874.class_7154.field_37782, 1.0f, salt, Optional.empty(), spacing, separation, spreadType, uniqueIdentifier, useValueFromConfiguration, superExclusionZone);
    }

    public AwesomePlacementRndSpread(class_2382 locateOffset, class_6874.class_7154 frequencyReductionMethod, float frequency, int salt, Optional<class_6874.class_7152> exclusionZone, int spacing, int separation, class_6873 spreadType, String uniqueIdentifier, boolean useValueFromConfiguration, Optional<SuperExclusionZone> superExclusionZone) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, exclusionZone, spacing, separation, spreadType);
        this.useValueFromConfiguration = useValueFromConfiguration;
        this.uniqueIdentifier = uniqueIdentifier;
        this.spacing = this.useValueFromConfiguration ? this.bindSpacingFromConfiguration() : spacing;
        this.separation = this.useValueFromConfiguration ? this.bindSeparationFromConfiguration() : separation;
        this.salt = this.useValueFromConfiguration ? this.bindSaltFromConfiguration() : salt;
        this.spreadType = spreadType;
        this.locateOffset = locateOffset;
        this.superExclusionZone = superExclusionZone;
        LibraryFerret.LOGGER.info(this.toString());
    }

    public class_1923 method_40169(long seed, int x, int z) {
        int i = this.spacing();
        int j = this.separation();
        int k = Math.floorDiv(x, i);
        int l = Math.floorDiv(z, i);
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(0L));
        chunkRandom.method_12665(seed, k, l, this.salt());
        int m = i - j;
        int n = this.spreadType().method_40173((class_5819)chunkRandom, m);
        int o = this.spreadType().method_40173((class_5819)chunkRandom, m);
        return new class_1923(k * i + n, l * i + o);
    }

    protected boolean method_40168(class_7869 calculator, int chunkX, int chunkZ) {
        class_1923 chunkPos = this.method_40169(calculator.method_46714(), chunkX, chunkZ);
        return chunkPos.field_9181 == chunkX && chunkPos.field_9180 == chunkZ;
    }

    public boolean method_41639(class_7869 calculator, int chunkX, int chunkZ) {
        if (!super.method_41639(calculator, chunkX, chunkZ)) {
            return false;
        }
        return this.superExclusionZone.isEmpty() || !this.superExclusionZone.get().isPlacementForbidden(calculator, chunkX, chunkZ);
    }

    public String toString() {
        return "Structure placement for `" + this.uniqueIdentifier + "`: { spacing: " + this.spacing + ", separation: " + this.separation + ", salt: " + this.salt + ", useValueFromConfiguration: " + this.useValueFromConfiguration + "}";
    }

    public abstract int bindSpacingFromConfiguration();

    public abstract int bindSeparationFromConfiguration();

    public abstract int bindSaltFromConfiguration();

    public int spacing() {
        return this.spacing;
    }

    public int separation() {
        return this.separation;
    }

    public int salt() {
        return this.salt;
    }

    public class_6873 spreadType() {
        return this.spreadType;
    }

    public class_2382 locateOffset() {
        return this.locateOffset;
    }

    private String uniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public boolean useValueFromConfiguration() {
        return this.useValueFromConfiguration;
    }

    public Optional<SuperExclusionZone> superExclusionZone() {
        return this.superExclusionZone;
    }

    public record SuperExclusionZone(class_6885<class_7059> otherSet, int chunkCount) {
        public static final Codec<SuperExclusionZone> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_6895.method_40341((class_5321)class_7924.field_41248, (Codec)class_7059.field_37195).fieldOf("other_set").forGetter(SuperExclusionZone::otherSet), (App)Codec.intRange((int)1, (int)16).fieldOf("chunk_count").forGetter(SuperExclusionZone::chunkCount)).apply((Applicative)builder, SuperExclusionZone::new));

        boolean isPlacementForbidden(class_7869 calculator, int chunkX, int chunkZ) {
            for (class_6880 holder : this.otherSet) {
                if (!calculator.method_46709(holder, chunkX, chunkZ, this.chunkCount)) continue;
                return true;
            }
            return false;
        }
    }
}

