/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcda.api;

import chronosacaria.mcda.api.AbilityHelper;
import chronosacaria.mcda.enchants.EnchantID;
import chronosacaria.mcda.registries.EnchantsRegistry;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class AOEHelper {
    public static List<class_1309> getAoeTargets(class_1309 center, class_1309 attacker, float distance) {
        return center.method_5770().method_8390(class_1309.class, new class_238(center.method_24515()).method_1014((double)distance), nearbyEntity -> AbilityHelper.isAoeTarget(nearbyEntity, attacker, center));
    }

    public static List<class_1309> getAttackersOfEntities(class_1309 affectedEntity, float distance) {
        return affectedEntity.method_5770().method_8390(class_1309.class, new class_238(affectedEntity.method_24515()).method_1014((double)distance), nearbyEntity -> nearbyEntity.method_6052() == affectedEntity);
    }

    public static void healNearbyAllies(class_1309 healer, class_1293 effectInstance, float distance) {
        if (!(healer instanceof class_1657)) {
            return;
        }
        class_1657 playerEntity = (class_1657)healer;
        class_1937 world = healer.method_5770();
        List nearbyEntities = world.method_8390(class_1309.class, new class_238(healer.method_24515()).method_1014((double)distance), nearbyEntity -> nearbyEntity != healer && AbilityHelper.canHealEntity(healer, nearbyEntity));
        for (class_1309 nearbyEntity2 : nearbyEntities) {
            if (nearbyEntity2 == null) {
                return;
            }
            if (!(nearbyEntity2.method_6032() < nearbyEntity2.method_6063())) continue;
            if (effectInstance.method_5579().method_5561()) {
                effectInstance.method_5579().method_5564((class_1297)playerEntity, (class_1297)playerEntity, nearbyEntity2, effectInstance.method_5578(), 1.0);
            } else {
                nearbyEntity2.method_6092(new class_1293(effectInstance));
            }
            AOEHelper.addParticles((class_3218)world, nearbyEntity2, (class_2394)class_2398.field_11201);
        }
    }

    public static void healNearbyAllies(class_1309 healer, float amount) {
        if (healer.method_6032() >= healer.method_6063()) {
            return;
        }
        int healAlliesLevel = class_1890.method_8203((class_1887)EnchantsRegistry.enchants.get((Object)EnchantID.HEAL_ALLIES), (class_1309)healer);
        if (healAlliesLevel <= 0) {
            return;
        }
        amount *= 0.25f * (float)healAlliesLevel;
        float distance = 12.0f;
        class_1937 world = healer.method_5770();
        List nearbyEntities = world.method_8390(class_1309.class, new class_238(healer.method_24515()).method_1014((double)distance), nearbyEntity -> nearbyEntity != healer && AbilityHelper.canHealEntity(healer, nearbyEntity));
        for (class_1309 nearbyEntity2 : nearbyEntities) {
            if (nearbyEntity2 == null) {
                return;
            }
            if (!(nearbyEntity2.method_6032() < nearbyEntity2.method_6063())) continue;
            nearbyEntity2.method_6025(amount);
            AOEHelper.addParticles((class_3218)world, nearbyEntity2, (class_2394)class_2398.field_11201);
        }
    }

    public static void burnNearbyEnemies(class_1309 attacker, float damage, float distance) {
        class_1937 world = attacker.method_5770();
        List nearbyEntities = world.method_8390(class_1309.class, new class_238(attacker.method_24515()).method_1014((double)distance), nearbyEntity -> AbilityHelper.canFireAtEnemy(attacker, nearbyEntity));
        for (class_1309 nearbyEntity2 : nearbyEntities) {
            if (nearbyEntity2 == null) {
                return;
            }
            nearbyEntity2.method_5643(nearbyEntity2.method_37908().method_48963().method_48813(), damage);
        }
    }

    public static void causeExplosion(class_1309 user, class_1309 target, float damageAmount, float distance) {
        class_1927 explosion = new class_1927(target.method_5770(), (class_1297)target, 5.0, 5.0, 5.0, 3.0f, false, class_1927.class_4179.field_40878);
        for (class_1309 nearbyEntity : AOEHelper.getAoeTargets(target, user, distance)) {
            nearbyEntity.method_5643(nearbyEntity.method_37908().method_48963().method_48807(explosion), damageAmount);
        }
    }

    private static void addParticles(class_3218 world, class_1309 nearbyEntity, class_2394 particleEffect) {
        double velX = 0.0;
        double velY = 1.0;
        double velZ = 0.0;
        double startX = nearbyEntity.method_23317() - (double)0.275f;
        double startY = nearbyEntity.method_23318();
        double startZ = nearbyEntity.method_23321() - (double)0.275f;
        for (int i = 0; i < 10; ++i) {
            class_5819 random = world.method_8409();
            double frontX = 0.5 * random.method_43058();
            world.method_14199(particleEffect, startX + frontX, startY + random.method_43058() * 0.5, startZ + 0.5, 1, velX, velY, velZ, 0.0);
            double backX = 0.5 * random.method_43058();
            world.method_14199(particleEffect, startX + backX, startY + random.method_43058() * 0.5, startZ, 1, velX, velY, velZ, 0.0);
            double leftZ = 0.5 * random.method_43058();
            world.method_14199(particleEffect, startX, startY + random.method_43058() * 0.5, startZ + leftZ, 1, velX, velY, velZ, 0.0);
            double rightZ = 0.5 * random.method_43058();
            world.method_14199(particleEffect, startX + 0.5, startY + random.method_43058() * 0.5, startZ + rightZ, 1, velX, velY, velZ, 0.0);
        }
    }

    public static void addParticlesToBlock(class_3218 world, class_2338 blockPos, class_2394 particleEffect) {
        double velX = 0.0;
        double velY = 1.0;
        double velZ = 0.0;
        double startX = (float)blockPos.method_10263() - 0.275f;
        double startY = blockPos.method_10264();
        double startZ = (float)blockPos.method_10260() - 0.275f;
        for (int i = 0; i < 10; ++i) {
            class_5819 random = world.method_8409();
            double frontX = 0.5 * random.method_43058();
            world.method_14199(particleEffect, startX + frontX, startY + random.method_43058() * 0.5, startZ + 0.5, 1, velX, velY, velZ, 0.0);
            double backX = 0.5 * random.method_43058();
            world.method_14199(particleEffect, startX + backX, startY + random.method_43058() * 0.5, startZ, 1, velX, velY, velZ, 0.0);
            double leftZ = 0.5 * random.method_43058();
            world.method_14199(particleEffect, startX, startY + random.method_43058() * 0.5, startZ + leftZ, 1, velX, velY, velZ, 0.0);
            double rightZ = 0.5 * random.method_43058();
            world.method_14199(particleEffect, startX + 0.5, startY + random.method_43058() * 0.5, startZ + rightZ, 1, velX, velY, velZ, 0.0);
        }
    }
}

