/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcda.effects;

import chronosacaria.mcda.Mcda;
import chronosacaria.mcda.api.AOECloudHelper;
import chronosacaria.mcda.api.AOEHelper;
import chronosacaria.mcda.api.AbilityHelper;
import chronosacaria.mcda.api.CleanlinessHelper;
import chronosacaria.mcda.blocks.FadingObsidianBlock;
import chronosacaria.mcda.effects.ArmorEffectID;
import chronosacaria.mcda.entities.SummonedBeeEntity;
import chronosacaria.mcda.items.ArmorSets;
import chronosacaria.mcda.mixin.PlayerTeleportationStateAccessor;
import chronosacaria.mcda.registries.BlocksRegistry;
import chronosacaria.mcda.registries.SoundsRegistry;
import chronosacaria.mcda.registries.StatusEffectsRegistry;
import chronosacaria.mcda.registries.SummonedEntityRegistry;
import java.util.List;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1543;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2360;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4019;
import net.minecraft.class_4051;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5819;

public class ArmorEffects {
    public static class_1299<SummonedBeeEntity> summonedBee = SummonedEntityRegistry.SUMMONED_BEE_ENTITY;
    public static final List<class_1291> TITAN_SHROUD_STATUS_EFFECTS_LIST = List.of(class_1294.field_5903, class_1294.field_5916, class_1294.field_5919, class_1294.field_5901, class_1294.field_5909, class_1294.field_5908, class_1294.field_5911);
    public static final List<class_1799> CAULDRONS_OVERFLOW_LIST = List.of(class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8978), class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_9005), class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8997));
    public static final List<ArmorEffectID> ARMOR_EFFECT_ID_LIST = List.of(ArmorEffectID.MYSTERY_EFFECTS, ArmorEffectID.CURIOUS_TELEPORTATION, ArmorEffectID.FIRE_RESISTANCE, ArmorEffectID.FLUID_FREEZING, ArmorEffectID.FROST_BITE_EFFECT, ArmorEffectID.GHOST_KINDLING, ArmorEffectID.GOURDIANS_HATRED, ArmorEffectID.HASTE, ArmorEffectID.HERO_OF_THE_VILLAGE, ArmorEffectID.INVISIBILITY, ArmorEffectID.LEADER_OF_THE_PACK, ArmorEffectID.LUCK, ArmorEffectID.NIMBLE_TURTLE_EFFECTS, ArmorEffectID.NO_FALL_DAMAGE, ArmorEffectID.RENEGADES_RUSH, ArmorEffectID.SHULKER_LIKE, ArmorEffectID.SLOW_FALLING, ArmorEffectID.SPIDER_CLIMBING, ArmorEffectID.SPRINTING, ArmorEffectID.STALWART_BULWARK, ArmorEffectID.SYLVAN_PRESENCE, ArmorEffectID.WATER_BREATHING, ArmorEffectID.WEB_WALKING, ArmorEffectID.WITHERED, ArmorEffectID.GHOST_KINDLER_TRAIL);
    public static final List<ArmorEffectID> RED_ARMOR_EFFECT_ID_LIST = List.of(ArmorEffectID.MYSTERY_EFFECTS, ArmorEffectID.FIRE_RESISTANCE, ArmorEffectID.GHOST_KINDLING, ArmorEffectID.GOURDIANS_HATRED, ArmorEffectID.LEADER_OF_THE_PACK, ArmorEffectID.RENEGADES_RUSH, ArmorEffectID.STALWART_BULWARK, ArmorEffectID.WITHERED, ArmorEffectID.GHOST_KINDLER_TRAIL);
    public static final List<ArmorEffectID> GREEN_ARMOR_EFFECT_ID_LIST = List.of(ArmorEffectID.MYSTERY_EFFECTS, ArmorEffectID.HASTE, ArmorEffectID.HERO_OF_THE_VILLAGE, ArmorEffectID.LUCK, ArmorEffectID.NO_FALL_DAMAGE, ArmorEffectID.SYLVAN_PRESENCE);
    public static final List<ArmorEffectID> BLUE_ARMOR_EFFECT_ID_LIST = List.of(ArmorEffectID.MYSTERY_EFFECTS, ArmorEffectID.FLUID_FREEZING, ArmorEffectID.FROST_BITE_EFFECT, ArmorEffectID.NIMBLE_TURTLE_EFFECTS, ArmorEffectID.SLOW_FALLING, ArmorEffectID.WATER_BREATHING);
    public static final List<ArmorEffectID> PURPLE_ARMOR_EFFECT_ID_LIST = List.of(ArmorEffectID.MYSTERY_EFFECTS, ArmorEffectID.CURIOUS_TELEPORTATION, ArmorEffectID.INVISIBILITY, ArmorEffectID.SHULKER_LIKE, ArmorEffectID.SPIDER_CLIMBING, ArmorEffectID.SOULDANCER_GRACE, ArmorEffectID.SPRINTING, ArmorEffectID.WEB_WALKING);

    public static int applyMysteryArmorEffect(class_1309 livingEntity, ArmorSets armorSets) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.MYSTERY_EFFECTS).booleanValue()) {
            return 0;
        }
        if (CleanlinessHelper.checkFullArmor(livingEntity, armorSets)) {
            class_1799 helmetStack = livingEntity.method_6118(class_1304.field_6169);
            class_1799 chestplateStack = livingEntity.method_6118(class_1304.field_6174);
            class_1799 leggingsStack = livingEntity.method_6118(class_1304.field_6172);
            class_1799 bootsStack = livingEntity.method_6118(class_1304.field_6166);
            int[] domArr = new int[]{0, 0, 0, 0};
            domArr[0] = helmetStack.method_7948().method_10550("dominance");
            domArr[1] = chestplateStack.method_7948().method_10550("dominance");
            domArr[2] = leggingsStack.method_7948().method_10550("dominance");
            domArr[3] = bootsStack.method_7948().method_10550("dominance");
            switch (CleanlinessHelper.mcdaIndexOfLargestElementInArray(domArr)) {
                case 0: {
                    return helmetStack.method_7948().method_10550("mystery_effect");
                }
                case 1: {
                    return chestplateStack.method_7948().method_10550("mystery_effect");
                }
                case 2: {
                    return leggingsStack.method_7948().method_10550("mystery_effect");
                }
                case 3: {
                    return bootsStack.method_7948().method_10550("mystery_effect");
                }
            }
        }
        return 0;
    }

    public static void endermanLikeTeleportEffect(class_1309 livingEntity) {
        class_1937 world = livingEntity.method_5770();
        if (!world.field_9236) {
            double zDiff;
            double teleportZ;
            double teleportY;
            double xDiff;
            double teleportX;
            if (livingEntity.method_5765()) {
                livingEntity.method_5848();
            }
            double xPos = livingEntity.method_23317();
            double yPos = livingEntity.method_23318();
            double zPos = livingEntity.method_23321();
            int i = 0;
            do {
                xDiff = (livingEntity.method_6051().method_43058() / 2.0 + 0.5) * 32.0;
                zDiff = (livingEntity.method_6051().method_43058() / 2.0 + 0.5) * 32.0;
            } while (!livingEntity.method_6082(teleportX = livingEntity.method_6051().method_43054() % 2 == 0 ? xPos + xDiff : xPos - xDiff, teleportY = class_3532.method_15350((double)(yPos + (double)(livingEntity.method_6051().method_43048(16) - 8)), (double)(world.method_8597().comp_651() + 5), (double)(world.method_31605() - 1)), teleportZ = livingEntity.method_6051().method_43054() % 2 == 0 ? zPos + zDiff : zPos - zDiff, true) && ++i != 16);
            if (i == 16 && livingEntity.method_23317() == xPos && livingEntity.method_23318() == yPos && livingEntity.method_23321() == zPos) {
                return;
            }
            class_3414 soundEvent = livingEntity instanceof class_4019 ? class_3417.field_24630 : class_3417.field_14890;
            CleanlinessHelper.playCenteredSound(livingEntity, soundEvent, 1.0f, 1.0f);
        }
    }

    public static void controlledTeleportEffect(class_1309 livingEntity) {
        class_243 target = ArmorEffects.raytraceForTeleportation(livingEntity);
        if (!livingEntity.method_5770().field_9236) {
            if (livingEntity.method_5765()) {
                livingEntity.method_5848();
            }
            if (livingEntity.method_6082(target.field_1352, target.field_1351, target.field_1350, true)) {
                class_3414 soundEvent = livingEntity instanceof class_4019 ? class_3417.field_24630 : class_3417.field_14890;
                CleanlinessHelper.playCenteredSound(livingEntity, soundEvent, 1.0f, 1.0f);
            }
        }
    }

    public static class_243 raytraceForTeleportation(class_1309 livingEntity) {
        class_1937 world = livingEntity.method_5770();
        class_243 eyeVec = livingEntity.method_5836(0.0f);
        class_243 direction = livingEntity.method_5828(0.0f);
        class_243 rayEnd = eyeVec.method_1031(direction.field_1352 * 16.0, direction.field_1351 * 16.0, direction.field_1350 * 16.0);
        class_3965 result = world.method_17742(new class_3959(eyeVec, rayEnd, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)livingEntity));
        class_2338 rayResult = result.method_17777().method_10093(result.method_17780());
        boolean positionIsFree = ArmorEffects.positionIsClear(world, rayResult);
        if (!result.method_17781()) {
            while (!positionIsFree) {
                rayResult = livingEntity.method_24515();
                boolean bl = positionIsFree = ArmorEffects.positionIsClear(world, rayResult) && world.method_17742(new class_3959(eyeVec, class_243.method_24953((class_2382)rayResult.method_10084()), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)livingEntity)).method_17783() == class_239.class_240.field_1333;
                if (rayResult.method_10264() > -60) continue;
                break;
            }
        } else if (positionIsFree) {
            class_243.method_24953((class_2382)rayResult);
        }
        return class_243.method_24953((class_2382)rayResult);
    }

    private static boolean positionIsClear(class_1937 world, class_2338 pos) {
        return (world.method_22347(pos) || world.method_8320(pos).method_26204() == class_2246.field_10428 || world.method_8320(pos).method_26204() == class_2246.field_10479 || world.method_8320(pos).method_26204() == class_2246.field_10214 && world.method_8320(pos.method_10084()).method_26204() == class_2246.field_10214 || world.method_8320(pos).method_26220((class_1922)world, pos).method_1110()) && (world.method_22347(pos.method_10084()) || world.method_8320(pos.method_10084()).method_26204() == class_2246.field_10214 || world.method_8320(pos.method_10084()).method_26220((class_1922)world, pos.method_10084()).method_1110());
    }

    public static void teleportationRobeTeleport(class_3222 playerEntity) {
        if (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.TELEPORTATION)) {
            if (playerEntity.method_5715()) {
                ((PlayerTeleportationStateAccessor)playerEntity).setInTeleportationState(true);
                ArmorEffects.endermanLikeTeleportEffect((class_1309)playerEntity);
                if (CleanlinessHelper.mcdaCooldownCheck((class_1309)playerEntity, 40)) {
                    CleanlinessHelper.mcdaRandomArmorDamage((class_1309)playerEntity, 0.1f, 4, false);
                }
            } else {
                ((PlayerTeleportationStateAccessor)playerEntity).setInTeleportationState(false);
            }
        }
    }

    public static void unstableRobeTeleport(class_3222 playerEntity) {
        if (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.UNSTABLE)) {
            if (playerEntity.method_5715()) {
                ((PlayerTeleportationStateAccessor)playerEntity).setInTeleportationState(true);
                AOECloudHelper.spawnParticleCloud((class_1309)playerEntity, (class_1309)playerEntity, 3.0f, 0, (class_2394)class_2398.field_11236);
                AOEHelper.causeExplosion((class_1309)playerEntity, (class_1309)playerEntity, 5.0f, 3.0f);
                if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.controlledTeleportation) {
                    ArmorEffects.controlledTeleportEffect((class_1309)playerEntity);
                } else {
                    ArmorEffects.endermanLikeTeleportEffect((class_1309)playerEntity);
                }
                if (CleanlinessHelper.mcdaCooldownCheck((class_1309)playerEntity, 40)) {
                    CleanlinessHelper.mcdaRandomArmorDamage((class_1309)playerEntity, 0.1f, 4, false);
                }
            } else {
                ((PlayerTeleportationStateAccessor)playerEntity).setInTeleportationState(false);
            }
        }
    }

    public static void applyFluidFreezing(class_1657 playerEntity) {
        if (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.FROST) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.FLUID_FREEZING || BLUE_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.BLUE_MYSTERY)) == ArmorEffectID.FLUID_FREEZING) {
            if (!playerEntity.method_24828()) {
                return;
            }
            class_2680 frostedIceBlockState = class_2246.field_10110.method_9564();
            class_2680 fadingObsidianBlockState = BlocksRegistry.FADING_OBSIDIAN.method_9564();
            int i = Math.min(16, 3);
            class_2338.class_2339 mutable = new class_2338.class_2339();
            class_1937 world = playerEntity.method_5770();
            class_2338 playerBlockPos = playerEntity.method_24515();
            for (class_2338 blockPos2 : class_2338.method_10097((class_2338)playerBlockPos.method_10069(-i, -1, -i), (class_2338)playerBlockPos.method_10069(i, -1, i))) {
                class_2680 blockState3;
                if (!blockPos2.method_19769((class_2374)playerEntity.method_19538(), (double)i)) continue;
                mutable.method_10103(blockPos2.method_10263(), blockPos2.method_10264() + 1, blockPos2.method_10260());
                class_2680 blockState2 = world.method_8320((class_2338)mutable);
                if (blockState2.method_26215() && (blockState3 = world.method_8320(blockPos2)).method_26204().method_9564() == class_2360.method_51170() && frostedIceBlockState.method_26184((class_4538)world, blockPos2) && world.method_8628(frostedIceBlockState, blockPos2, class_3726.method_16194())) {
                    world.method_8501(blockPos2, frostedIceBlockState);
                    world.method_39279(blockPos2, class_2246.field_10110, class_3532.method_15395((class_5819)playerEntity.method_6051(), (int)60, (int)120));
                }
                if (!blockState2.method_26215() || (blockState3 = world.method_8320(blockPos2)).method_26204().method_9564() != FadingObsidianBlock.getMeltedState() || !fadingObsidianBlockState.method_26184((class_4538)world, blockPos2) || !world.method_8628(frostedIceBlockState, blockPos2, class_3726.method_16194())) continue;
                world.method_43128(null, (double)blockPos2.method_10263(), (double)blockPos2.method_10264(), (double)blockPos2.method_10260(), class_3417.field_19198, class_3419.field_15245, 0.25f, 1.0f);
                world.method_8501(blockPos2, fadingObsidianBlockState);
                world.method_39279(blockPos2, BlocksRegistry.FADING_OBSIDIAN, class_3532.method_15395((class_5819)playerEntity.method_6051(), (int)60, (int)120));
            }
        }
    }

    public static void applyThiefInvisibilityTick(class_1657 playerEntity) {
        if (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.THIEF) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.INVISIBILITY || PURPLE_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.PURPLE_MYSTERY)) == ArmorEffectID.INVISIBILITY) {
            playerEntity.method_5648(playerEntity.method_5715());
        }
    }

    public static void applyWithered(class_1657 playerEntity, class_1309 attacker) {
        if (attacker == null) {
            return;
        }
        if (!playerEntity.method_5805()) {
            return;
        }
        if (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.WITHER) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.WITHERED || RED_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.RED_MYSTERY)) == ArmorEffectID.WITHERED) {
            attacker.method_6092(new class_1293(class_1294.field_5920, 120, 0));
        }
    }

    public static void applyNimbleTurtleEffects(class_1657 playerEntity) {
        if (!playerEntity.method_5805()) {
            return;
        }
        if (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.NIMBLE_TURTLE) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.NIMBLE_TURTLE_EFFECTS || BLUE_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.BLUE_MYSTERY)) == ArmorEffectID.NIMBLE_TURTLE_EFFECTS) {
            playerEntity.method_6092(new class_1293(class_1294.field_5907, 60, 1, false, false));
            playerEntity.method_6092(new class_1293(class_1294.field_5924, 60, 1, false, false));
        }
    }

    public static void applyTitanShroudStatuses(class_1309 livingEntity, class_1309 target) {
        if (CleanlinessHelper.checkFullArmor(livingEntity, ArmorSets.TITAN)) {
            class_1291 titanStatusEffect = TITAN_SHROUD_STATUS_EFFECTS_LIST.get(livingEntity.method_6051().method_43048(TITAN_SHROUD_STATUS_EFFECTS_LIST.size()));
            target.method_6092(new class_1293(titanStatusEffect, 60, 0));
        }
    }

    public static void applyFrostBiteStatus(class_1309 livingEntity, class_1309 target) {
        if ((CleanlinessHelper.checkFullArmor(livingEntity, ArmorSets.FROST_BITE) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect(livingEntity, ArmorSets.MYSTERY)) == ArmorEffectID.FROST_BITE_EFFECT || BLUE_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect(livingEntity, ArmorSets.BLUE_MYSTERY)) == ArmorEffectID.FROST_BITE_EFFECT) && CleanlinessHelper.percentToOccur(30)) {
            target.method_6092(new class_1293(StatusEffectsRegistry.FREEZING, 60, 0, true, true, false));
        }
    }

    public static void applyGourdiansHatredStatus(class_1309 livingEntity) {
        if (!livingEntity.method_5805()) {
            return;
        }
        if ((CleanlinessHelper.checkFullArmor(livingEntity, ArmorSets.GOURDIAN) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect(livingEntity, ArmorSets.MYSTERY)) == ArmorEffectID.GOURDIANS_HATRED || RED_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect(livingEntity, ArmorSets.RED_MYSTERY)) == ArmorEffectID.GOURDIANS_HATRED) && CleanlinessHelper.percentToOccur(15)) {
            livingEntity.method_6092(new class_1293(class_1294.field_5910, 200, 1));
        }
    }

    public static void applyCauldronsOverflow(class_1309 targetedEntity) {
        if (targetedEntity == null) {
            return;
        }
        if (CleanlinessHelper.checkFullArmor(targetedEntity, ArmorSets.CAULDRON) && CleanlinessHelper.percentToOccur(15)) {
            class_1799 potionToDrop = CAULDRONS_OVERFLOW_LIST.get(targetedEntity.method_6051().method_43048(CAULDRONS_OVERFLOW_LIST.size()));
            CleanlinessHelper.mcda$dropItem(targetedEntity, potionToDrop);
        }
    }

    public static void applyCuriousTeleportationEffect(class_1657 playerEntity, class_1309 target) {
        if (!playerEntity.method_5805()) {
            return;
        }
        if ((CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.CURIOUS) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.CURIOUS_TELEPORTATION || PURPLE_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.PURPLE_MYSTERY)) == ArmorEffectID.CURIOUS_TELEPORTATION) && CleanlinessHelper.percentToOccur(10)) {
            if (CleanlinessHelper.percentToOccur(50)) {
                ArmorEffects.endermanLikeTeleportEffect((class_1309)playerEntity);
            } else {
                ArmorEffects.endermanLikeTeleportEffect(target);
            }
        }
    }

    public static void applyGhostKindlingEffect(class_1309 livingEntity, class_1309 target) {
        if (CleanlinessHelper.checkFullArmor(livingEntity, ArmorSets.GHOST_KINDLER) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect(livingEntity, ArmorSets.MYSTERY)) == ArmorEffectID.GHOST_KINDLING || RED_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect(livingEntity, ArmorSets.RED_MYSTERY)) == ArmorEffectID.GHOST_KINDLING) {
            target.method_5639(4);
        }
    }

    public static void applySylvanPresence(class_1309 livingEntity) {
        class_1937 world = livingEntity.method_37908();
        if (world.method_8510() % 20L != 0L) {
            return;
        }
        if (!livingEntity.method_5715()) {
            return;
        }
        if (CleanlinessHelper.checkFullArmor(livingEntity, ArmorSets.VERDANT) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect(livingEntity, ArmorSets.MYSTERY)) == ArmorEffectID.SYLVAN_PRESENCE || GREEN_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect(livingEntity, ArmorSets.GREEN_MYSTERY)) == ArmorEffectID.SYLVAN_PRESENCE) {
            int size = Math.min(16, 3);
            class_2338.class_2339 mutablePosition = new class_2338.class_2339();
            class_2338 blockPos = livingEntity.method_24515();
            for (class_2338 blockPos2 : class_2338.method_10097((class_2338)blockPos.method_10069(-size, 0, -size), (class_2338)blockPos.method_10069(size, 0, size))) {
                class_2256 fertilizable;
                if (!blockPos2.method_19769((class_2374)livingEntity.method_19538(), (double)size)) continue;
                mutablePosition.method_10103(blockPos2.method_10263(), blockPos2.method_10264() + 1, blockPos2.method_10260());
                class_2680 checkstate = world.method_8320(blockPos2);
                class_2248 class_22482 = checkstate.method_26204();
                if (!(class_22482 instanceof class_2256) || !(fertilizable = (class_2256)class_22482).method_9651((class_4538)world, blockPos2, checkstate, world.field_9236) || !(world instanceof class_3218) || !fertilizable.method_9650(world, world.field_9229, blockPos2, checkstate)) continue;
                fertilizable.method_9652((class_3218)world, world.field_9229, blockPos2, checkstate);
                AOEHelper.addParticlesToBlock((class_3218)world, blockPos2, (class_2394)class_2398.field_11211);
            }
        }
    }

    public static void applyEmberJumpEffect(class_1309 livingEntity) {
        if (!CleanlinessHelper.checkFullArmor(livingEntity, ArmorSets.EMBER)) {
            return;
        }
        if (!livingEntity.method_5715()) {
            return;
        }
        boolean playFireSound = false;
        for (class_1309 nearbyEntity : AOEHelper.getAoeTargets(livingEntity, livingEntity, 6.0f)) {
            if (!(nearbyEntity instanceof class_1569)) continue;
            nearbyEntity.method_5639(5);
            playFireSound = true;
        }
        if (playFireSound) {
            if (CleanlinessHelper.mcdaCooldownCheck(livingEntity, 40)) {
                CleanlinessHelper.mcdaRandomArmorDamage(livingEntity, 0.1f, 3, true);
            }
            CleanlinessHelper.playCenteredSound(livingEntity, class_3417.field_14970, 1.0f, 1.0f);
        }
    }

    public static void applySplendidAoEAttackEffect(class_1309 livingEntity, class_1309 target) {
        if (!CleanlinessHelper.checkFullArmor(livingEntity, ArmorSets.SPLENDID)) {
            return;
        }
        if (CleanlinessHelper.percentToOccur(30)) {
            for (class_1309 nearbyEntity : AOEHelper.getAoeTargets(target, livingEntity, 6.0f)) {
                float damageToBeDone = (float)livingEntity.method_26825(class_5134.field_23721);
                if (nearbyEntity instanceof class_1543) {
                    damageToBeDone *= 1.5f;
                }
                if (!(nearbyEntity instanceof class_1569) || nearbyEntity == target) continue;
                nearbyEntity.method_5643(target.method_37908().method_48963().method_48830(), damageToBeDone);
                CleanlinessHelper.playCenteredSound(nearbyEntity, class_3417.field_14898, 1.0f, 1.0f);
                AOEHelper.addParticlesToBlock((class_3218)nearbyEntity.method_37908(), nearbyEntity.method_24515(), (class_2394)class_2398.field_11208);
            }
        }
    }

    public static float gildedHeroDamageBuff(class_1309 livingEntity, class_1309 target) {
        if (CleanlinessHelper.checkFullArmor(livingEntity, ArmorSets.GILDED)) {
            float gildedDamage = (float)livingEntity.method_26825(class_5134.field_23721);
            if (target instanceof class_1543 && livingEntity.method_6059(class_1294.field_18980)) {
                return gildedDamage * 0.5f;
            }
        }
        return 0.0f;
    }

    public static float archersProwessDamageBuff(class_1309 livingEntity) {
        if (CleanlinessHelper.checkFullArmor(livingEntity, ArmorSets.ARCHER)) {
            return 1.5f;
        }
        return 1.0f;
    }

    public static float leaderOfThePackEffect(class_1282 source) {
        UUID petOwnerUUID;
        class_1321 petSrc;
        class_1297 class_12972 = source.method_5526();
        if (!(class_12972 instanceof class_1321) || !((class_12972 = (petSrc = (class_1321)class_12972).method_37908()) instanceof class_3218)) {
            return 1.0f;
        }
        class_3218 serverWorld = (class_3218)class_12972;
        class_1309 class_13092 = petSrc.method_35057();
        if (!(class_13092 instanceof class_1657)) {
            return 1.0f;
        }
        class_1657 owner = (class_1657)class_13092;
        if ((CleanlinessHelper.checkFullArmor((class_1309)owner, ArmorSets.BLACK_WOLF) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)owner, ArmorSets.MYSTERY)) == ArmorEffectID.LEADER_OF_THE_PACK || RED_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)owner, ArmorSets.RED_MYSTERY)) == ArmorEffectID.LEADER_OF_THE_PACK) && (petOwnerUUID = owner.method_5667()) != null && serverWorld.method_14190(petOwnerUUID) instanceof class_1309) {
            return 1.5f;
        }
        return 1.0f;
    }

    public static boolean souldancerGraceEffect(class_1657 playerEntity) {
        if (!playerEntity.method_5805()) {
            return false;
        }
        if (!CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.SOULDANCER)) {
            return false;
        }
        if (CleanlinessHelper.percentToOccur(30)) {
            CleanlinessHelper.playCenteredSound((class_1309)playerEntity, SoundsRegistry.DODGE_SOUND_EVENT, 1.0f, 1.0f);
            AOECloudHelper.spawnParticleCloud((class_1309)playerEntity, (class_1309)playerEntity, 0.5f, 0, (class_2394)class_2398.field_11204);
            playerEntity.method_6092(new class_1293(class_1294.field_5904, 42, 0, false, false));
            return true;
        }
        return false;
    }

    public static boolean gildedGloryTotemEffect(class_1309 livingEntity) {
        if (CleanlinessHelper.checkFullArmor(livingEntity, ArmorSets.GILDED) && livingEntity.method_6059(class_1294.field_18980)) {
            int index = CleanlinessHelper.mcdaFindHighestDurabilityEquipment(livingEntity);
            class_1738.class_8051 equipmentSlot = switch (index) {
                case 0 -> class_1738.class_8051.field_41937;
                case 1 -> class_1738.class_8051.field_41936;
                case 2 -> class_1738.class_8051.field_41935;
                case 3 -> class_1738.class_8051.field_41934;
                default -> throw new IllegalStateException("Unexpected value: " + index);
            };
            CleanlinessHelper.mcdaDamageEquipment(livingEntity, equipmentSlot, 0.5f);
            CleanlinessHelper.onTotemDeathEffects(livingEntity);
            return true;
        }
        return false;
    }

    public static void buzzyHiveEffect(class_1309 targetedEntity) {
        class_1937 world;
        SummonedBeeEntity summonedBeeEntity;
        int beeSummonChance = 0;
        if (CleanlinessHelper.checkFullArmor(targetedEntity, ArmorSets.BEEHIVE)) {
            beeSummonChance = 30;
        }
        if (CleanlinessHelper.checkFullArmor(targetedEntity, ArmorSets.BEENEST)) {
            beeSummonChance = 10;
        }
        if (beeSummonChance == 0) {
            return;
        }
        if (CleanlinessHelper.percentToOccur(beeSummonChance) && (summonedBeeEntity = (SummonedBeeEntity)summonedBee.method_5883(world = targetedEntity.method_5770())) != null) {
            summonedBeeEntity.setSummoner((class_1297)targetedEntity);
            summonedBeeEntity.method_5808(targetedEntity.method_23317(), targetedEntity.method_23318() + 1.0, targetedEntity.method_23321(), 0.0f, 0.0f);
            world.method_8649((class_1297)summonedBeeEntity);
        }
    }

    public static boolean spiderClimbing(class_1657 playerEntity) {
        return playerEntity.field_5976 && (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.SPIDER) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.SPIDER_CLIMBING || PURPLE_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.PURPLE_MYSTERY)) == ArmorEffectID.SPIDER_CLIMBING);
    }

    public static boolean ruggedClimbing(class_1657 playerEntity) {
        if (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.RUGGED_CLIMBING_GEAR) && (CleanlinessHelper.mcdaBoundingBox(playerEntity, 0.01f) || CleanlinessHelper.mcdaBoundingBox(playerEntity, -0.01f))) {
            playerEntity.method_24830(true);
            playerEntity.method_38785();
            double f = 0.1;
            double x = class_3532.method_15350((double)playerEntity.method_18798().field_1352, (double)(-f), (double)f);
            double z = class_3532.method_15350((double)playerEntity.method_18798().field_1350, (double)(-f), (double)f);
            double y = Math.max(playerEntity.method_18798().field_1351, -f);
            if (y < 0.0 && !playerEntity.method_36601().method_27852(class_2246.field_16492) && playerEntity.method_5715()) {
                y = 0.0;
            } else if (playerEntity.field_5976 && !playerEntity.method_36601().method_27852(class_2246.field_16492) && !playerEntity.method_36601().method_27852(class_2246.field_10597)) {
                x /= 3.5;
                y = f / 2.0;
                z /= 3.5;
            }
            playerEntity.method_18800(x, y, z);
            return true;
        }
        return false;
    }

    public static float arcticFoxesHighGround(class_1309 livingEntity) {
        if (CleanlinessHelper.checkFullArmor(livingEntity, ArmorSets.ARCTIC_FOX) && livingEntity.method_18798().field_1351 < 0.0 && !livingEntity.method_24828() && !livingEntity.method_21754()) {
            return 1.2f;
        }
        return 1.0f;
    }

    public static void ghostKindlerTrail(class_1657 playerEntity, class_2338 blockPos) {
        if (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.GHOST_KINDLER) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.GHOST_KINDLER_TRAIL || RED_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.RED_MYSTERY)) == ArmorEffectID.GHOST_KINDLER_TRAIL) {
            for (class_1309 nearbyEntity : AOEHelper.getAoeTargets((class_1309)playerEntity, (class_1309)playerEntity, 3.0f)) {
                if (!(nearbyEntity instanceof class_1569) || !blockPos.method_10093(playerEntity.method_5755().method_10153()).method_19769((class_2374)nearbyEntity.method_19538(), 3.0)) continue;
                nearbyEntity.method_5639(5);
                AOEHelper.addParticlesToBlock((class_3218)playerEntity.method_37908(), playerEntity.method_24515(), (class_2394)class_2398.field_11240);
            }
        }
    }

    public static void foxPouncing(class_1657 playerEntity) {
        if (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.FOX) || CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.ARCTIC_FOX)) {
            if (!CleanlinessHelper.mcdaCheckHorizontalVelocity(playerEntity.method_18798(), 0.0, true)) {
                return;
            }
            if (!playerEntity.method_5715() || !playerEntity.method_24828()) {
                return;
            }
            class_1309 target = playerEntity.method_5770().method_18468(AbilityHelper.getPotentialPounceTargets((class_1309)playerEntity, 6.0f), class_4051.field_18092, (class_1309)playerEntity, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321());
            if (target == null) {
                return;
            }
            if (CleanlinessHelper.mcdaCanTargetEntity(playerEntity, (class_1297)target)) {
                class_243 vecHorTargetDist = new class_243(target.method_23317() - playerEntity.method_23317(), target.method_23318() - playerEntity.method_23318(), target.method_23321() - playerEntity.method_23321());
                class_243 vecVelHorTargetDist = vecHorTargetDist.method_1029().method_1021(vecHorTargetDist.method_37267() / 6.0);
                playerEntity.method_18800(vecVelHorTargetDist.field_1352 + target.method_18798().field_1352, 0.8, vecVelHorTargetDist.field_1350 + target.method_18798().field_1350);
                playerEntity.field_6037 = true;
            }
        }
    }

    public static void applyFireResistance(class_3222 playerEntity) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.FIRE_RESISTANCE).booleanValue()) {
            return;
        }
        if (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.SPROUT) || CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.LIVING_VINES) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.FIRE_RESISTANCE || RED_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.RED_MYSTERY)) == ArmorEffectID.FIRE_RESISTANCE) {
            playerEntity.method_6092(new class_1293(class_1294.field_5918, 42, 1, false, false));
        }
    }

    public static void applyHaste(class_3222 playerEntity) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.HASTE).booleanValue()) {
            return;
        }
        if (playerEntity.method_23318() < 32.0 && (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.CAVE_CRAWLER) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.HASTE || GREEN_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.GREEN_MYSTERY)) == ArmorEffectID.HASTE)) {
            playerEntity.method_6092(new class_1293(class_1294.field_5917, 42, 0, false, false));
        }
        if (playerEntity.method_23318() > 100.0 && (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.HIGHLAND) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.HASTE || GREEN_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.GREEN_MYSTERY)) == ArmorEffectID.HASTE)) {
            playerEntity.method_6092(new class_1293(class_1294.field_5917, 42, 0, false, false));
        }
    }

    public static void applyHeroOfTheVillage(class_3222 playerEntity) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.HERO_OF_THE_VILLAGE).booleanValue()) {
            return;
        }
        if (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.HERO) || CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.GILDED) && Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.GILDED_HERO).booleanValue() && playerEntity.method_6059(class_1294.field_18980) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.HERO_OF_THE_VILLAGE || GREEN_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.GREEN_MYSTERY)) == ArmorEffectID.HERO_OF_THE_VILLAGE) {
            playerEntity.method_6092(new class_1293(class_1294.field_18980, 42, 0, false, false));
        }
    }

    public static void applyHungerPain(class_3222 playerEntity) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.HUNGER).booleanValue()) {
            return;
        }
        if (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.HUNGRY_HORROR)) {
            playerEntity.method_6092(new class_1293(class_1294.field_5903, 42, 1, false, false));
            int foodLevel = playerEntity.method_7344().method_7586();
            if (foodLevel <= 18) {
                if (foodLevel > 12) {
                    class_1293 snacky = new class_1293(class_1294.field_5910, 42, 0, false, true);
                    playerEntity.method_6092(snacky);
                } else if (foodLevel > 6) {
                    class_1293 tummyGrumbles = new class_1293(class_1294.field_5910, 42, 1, false, true);
                    playerEntity.method_6016(class_1294.field_5910);
                    playerEntity.method_6092(tummyGrumbles);
                } else {
                    playerEntity.method_5643(playerEntity.method_37908().method_48963().method_48825(), 0.5f);
                    class_1293 hungerPain = new class_1293(class_1294.field_5910, 42, 2, false, true);
                    playerEntity.method_6016(class_1294.field_5910);
                    playerEntity.method_6092(hungerPain);
                }
            }
        }
    }

    public static void applyInvisibility(class_3222 playerEntity) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.INVISIBILITY).booleanValue()) {
            return;
        }
        if ((CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.THIEF) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.INVISIBILITY || PURPLE_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.PURPLE_MYSTERY)) == ArmorEffectID.INVISIBILITY) && playerEntity.method_5715()) {
            playerEntity.method_6092(new class_1293(class_1294.field_5905, 42, 0, false, false));
        }
    }

    public static void applyLuck(class_3222 playerEntity) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.LUCK).booleanValue()) {
            return;
        }
        if (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.OPULENT) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.LUCK || GREEN_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.GREEN_MYSTERY)) == ArmorEffectID.LUCK) {
            playerEntity.method_6092(new class_1293(class_1294.field_5926, 42, 0, false, false));
        }
    }

    public static void applySprintingSpeed(class_3222 playerEntity) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.SPRINTING).booleanValue()) {
            return;
        }
        if ((CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.SHADOW_WALKER) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.SPRINTING || PURPLE_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.PURPLE_MYSTERY)) == ArmorEffectID.SPRINTING) && playerEntity.method_5624()) {
            playerEntity.method_6092(new class_1293(class_1294.field_5904, 42, 0, false, false));
        }
    }

    public static void applySlowFalling(class_3222 playerEntity) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.SLOW_FALLING).booleanValue()) {
            return;
        }
        if (CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.PHANTOM) || CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.FROST_BITE) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.SLOW_FALLING || BLUE_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.BLUE_MYSTERY)) == ArmorEffectID.SLOW_FALLING) {
            playerEntity.method_6092(new class_1293(class_1294.field_5906, 42, 0, false, false));
        }
    }

    public static void applyStalwartBulwarkResistanceEffect(class_3222 playerEntity) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.STALWART_BULWARK).booleanValue()) {
            return;
        }
        if ((CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.STALWART_MAIL) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.STALWART_BULWARK || RED_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.RED_MYSTERY)) == ArmorEffectID.STALWART_BULWARK) && playerEntity.method_5715()) {
            playerEntity.method_6092(new class_1293(class_1294.field_5907, 42, 0, false, false));
        }
    }

    public static void applyWaterBreathing(class_3222 playerEntity) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.WATER_BREATHING).booleanValue()) {
            return;
        }
        if ((CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.GLOW_SQUID) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.WATER_BREATHING || BLUE_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.BLUE_MYSTERY)) == ArmorEffectID.WATER_BREATHING) && (playerEntity.method_5869() || FabricLoader.getInstance().isModLoaded("origins"))) {
            playerEntity.method_6092(new class_1293(class_1294.field_5923, 42, 0, false, false));
        }
    }

    public static void applyRenegadesRushEffect(class_3222 playerEntity) {
        if (!Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.RENEGADES_RUSH).booleanValue()) {
            return;
        }
        if ((CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.RENEGADE) || ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.MYSTERY)) == ArmorEffectID.RENEGADES_RUSH || RED_ARMOR_EFFECT_ID_LIST.get(ArmorEffects.applyMysteryArmorEffect((class_1309)playerEntity, ArmorSets.RED_MYSTERY)) == ArmorEffectID.RENEGADES_RUSH) && playerEntity.method_5624()) {
            class_1293 strength = new class_1293(class_1294.field_5910, 42, 2, false, false);
            playerEntity.method_6092(strength);
        }
    }

    public static void sweetBerrySpeed(class_3222 playerEntity) {
        if (Mcda.CONFIG.mcdaEnableEnchantAndEffectConfig.enableArmorEffect.get((Object)ArmorEffectID.SWEET_BERRY_SPEED).booleanValue() && CleanlinessHelper.checkFullArmor((class_1309)playerEntity, ArmorSets.ARCTIC_FOX) && playerEntity.method_6030().method_31574(class_1802.field_16998)) {
            playerEntity.method_6092(new class_1293(class_1294.field_5904, 200, 0, false, false));
        }
    }
}

