/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdar.artifacts;

import chronosacaria.mcdar.Mcdar;
import chronosacaria.mcdar.api.AOEHelper;
import chronosacaria.mcdar.api.AbilityHelper;
import chronosacaria.mcdar.api.CleanlinessHelper;
import chronosacaria.mcdar.api.McdarEnchantmentHelper;
import chronosacaria.mcdar.artifacts.ArtifactDefensiveItem;
import chronosacaria.mcdar.enums.DefensiveArtifactID;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7444;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class WindHornItem
extends ArtifactDefensiveItem {
    private static final String INSTRUMENT_KEY = "instrument";
    private final class_6862<class_7444> instrumentTag;

    public WindHornItem(class_6862<class_7444> instrumentTag) {
        super(DefensiveArtifactID.WIND_HORN, Mcdar.CONFIG.mcdarArtifactsStatsConfig.DEFENSIVE_ARTIFACT_STATS.get(DefensiveArtifactID.WIND_HORN).mcdar$getDurability());
        this.instrumentTag = instrumentTag;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        Optional<? extends class_6880<class_7444>> optional = this.getInstrument(itemStack);
        if (optional.isPresent()) {
            class_7444 instrument = (class_7444)optional.get().comp_349();
            user.method_6019(hand);
            WindHornItem.playSound(world, user, instrument);
            for (class_1309 nearbyEntity2 : AOEHelper.getEntitiesByPredicate((class_1309)user, 5.0f, nearbyEntity -> nearbyEntity != user && !AbilityHelper.isPetOf(nearbyEntity, (class_1309)user) && nearbyEntity.method_5805())) {
                AOEHelper.knockbackNearbyEnemies(user, nearbyEntity2, 2.0f);
            }
            if (!user.method_7337()) {
                itemStack.method_7956(1, (class_1309)user, entity -> entity.method_20236(hand));
            }
            McdarEnchantmentHelper.mcdar$cooldownHelper(user, this);
            return new class_1271(class_1269.field_5812, (Object)itemStack);
        }
        return new class_1271(class_1269.field_5814, (Object)itemStack);
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        CleanlinessHelper.createLoreTTips(stack, tooltip);
    }

    private Optional<? extends class_6880<class_7444>> getInstrument(class_1799 stack) {
        class_2960 identifier;
        class_2487 nbtCompound = stack.method_7969();
        if (nbtCompound != null && nbtCompound.method_10573(INSTRUMENT_KEY, 8) && (identifier = class_2960.method_12829((String)nbtCompound.method_10558(INSTRUMENT_KEY))) != null) {
            return class_7923.field_41166.method_40264(class_5321.method_29179((class_5321)class_7924.field_41275, (class_2960)identifier));
        }
        Iterator iterator = class_7923.field_41166.method_40286(this.instrumentTag).iterator();
        if (iterator.hasNext()) {
            return Optional.of((class_6880)iterator.next());
        }
        return Optional.empty();
    }

    private static void playSound(class_1937 world, class_1657 player, class_7444 instrument) {
        class_3414 soundEvent = (class_3414)instrument.comp_772().comp_349();
        float f = instrument.comp_774() / 16.0f;
        world.method_43129(player, (class_1297)player, soundEvent, class_3419.field_15247, f, 1.0f);
        world.method_32888(class_5712.field_39415, player.method_19538(), class_5712.class_7397.method_43285((class_1297)player));
    }
}

