/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwShortbow;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IRangedWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import org.jetbrains.annotations.NotNull;

public enum ShortbowsID implements IRangedWeaponID,
IInnateEnchantment
{
    BOW_LOVE_SPELL_BOW(true, (class_1832)class_1834.field_8923, 3.0, 9, 8.0f, "minecraft:iron_ingot"),
    BOW_MECHANICAL_SHORTBOW(true, (class_1832)class_1834.field_8923, 4.0, 9, 9.0f, "minecraft:iron_ingot"),
    BOW_PURPLE_STORM(true, (class_1832)class_1834.field_8923, 3.0, 9, 8.0f, "minecraft:iron_ingot"),
    BOW_SHORTBOW(true, (class_1832)class_1834.field_8923, 3.0, 9, 8.0f, "minecraft:planks");

    private final boolean isEnabled;
    private final class_1832 material;
    private final double projectileDamage;
    private final int drawSpeed;
    private final float range;
    private final String[] repairIngredient;

    private ShortbowsID(boolean isEnabled, class_1832 material, double projectileDamage, int drawSpeed, float range, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.projectileDamage = FabricLoader.getInstance().isModLoaded("ranged_weapon_api") ? projectileDamage : 0.0;
        this.drawSpeed = drawSpeed;
        this.range = range;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<ShortbowsID, McdwShortbow> getItemsEnum() {
        return ItemsRegistry.SHORTBOW_ITEMS;
    }

    public static HashMap<ShortbowsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SHORTBOW_SPAWN_RATES;
    }

    public static HashMap<ShortbowsID, IRangedWeaponID.RangedStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.shortbowStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.shortbowStats.get((Object)this).isEnabled;
    }

    public McdwShortbow getItem() {
        return ShortbowsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return ShortbowsID.getSpawnRates().get(this);
    }

    public HashMap<ShortbowsID, IRangedWeaponID.RangedStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.shortbowStats;
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats() {
        return ShortbowsID.getWeaponStats().get(this);
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.shortbowStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public double getProjectileDamage() {
        if (FabricLoader.getInstance().isModLoaded("ranged_weapon_api")) {
            return this.projectileDamage;
        }
        return 0.0;
    }

    @Override
    public int getDrawSpeed() {
        return this.drawSpeed;
    }

    @Override
    public float getRange() {
        return this.range;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IRangedWeaponID.RangedStats getRangedStats() {
        return new IRangedWeaponID.RangedStats().rangedStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.projectileDamage, this.drawSpeed, this.range, this.repairIngredient);
    }

    @Override
    public Map<class_1887, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case BOW_LOVE_SPELL_BOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.WILD_RAGE});
            case BOW_MECHANICAL_SHORTBOW, BOW_PURPLE_STORM -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.ACCELERATE});
            case BOW_SHORTBOW -> Map.of();
        };
    }

    @Override
    @NotNull
    public class_1799 getInnateEnchantedStack(class_1792 item) {
        return item.method_7854();
    }

    public McdwShortbow makeWeapon() {
        McdwShortbow mcdwShortbow = new McdwShortbow(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().drawSpeed, this.getWeaponItemStats().range, this.getWeaponItemStats().repairIngredient);
        ShortbowsID.getItemsEnum().put(this, mcdwShortbow);
        return mcdwShortbow;
    }
}

