/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.entity;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.entity.ISummon;
import dev.muon.medievalorigins.entity.SummonTracker;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_5425;

public class SummonEntityAction {
    private static final int MAX_SUMMONS = 5;

    public static void action(SerializableData.Instance data, class_1297 caster) {
        if (!caster.method_37908().method_8608() && caster instanceof class_1309) {
            class_1309 livingCaster = (class_1309)caster;
            class_3218 serverWorld = (class_3218)caster.method_37908();
            Integer duration = (Integer)data.get("duration");
            class_1299 entityType = (class_1299)data.get("entity_type");
            class_2487 entityNbt = (class_2487)data.get("tag");
            class_1799 weapon = (class_1799)data.get("weapon");
            Optional entityToSpawnOpt = MiscUtil.getEntityWithPassengers((class_1937)serverWorld, (class_1299)entityType, (class_2487)entityNbt, (class_243)caster.method_19538(), (float)caster.method_36454(), (float)caster.method_36455());
            if (entityToSpawnOpt.isEmpty()) {
                return;
            }
            class_1297 entityToSpawn = (class_1297)entityToSpawnOpt.get();
            if (entityToSpawn instanceof class_1308) {
                class_1308 mob = (class_1308)entityToSpawn;
                class_1266 difficulty = serverWorld.method_8404(mob.method_24515());
                mob.method_5943((class_5425)serverWorld, difficulty, class_3730.field_16471, null, entityNbt);
                mob.method_5971();
            }
            if (entityToSpawn instanceof ISummon) {
                ISummon summon = (ISummon)entityToSpawn;
                if (duration != null) {
                    summon.setLifeTicks(duration);
                    summon.setIsLimitedLife(true);
                } else {
                    summon.setIsLimitedLife(false);
                }
                summon.setOwner(livingCaster);
                summon.setOwnerID(caster.method_5667());
                if (weapon != null && !weapon.method_7960()) {
                    summon.setWeapon(weapon);
                }
            }
            serverWorld.method_30736(entityToSpawn);
            SummonEntityAction.manageSummonLimit(caster);
            data.ifPresent("entity_action", entityAction -> entityAction.accept(entityToSpawn));
            data.ifPresent("bientity_action", biEntityAction -> biEntityAction.accept(new class_3545((Object)caster, (Object)entityToSpawn)));
        }
    }

    private static void manageSummonLimit(class_1297 owner) {
        Collection<ISummon> existingSummons = SummonTracker.getSummonsForOwner(owner.method_5667());
        if (existingSummons.size() >= 5) {
            List summonsList = existingSummons.stream().sorted(SummonEntityAction.createSummonComparator()).collect(Collectors.toList());
            ISummon toRemove = (ISummon)summonsList.get(0);
            class_1308 mobToRemove = toRemove.getSelfAsMob();
            if (owner instanceof class_1657) {
                class_1657 player = (class_1657)owner;
                int x = (int)Math.round(mobToRemove.method_23317());
                int y = (int)Math.round(mobToRemove.method_23318());
                int z = (int)Math.round(mobToRemove.method_23321());
                String dimension = mobToRemove.method_37908().method_27983().method_29177().method_12832();
                class_5250 message = class_2561.method_43471((String)"message.medievalorigins.summon_limit_reached").method_27693(" ").method_10852(mobToRemove.method_5476()).method_27693(" ").method_10852((class_2561)class_2561.method_43469((String)"message.medievalorigins.summon_location", (Object[])new Object[]{dimension, x, y, z}));
                player.method_7353((class_2561)message, true);
            }
            mobToRemove.method_5650(class_1297.class_5529.field_26999);
            SummonTracker.untrackSummon(toRemove);
        }
    }

    private static Comparator<ISummon> createSummonComparator() {
        return (a, b) -> {
            boolean bLimited;
            class_1309 entityA = a.getLivingEntity();
            class_1309 entityB = b.getLivingEntity();
            if (entityA == null || entityB == null) {
                return entityA == null ? -1 : 1;
            }
            boolean aLimited = a.isLimitedLife();
            if (aLimited != (bLimited = b.isLimitedLife())) {
                return aLimited ? -1 : 1;
            }
            if (aLimited && bLimited) {
                return Integer.compare(a.getTicksLeft(), b.getTicksLeft());
            }
            return SummonEntityAction.compareMobTypes(SummonEntityAction.toMob(entityA), SummonEntityAction.toMob(entityB));
        };
    }

    private static class_1308 toMob(class_1309 entity) {
        return entity instanceof class_1308 ? (class_1308)entity : null;
    }

    private static int compareMobTypes(class_1308 a, class_1308 b) {
        if (a == null || b == null) {
            return a == null ? -1 : 1;
        }
        int priorityA = SummonEntityAction.getMobPriority(a);
        int priorityB = SummonEntityAction.getMobPriority(b);
        return Integer.compare(priorityA, priorityB);
    }

    private static int getMobPriority(class_1308 mob) {
        String entityId;
        return switch (entityId = mob.method_5864().toString()) {
            case "entity.medievalorigins.summon_wither_skeleton" -> 3;
            case "entity.medievalorigins.summon_skeleton" -> 2;
            case "entity.medievalorigins.summon_zombie" -> 1;
            default -> 0;
        };
    }

    public static ActionFactory<class_1297> getFactory() {
        return new ActionFactory(MedievalOrigins.loc("summon_entity"), new SerializableData().add("entity_type", SerializableDataTypes.ENTITY_TYPE).add("weapon", SerializableDataTypes.ITEM_STACK, null).add("duration", SerializableDataTypes.INT, null).add("tag", SerializableDataTypes.NBT, null).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("bientity_action", ApoliDataTypes.BIENTITY_ACTION, null), SummonEntityAction::action);
    }
}

