/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.compat;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.client.ClientTeamManager;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1937;

public class FTBTeamsUtils {
    public static boolean arePlayersInSameTeam(UUID playerId1, UUID playerId2, class_1937 world) {
        if (playerId1 == null || playerId2 == null) {
            return false;
        }
        if (playerId1.equals(playerId2)) {
            return true;
        }
        try {
            if (world.method_8608()) {
                return FTBTeamsUtils.checkClientTeamRelation(playerId1, playerId2);
            }
            return FTBTeamsUtils.checkServerTeamRelation(playerId1, playerId2);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkClientTeamRelation(UUID playerId1, UUID playerId2) {
        if (!FTBTeamsAPI.api().isClientManagerLoaded()) {
            return false;
        }
        ClientTeamManager manager = FTBTeamsAPI.api().getClientManager();
        Optional player1Known = manager.getKnownPlayer(playerId1);
        Optional player2Known = manager.getKnownPlayer(playerId2);
        if (player1Known.isEmpty() || player2Known.isEmpty()) {
            return false;
        }
        return ((KnownClientPlayer)player1Known.get()).teamId().equals(((KnownClientPlayer)player2Known.get()).teamId());
    }

    private static boolean checkServerTeamRelation(UUID playerId1, UUID playerId2) {
        if (!FTBTeamsAPI.api().isManagerLoaded()) {
            return false;
        }
        TeamManager manager = FTBTeamsAPI.api().getManager();
        return manager.arePlayersInSameTeam(playerId1, playerId2);
    }
}

