/*
 * Decompiled with CFR 0.152.
 */
package net.trique.mythiclib.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public class MythicSmithingRecipeProvider
implements class_2405 {
    private final FabricDataOutput output;
    private static final List<String> MATERIALS = List.of("netherite", "ametrine", "ruby", "topaz", "sapphire", "aquamarine", "jade", "peridot");
    private static final List<String> EQUIPMENT = List.of("sword", "pickaxe", "axe", "shovel", "hoe", "helmet", "chestplate", "leggings", "boots");

    public MythicSmithingRecipeProvider(FabricDataOutput output) {
        this.output = output;
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (String from : MATERIALS) {
            for (String to : MATERIALS) {
                if (from.equals(to)) continue;
                for (String eq : EQUIPMENT) {
                    class_2960 id = new class_2960("mythiclib", from + "_to_" + to + "_" + eq + "_smithing");
                    JsonObject json = MythicSmithingRecipeProvider.smithingTransformJson("mythicupgrades:" + to + "_upgrade_smithing_template", "mythicupgrades:" + from + "_" + eq, "mythicupgrades:" + to + "_ingot", "mythicupgrades:" + to + "_" + eq);
                    Path path = this.output.method_45973(class_7784.class_7490.field_39367, "recipes").method_44107(id);
                    futures.add(class_2405.method_10320((class_7403)writer, (JsonElement)json, (Path)path));
                }
            }
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String method_10321() {
        return "MythicLib \u2014 Full Smithing Recipe Generator (All Ingot Combinations)";
    }

    private static JsonObject smithingTransformJson(String templateItem, String baseItem, String additionItem, String resultItem) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "minecraft:smithing_transform");
        JsonObject template = new JsonObject();
        template.addProperty("item", templateItem);
        root.add("template", (JsonElement)template);
        JsonObject base = new JsonObject();
        base.addProperty("item", baseItem);
        root.add("base", (JsonElement)base);
        JsonObject addition = new JsonObject();
        addition.addProperty("item", additionItem);
        root.add("addition", (JsonElement)addition);
        JsonObject result = new JsonObject();
        result.addProperty("item", resultItem);
        root.add("result", (JsonElement)result);
        return root;
    }
}

