/*
 * Decompiled with CFR 0.152.
 */
package net.trique.mythicupgrades.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.trique.mythicupgrades.effect.MUEffects;
import net.trique.mythicupgrades.util.MUBlockTags;
import org.joml.Vector3f;

public class SpelunkerEffectRenderer {
    private static final List<class_2338> ORES_HIGHLIGHT_POSITIONS = new ArrayList<class_2338>();

    public static void clientFillRenderPositions(class_746 player) {
        if (player != null) {
            if (player.method_6059(MUEffects.SPELUNKER)) {
                SpelunkerEffectRenderer.updateOresList(player.method_23312().method_10084(), player.method_37908(), player.method_6112(MUEffects.SPELUNKER).method_5578());
            } else {
                ORES_HIGHLIGHT_POSITIONS.clear();
            }
        }
    }

    private static void updateOresList(class_2338 startPos, class_1937 level, int amplifier) {
        ORES_HIGHLIGHT_POSITIONS.clear();
        int radius = SpelunkerEffectRenderer.getRadius(amplifier);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2338 pos = startPos.method_10069(x, y, z);
                    class_2680 state = level.method_8320(pos);
                    if (!state.method_26164(MUBlockTags.SPELUNKER_OUTLINED)) continue;
                    ORES_HIGHLIGHT_POSITIONS.add(pos);
                }
            }
        }
    }

    public static void render(WorldRenderContext context) {
        SpelunkerEffectRenderer.renderOres(context);
    }

    private static void renderOres(WorldRenderContext context) {
        class_4587 stack = context.matrixStack();
        if (stack != null) {
            class_4184 cam = context.camera();
            RenderSystem.disableDepthTest();
            RenderSystem.disableCull();
            class_4587 posestack = RenderSystem.getModelViewStack();
            posestack.method_22903();
            posestack.method_34425(stack.method_23760().method_23761());
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShader(class_757::method_34535);
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            RenderSystem.lineWidth((float)2.0f);
            bufferBuilder.method_1328(class_293.class_5596.field_27377, class_290.field_29337);
            for (class_2338 pos : ORES_HIGHLIGHT_POSITIONS) {
                Vector3f cameraPos = cam.method_19326().method_46409();
                float posx = (float)pos.method_10263() - cameraPos.x();
                float posy = (float)pos.method_10264() - cameraPos.y();
                float posz = (float)pos.method_10260() - cameraPos.z();
                SpelunkerEffectRenderer.renderBlock(bufferBuilder, posx, posy, posz);
            }
            class_289.method_1348().method_1350();
            posestack.method_22909();
            RenderSystem.applyModelViewMatrix();
        }
    }

    private static void renderBlock(class_287 builder, float x, float y, float z) {
        int[][] offsets = new int[][]{{0, 0, 0}, {0, 1, 0}, {0, 0, 0}, {1, 0, 0}, {0, 0, 0}, {0, 0, 1}, {0, 1, 0}, {0, 1, 1}, {0, 1, 0}, {1, 1, 0}, {1, 1, 1}, {1, 1, 0}, {1, 1, 1}, {0, 1, 1}, {1, 1, 1}, {1, 0, 1}, {1, 0, 1}, {0, 0, 1}, {1, 0, 1}, {1, 0, 0}, {0, 0, 1}, {0, 1, 1}, {1, 0, 0}, {1, 1, 0}};
        int[][] normals = new int[][]{{0, 1, 0}, {0, -1, 0}, {1, 0, 0}, {-1, 0, 0}, {0, 0, 1}, {0, 0, -1}, {0, 0, 1}, {0, 0, -1}, {1, 0, 0}, {-1, 0, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}, {0, -1, 0}, {0, 1, 0}, {-1, 0, 0}, {1, 0, 0}, {0, 0, -1}, {0, 0, 1}, {0, 1, 0}, {0, -1, 0}, {0, 1, 0}, {0, -1, 0}};
        for (int i = 0; i < offsets.length; ++i) {
            builder.method_22912((double)(x + (float)offsets[i][0]), (double)(y + (float)offsets[i][1]), (double)(z + (float)offsets[i][2])).method_1336(255, 0, 0, 255).method_22914((float)normals[i][0], (float)normals[i][1], (float)normals[i][2]).method_1344();
        }
    }

    public static int getRadius(int amplifier) {
        return 2 * (amplifier + 1);
    }
}

