/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.command.debug;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import io.wispforest.owo.Owo;
import io.wispforest.owo.command.EnumArgumentType;
import io.wispforest.owo.command.debug.CcaDataCommand;
import io.wispforest.owo.command.debug.DumpdataCommand;
import io.wispforest.owo.command.debug.HealCommand;
import io.wispforest.owo.command.debug.MakeLootContainerCommand;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.renderdoc.RenderDoc;
import io.wispforest.owo.renderdoc.RenderdocScreen;
import io.wispforest.owo.ui.hud.HudInspectorScreen;
import io.wispforest.owo.ui.parsing.ConfigureHotReloadScreen;
import io.wispforest.owo.ui.parsing.UIModelLoader;
import java.lang.reflect.Field;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4158;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.event.Level;

@ApiStatus.Internal
public class OwoDebugCommands {
    private static final EnumArgumentType<Level> LEVEL_ARGUMENT_TYPE = EnumArgumentType.create(Level.class, "'{}' is not a valid logging level");
    private static final SuggestionProvider<class_2168> POI_TYPES = (context, builder) -> class_2172.method_9270((Iterable)class_7923.field_41128.method_10235(), (SuggestionsBuilder)builder);
    private static final SimpleCommandExceptionType NO_POI_TYPE = new SimpleCommandExceptionType((Message)class_2561.method_30163((String)"Invalid POI type"));
    public static final int GENERAL_PURPLE = 12157951;
    public static final int KEY_BLUE = 9745405;
    public static final int VALUE_BLUE = 9755391;

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"logger").then(class_2170.method_9244((String)"level", LEVEL_ARGUMENT_TYPE).executes(context -> {
                Level level = LEVEL_ARGUMENT_TYPE.get(context, "level");
                LogUtils.configureRootLoggingLevel((Level)level);
                ((class_2168)context.getSource()).method_9226(() -> TextOps.concat(Owo.PREFIX, class_2561.method_30163((String)("global logging level set to: \u00a79" + level))), false);
                return 0;
            })));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"query-poi").then(class_2170.method_9244((String)"poi_type", (ArgumentType)class_2232.method_9441()).suggests(POI_TYPES).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
                class_3222 player = ((class_2168)context.getSource()).method_44023();
                class_4158 poiType = (class_4158)class_7923.field_41128.method_17966(class_2232.method_9443((CommandContext)context, (String)"poi_type")).orElseThrow(() -> ((SimpleCommandExceptionType)NO_POI_TYPE).create());
                List entries = ((class_3218)player.method_37908()).method_19494().method_19125(type -> type.comp_349() == poiType, player.method_24515(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"), class_4153.class_4155.field_18489).toList();
                player.method_7353((class_2561)TextOps.concat(Owo.PREFIX, (class_2561)TextOps.withColor("Found \u00a7" + entries.size() + " \u00a7entr" + (entries.size() == 1 ? "y" : "ies"), TextOps.color(class_124.field_1080), 12157951, TextOps.color(class_124.field_1080))), false);
                for (class_4156 entry : entries) {
                    class_2338 entryPos = entry.method_19141();
                    String blockId = class_7923.field_41175.method_10221((Object)player.method_37908().method_8320(entryPos).method_26204()).toString();
                    String posString = "(" + entryPos.method_10263() + " " + entryPos.method_10264() + " " + entryPos.method_10260() + ")";
                    class_5250 message = TextOps.withColor("-> \u00a7" + blockId + " \u00a7" + posString, TextOps.color(class_124.field_1080), 9745405, 9755391);
                    message.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/tp " + entryPos.method_10263() + " " + entryPos.method_10264() + " " + entryPos.method_10260())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)"Click to teleport"))));
                    player.method_7353((class_2561)message, false);
                }
                return entries.size();
            }))));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"dumpfield").then(class_2170.method_9244((String)"field_name", (ArgumentType)StringArgumentType.string()).executes(context -> {
                String targetField = StringArgumentType.getString((CommandContext)context, (String)"field_name");
                class_2168 source = (class_2168)context.getSource();
                class_3222 player = source.method_44023();
                class_239 target = player.method_5745(5.0, 0.0f, false);
                if (target.method_17783() != class_239.class_240.field_1332) {
                    source.method_9213((class_2561)TextOps.concat(Owo.PREFIX, (class_2561)class_2561.method_43470((String)"You're not looking at a block")));
                    return 1;
                }
                class_2338 pos = ((class_3965)target).method_17777();
                class_2586 blockEntity = player.method_37908().method_8321(pos);
                if (blockEntity == null) {
                    source.method_9213((class_2561)TextOps.concat(Owo.PREFIX, (class_2561)class_2561.method_43470((String)"No block entity")));
                    return 1;
                }
                Class<?> blockEntityClass = blockEntity.getClass();
                try {
                    Field field = blockEntityClass.getDeclaredField(targetField);
                    if (!field.canAccess(blockEntity)) {
                        field.setAccessible(true);
                    }
                    Object value = field.get(blockEntity);
                    source.method_9226(() -> TextOps.concat(Owo.PREFIX, (class_2561)TextOps.withColor("Field value: \u00a7" + value, TextOps.color(class_124.field_1080), 9745405)), false);
                }
                catch (Exception e) {
                    source.method_9213((class_2561)TextOps.concat(Owo.PREFIX, (class_2561)class_2561.method_43470((String)("Could not access field - " + e.getClass().getSimpleName() + ": " + e.getMessage()))));
                }
                return 0;
            })));
            MakeLootContainerCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess);
            DumpdataCommand.register((CommandDispatcher<class_2168>)dispatcher);
            HealCommand.register((CommandDispatcher<class_2168>)dispatcher);
            if (FabricLoader.getInstance().isModLoaded("cardinal-components-base")) {
                CcaDataCommand.register((CommandDispatcher<class_2168>)dispatcher);
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        private static final SuggestionProvider<FabricClientCommandSource> LOADED_UI_MODELS = (context, builder) -> class_2172.method_9270(UIModelLoader.allLoadedModels(), (SuggestionsBuilder)builder);
        private static final SimpleCommandExceptionType NO_SUCH_UI_MODEL = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"No such UI model is loaded"));

        public static void register() {
            ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
                dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"owo-hud-inspect").executes(context -> {
                    class_310.method_1551().method_1507((class_437)new HudInspectorScreen());
                    return 0;
                }));
                dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"owo-ui-set-reload-path").then(ClientCommandManager.argument((String)"model-id", (ArgumentType)class_2232.method_9441()).suggests(LOADED_UI_MODELS).executes(context -> {
                    class_2960 modelId = (class_2960)context.getArgument("model-id", class_2960.class);
                    if (UIModelLoader.getPreloaded(modelId) == null) {
                        throw NO_SUCH_UI_MODEL.create();
                    }
                    class_310.method_1551().method_1507((class_437)new ConfigureHotReloadScreen(modelId, null));
                    return 0;
                })));
                if (RenderDoc.isAvailable()) {
                    dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"renderdoc").executes(context -> {
                        class_310.method_1551().method_1507((class_437)new RenderdocScreen());
                        return 1;
                    })).then(ClientCommandManager.literal((String)"comment").then(ClientCommandManager.argument((String)"capture_index", (ArgumentType)IntegerArgumentType.integer((int)0)).then(ClientCommandManager.argument((String)"comment", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
                        RenderDoc.Capture capture = RenderDoc.getCapture(IntegerArgumentType.getInteger((CommandContext)context, (String)"capture_index"));
                        if (capture == null) {
                            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)TextOps.concat(Owo.PREFIX, class_2561.method_30163((String)"no such capture")));
                            return 0;
                        }
                        RenderDoc.setCaptureComments(capture, StringArgumentType.getString((CommandContext)context, (String)"comment"));
                        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)TextOps.concat(Owo.PREFIX, class_2561.method_30163((String)"comment updated")));
                        return 1;
                    })))));
                }
            });
        }
    }
}

