/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.petshop.entity;

import com.nyfaria.petshop.block.PetBowl;
import com.nyfaria.petshop.entity.BasePet;
import com.nyfaria.petshop.entity.ai.Beg;
import com.nyfaria.petshop.entity.ai.FindPOI;
import com.nyfaria.petshop.entity.ai.GoToBowl;
import com.nyfaria.petshop.entity.ai.ModAnimalMakeLove;
import com.nyfaria.petshop.entity.enums.MovementType;
import com.nyfaria.petshop.entity.ifaces.Hungry;
import com.nyfaria.petshop.entity.ifaces.ShoulderRider;
import com.nyfaria.petshop.entity.ifaces.Thirsty;
import com.nyfaria.petshop.init.BlockStateInit;
import com.nyfaria.petshop.init.ItemInit;
import com.nyfaria.petshop.init.MemoryModuleTypeInit;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1331;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowOwner;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowTemptation;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.ItemTemptingSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.object.TriPredicate;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BaseBird
extends BasePet
implements Thirsty,
Hungry,
ShoulderRider<BaseBird> {
    public static final class_2940<Optional<UUID>> FETCH_TARGET = class_2945.method_12791(BaseBird.class, (class_2941)class_2943.field_13313);
    public static final class_2940<Float> THIRST = class_2945.method_12791(BaseBird.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Float> HUNGER = class_2945.method_12791(BaseBird.class, (class_2941)class_2943.field_13320);
    private static final String MOVE_CONTROLLER = "move_controller";
    private static final String TAIL_CONTROLLER = "tail_controller";
    private final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public float thirstLevelThreshold = 0.8f;
    public float hungerLevelThreshold = 0.2f;
    private int rideCooldownCounter;

    public BaseBird(class_1299<? extends BasePet> $$0, class_1937 $$1) {
        super($$0, $$1);
        this.field_6207 = new class_1331((class_1308)this, 10, false);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_3, -1.0f);
        this.method_5941(class_7.field_21516, -1.0f);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23720, (double)0.4f).method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23721, 2.0);
    }

    public void method_5773() {
        ++this.rideCooldownCounter;
        super.method_5773();
    }

    protected class_4095.class_5303<?> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    protected void method_5958() {
        this.tickBrain((class_1309)this);
    }

    public List<? extends ExtendedSensor<? extends BaseBird>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new ItemTemptingSensor().temptedWith((livingEntity, itemStack) -> itemStack == this.getPetItemStack()), new NearbyPlayersSensor().setRadius(50.0).setPredicate((player, wolf) -> player.method_6047().method_31574(ItemInit.DOG_TREAT.get()) || player.method_6079().method_31574(ItemInit.DOG_TREAT.get()) || player.method_5779((class_1297)wolf.method_35057())), new NearbyLivingEntitySensor()});
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FETCH_TARGET, Optional.empty());
        this.field_6011.method_12784(THIRST, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(HUNGER, (Object)Float.valueOf(1.0f));
    }

    public BrainActivityGroup<? extends BasePet> getCoreTasks() {
        return BrainActivityGroup.coreTasks((class_4097[])new class_4097[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new Beg().setBegItem(ItemInit.PEANUT.get()).setController(MOVE_CONTROLLER).setAnimation("walk"), new FindPOI().withMemory(MemoryModuleTypeInit.BOWL_POS.get()).checkState((TriPredicate<class_1937, class_2338, class_2680>)((TriPredicate)(level, pos, state) -> state.method_28498(BlockStateInit.BOWL_TYPE) && state.method_11654(BlockStateInit.BOWL_TYPE) == PetBowl.Type.WATER)).startCondition(e -> e.getThirstLevel() <= this.thirstLevelThreshold && this.canDoStuff()), new FindPOI().withMemory(MemoryModuleTypeInit.BOWL_POS.get()).checkState((TriPredicate<class_1937, class_2338, class_2680>)((TriPredicate)(level, pos, state) -> state.method_28498(BlockStateInit.BOWL_TYPE) && state.method_11654(BlockStateInit.BOWL_TYPE) == PetBowl.Type.KIBBLE)).startCondition(e -> e.getHungerLevel() <= this.hungerLevelThreshold && this.canDoStuff()), new FollowTemptation().startCondition(e -> e.getMovementType() == MovementType.WANDER), new FollowOwner().teleportToTargetAfter(50.0).startCondition(e -> e.method_6047().method_7960() && e.getMovementType() == MovementType.FOLLOW)}), new LookAtTarget().runFor(entity -> entity.method_6051().method_39332(40, 300)), new GoToBowl(), new MoveToWalkTarget().startCondition(e -> ((BasePet)((Object)e)).getMovementType() != MovementType.STAY), new ModAnimalMakeLove(this.method_5864(), 1.0f).startCondition(e -> ((BasePet)((Object)e)).getMovementType() != MovementType.STAY)});
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10548("thirst", this.getThirstLevel());
        tag.method_10548("hunger", this.getHungerLevel());
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setThirstLevel(tag.method_10583("thirst"));
        this.setHungerLevel(tag.method_10583("hunger"));
    }

    @Override
    public void performBowlAction(PetBowl.Type type) {
        if (type == PetBowl.Type.WATER) {
            this.setThirstLevel(this.getThirstLevel() + 0.2f);
        } else if (type == PetBowl.Type.KIBBLE) {
            this.setHungerLevel(this.getHungerLevel() + 0.8f);
        }
    }

    protected void method_5623(double $$0, boolean $$1, class_2680 $$2, class_2338 $$3) {
    }

    public BrainActivityGroup<? extends BasePet> getIdleTasks() {
        return BrainActivityGroup.idleTasks((class_4097[])new class_4097[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetPlayerLookTarget(), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(1.0f).startCondition(e -> e.method_35057() == null || e.getMovementType() == MovementType.WANDER), new Idle().runFor(entity -> entity.method_6051().method_43051(30, 60)).startCondition(e -> e.getMovementType() == MovementType.WANDER)})});
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, MOVE_CONTROLLER, this::moveControllerState)});
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_37908().field_9236) {
            return;
        }
        this.tickThirst();
        this.tickHunger();
        class_243 vec3 = this.method_18798();
        if (!this.method_24828() && vec3.field_1351 < 0.0) {
            this.method_18799(vec3.method_18805(1.0, 0.6, 1.0));
        }
    }

    private PlayState moveControllerState(AnimationState<BaseBird> baseDogAnimationState) {
        if (this.getMovementType() == MovementType.STAY) {
            return PlayState.STOP;
        }
        if (baseDogAnimationState.isMoving()) {
            baseDogAnimationState.setAnimation(RawAnimation.begin().thenLoop("walk"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    @Override
    public float getThirstLevel() {
        return ((Float)this.field_6011.method_12789(THIRST)).floatValue();
    }

    @Override
    public void setThirstLevel(float thirstLevel) {
        this.field_6011.method_12778(THIRST, (Object)Float.valueOf(thirstLevel));
    }

    @Override
    public void tickThirst() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.field_6012 % 40 == 0 && this.getThirstLevel() > 0.0f) {
            this.setThirstLevel(this.getThirstLevel() - 0.01f);
        }
    }

    @Override
    public boolean isTreat(class_1799 stack) {
        return stack.method_31574(ItemInit.PEANUT.get());
    }

    @Override
    public void doPetStuff(class_1657 interactingPlayer, class_1268 hand) {
        if (!interactingPlayer.method_37908().field_9236) {
            this.setEntityOnShoulder(this, (class_3222)interactingPlayer);
        }
    }

    @Override
    public void doTreatStuff(class_1657 player, class_1268 hand) {
        super.doTreatStuff(player, hand);
        this.setHungerLevel(this.getHungerLevel() + 0.1f);
    }

    @Override
    public float getHungerLevel() {
        float hungerLevel = ((Float)this.field_6011.method_12789(HUNGER)).floatValue();
        return hungerLevel;
    }

    @Override
    public void setHungerLevel(float hungerLevel) {
        this.field_6011.method_12778(HUNGER, (Object)Float.valueOf(hungerLevel));
    }

    @Override
    public void tickHunger() {
        if (this.method_37908().field_9236) {
            return;
        }
        if (this.field_6012 % 40 == 0 && this.getHungerLevel() > 0.0f) {
            this.setHungerLevel(this.getHungerLevel() - 0.01f);
        }
    }

    @Override
    public boolean canSitOnShoulder() {
        return this.rideCooldownCounter > 100;
    }

    protected class_1408 method_5965(class_1937 pLevel) {
        class_1407 flyingpathnavigation = new class_1407((class_1308)this, pLevel);
        flyingpathnavigation.method_6332(false);
        flyingpathnavigation.method_6354(true);
        flyingpathnavigation.method_6331(true);
        return flyingpathnavigation;
    }
}

