/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.petshop.entity.ai;

import com.mojang.datafixers.util.Pair;
import com.nyfaria.petshop.entity.BasePet;
import com.nyfaria.petshop.entity.ai.PetExtendedBehavior;
import com.nyfaria.petshop.entity.enums.MovementType;
import com.nyfaria.petshop.init.MemoryModuleTypeInit;
import com.nyfaria.petshop.init.POIInit;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4158;
import net.minecraft.class_6862;
import net.tslat.smartbrainlib.object.TriPredicate;
import net.tslat.smartbrainlib.util.BrainUtils;

public class FindPOI<E extends BasePet>
extends PetExtendedBehavior<E> {
    private static final List<Pair<class_4140<?>, class_4141>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of(MemoryModuleTypeInit.WAIT_TO_SEARCH_AGAIN.get(), (Object)class_4141.field_18457)});
    public class_4140<Optional<class_2338>> memoryModuleType = null;
    public class_6862<class_4158> poiTag = null;
    private TriPredicate<class_1937, class_2338, class_2680> propertyPredicate = (level, pos, property) -> true;
    private class_4153.class_4155 occupancy = class_4153.class_4155.field_18489;

    public FindPOI() {
        this.movementTypePredicate((pet, movementType) -> movementType != MovementType.STAY);
        this.cooldownFor(entity -> 200);
    }

    public FindPOI<E> withMemory(class_4140<Optional<class_2338>> memoryModuleType) {
        this.memoryModuleType = memoryModuleType;
        return this;
    }

    public FindPOI<E> withTag(class_6862<class_4158> poiTag) {
        this.poiTag = poiTag;
        return this;
    }

    public FindPOI<E> withOccupancy(class_4153.class_4155 occupancy) {
        this.occupancy = occupancy;
        return this;
    }

    public FindPOI<E> checkState(TriPredicate<class_1937, class_2338, class_2680> propertyPredicate) {
        this.propertyPredicate = propertyPredicate;
        return this;
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 level, E entity) {
        return super.checkExtraStartConditions(level, entity) && this.memoryModuleType != null && this.poiTag != null;
    }

    protected void start(class_3218 level, E entity, long gameTime) {
        super.method_18920(level, entity, gameTime);
        class_4158 poiType = POIInit.PET_BEDS.get();
        class_2338 blockpos = entity.method_24515();
        class_4153 poimanager = level.method_19494();
        Stream stream = poimanager.method_19125(poiTypeHolder -> {
            boolean isRightType = poiTypeHolder.method_40220(this.poiTag);
            return isRightType;
        }, blockpos, 20, this.occupancy);
        List<class_2338> posList = stream.map(class_4156::method_19141).toList();
        List<class_2338> filteredPosList = posList.stream().filter(pos -> this.propertyPredicate.test((Object)level, pos, (Object)level.method_8320(pos))).toList();
        List<class_2338> sortedFilteredPosList = filteredPosList.stream().sorted(Comparator.comparingDouble(pos -> pos.method_10262((class_2382)blockpos))).toList();
        if (!sortedFilteredPosList.isEmpty()) {
            BrainUtils.setMemory(entity, this.memoryModuleType, Optional.of(sortedFilteredPosList.get(0)));
        }
    }

    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }
}

