/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.petshop.entity.ai;

import com.mojang.datafixers.util.Pair;
import com.nyfaria.petshop.entity.BasePet;
import com.nyfaria.petshop.init.MemoryModuleTypeInit;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class Sleep<T extends BasePet>
extends ExtendedBehaviour<T> {
    private static final List<Pair<class_4140<?>, class_4141>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of(MemoryModuleTypeInit.SLEEPING.get(), (Object)class_4141.field_18456), Pair.of(MemoryModuleTypeInit.DIG_POS.get(), (Object)class_4141.field_18457), Pair.of(MemoryModuleTypeInit.DIGGING.get(), (Object)class_4141.field_18457), Pair.of(MemoryModuleTypeInit.BOWL_POS.get(), (Object)class_4141.field_18457)});
    private String sleepAnimation = "sleep";
    private String sleepAnimation2 = "idle";
    private String controller = "move_controller";
    private String controller2 = "tail_controller";
    private String stopAnimation = "idle";

    public Sleep() {
        this.runFor(entity -> Integer.MAX_VALUE);
    }

    protected boolean checkExtraStartConditions(class_3218 level, T entity) {
        return level.method_23886() || level.field_9229.method_43048(100) < 10;
    }

    protected void start(class_3218 level, T entity, long gameTime) {
        super.method_18920(level, entity, gameTime);
        entity.triggerAnim(this.controller, this.sleepAnimation);
        entity.triggerAnim(this.controller2, this.sleepAnimation2);
    }

    protected boolean shouldKeepRunning(T entity) {
        return this.canStillSleep((class_3218)entity.method_37908(), entity);
    }

    private boolean canStillSleep(class_3218 level, T entity) {
        return level.method_23886() || entity.method_6051().method_43048(100) > 50;
    }

    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected void stop(class_3218 level, T entity, long gameTime) {
        super.method_18926(level, entity, gameTime);
        if (!BrainUtils.hasMemory(entity, MemoryModuleTypeInit.SLEEPING.get()) || !this.canStillSleep(level, entity)) {
            entity.triggerAnim(this.controller, this.stopAnimation);
            entity.triggerAnim(this.controller2, this.stopAnimation);
            BrainUtils.clearMemory((class_4095)entity.method_18868(), MemoryModuleTypeInit.SLEEPING.get());
            BrainUtils.clearMemory((class_4095)entity.method_18868(), MemoryModuleTypeInit.BED.get());
        }
    }

    protected Sleep<T> sleepAnimation(String digAnimation) {
        this.sleepAnimation = digAnimation;
        return this;
    }

    protected Sleep<T> controller(String controller) {
        this.controller = controller;
        return this;
    }

    protected Sleep<T> stopAnimation(String stopAnimation) {
        this.stopAnimation = stopAnimation;
        return this;
    }

    protected Sleep<T> sleepAnimation2(String digAnimation2) {
        this.sleepAnimation2 = digAnimation2;
        return this;
    }

    protected Sleep<T> controller2(String controller2) {
        this.controller2 = controller2;
        return this;
    }
}

