/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.petshop.init;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.nyfaria.petshop.entity.BaseBird;
import com.nyfaria.petshop.entity.BaseCat;
import com.nyfaria.petshop.entity.BaseDog;
import com.nyfaria.petshop.entity.BasePet;
import com.nyfaria.petshop.entity.ThrownBall;
import com.nyfaria.petshop.entity.data.Species;
import com.nyfaria.petshop.registration.RegistrationProvider;
import com.nyfaria.petshop.registration.RegistryObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_5132;
import net.minecraft.class_7924;

public class EntityInit {
    public static final Multimap<Species, Supplier<? extends class_1299<? extends class_1309>>> SPECIES_MAP = HashMultimap.create();
    public static final RegistrationProvider<class_1299<?>> ENTITIES = RegistrationProvider.get(class_7924.field_41266, "petshop");
    public static final List<AttributesRegister<?>> attributeSuppliers = new ArrayList();
    public static final RegistryObject<class_1299<BaseDog>> SHELTIE = EntityInit.registerEntity(Species.DOG, "sheltie", () -> class_1299.class_1300.method_5903(BaseDog::new, (class_1311)class_1311.field_6294).method_17687(0.4f, 0.6f), BasePet::createAttributes);
    public static final RegistryObject<class_1299<BaseDog>> SUPER_MUTT = EntityInit.registerEntity(Species.DOG, "super_mutt", () -> class_1299.class_1300.method_5903(BaseDog::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 0.8f), BasePet::createAttributes);
    public static final RegistryObject<class_1299<BaseDog>> SABLE_HUSKY = EntityInit.registerEntity(Species.DOG, "sable_husky", () -> class_1299.class_1300.method_5903(BaseDog::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 0.8f), BasePet::createAttributes);
    public static final RegistryObject<class_1299<BaseDog>> BLACK_AND_WHITE_HUSKY = EntityInit.registerEntity(Species.DOG, "black_and_white_husky", () -> class_1299.class_1300.method_5903(BaseDog::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 0.8f), BasePet::createAttributes);
    public static final RegistryObject<class_1299<BaseDog>> ENGLISH_COCKER_SPANIEL = EntityInit.registerEntity(Species.DOG, "english_cocker_spaniel", () -> class_1299.class_1300.method_5903(BaseDog::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 0.6f), BasePet::createAttributes);
    public static final RegistryObject<class_1299<BaseCat>> CALICO = EntityInit.registerEntity(Species.CAT, "calico", () -> class_1299.class_1300.method_5903(BaseCat::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 0.8f), BasePet::createAttributes);
    public static final RegistryObject<class_1299<BaseCat>> AMERICAN_SHORTHAIR = EntityInit.registerEntity(Species.CAT, "american_shorthair", () -> class_1299.class_1300.method_5903(BaseCat::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 0.8f), BasePet::createAttributes);
    public static final RegistryObject<class_1299<BaseCat>> BLACK_TUXEDO = EntityInit.registerEntity(Species.CAT, "black_tuxedo", () -> class_1299.class_1300.method_5903(BaseCat::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 0.8f), BasePet::createAttributes);
    public static final RegistryObject<class_1299<BaseCat>> BROWN_TUXEDO_MUNCHKIN = EntityInit.registerEntity(Species.CAT, "brown_tuxedo_munchkin", () -> class_1299.class_1300.method_5903(BaseCat::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 0.6f), BasePet::createAttributes);
    public static final RegistryObject<class_1299<BaseBird>> GOLD_DASHED_PARROT = EntityInit.registerEntity(Species.BIRD, "gold_dashed_parrot", () -> class_1299.class_1300.method_5903(BaseBird::new, (class_1311)class_1311.field_6294).method_17687(0.6f, 0.8f), BaseBird::createAttributes);
    public static final RegistryObject<class_1299<BaseBird>> WHITE_STRIPED_PARROT = EntityInit.registerEntity(Species.BIRD, "white_striped_parrot", () -> class_1299.class_1300.method_5903(BaseBird::new, (class_1311)class_1311.field_6294).method_17687(0.5f, 0.8f), BaseBird::createAttributes);
    public static final RegistryObject<class_1299<BaseBird>> RED_ACCENT_ALBINO_PARROT = EntityInit.registerEntity(Species.BIRD, "red_accent_albino_parrot", () -> class_1299.class_1300.method_5903(BaseBird::new, (class_1311)class_1311.field_6294).method_17687(0.5f, 0.8f), BaseBird::createAttributes);
    public static final RegistryObject<class_1299<BaseBird>> TROPICAL_PARROT = EntityInit.registerEntity(Species.BIRD, "tropical_parrot", () -> class_1299.class_1300.method_5903(BaseBird::new, (class_1311)class_1311.field_6294).method_17687(0.5f, 0.8f), BaseBird::createAttributes);
    public static final RegistryObject<class_1299<ThrownBall>> BALL = EntityInit.registerEntity("ball", () -> class_1299.class_1300.method_5903(ThrownBall::new, (class_1311)class_1311.field_17715).method_17687(0.25f, 0.25f));

    private static <T extends class_1297> RegistryObject<class_1299<T>> registerEntity(String name, Supplier<class_1299.class_1300<T>> supplier) {
        return ENTITIES.register(name, () -> ((class_1299.class_1300)supplier.get()).method_5905("petshop:" + name));
    }

    private static <T extends class_1309> RegistryObject<class_1299<T>> registerEntity(@Nullable Species species, String name, Supplier<class_1299.class_1300<T>> supplier, Supplier<class_5132.class_5133> attributeSupplier) {
        RegistryObject<class_1299<T>> entityTypeSupplier = EntityInit.registerEntity(name, supplier);
        attributeSuppliers.add(new AttributesRegister(entityTypeSupplier, attributeSupplier));
        if (species != null) {
            SPECIES_MAP.put((Object)species, entityTypeSupplier);
        }
        return entityTypeSupplier;
    }

    public static void loadClass() {
    }

    public record AttributesRegister<E extends class_1309>(Supplier<class_1299<E>> entityTypeSupplier, Supplier<class_5132.class_5133> factory) {
    }
}

