/*
 * Decompiled with CFR 0.152.
 */
package com.seacroak.plushables.block.tile;

import com.seacroak.plushables.registry.uncommon.TileRegistry;
import java.util.Arrays;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BasketBlockEntity
extends class_2586 {
    public static final int max_stack_size = 8;
    private final class_1799[] plushStack = new class_1799[8];
    private int top_pointer = 0;
    private int[] seeds = new int[8];

    public BasketBlockEntity(class_2338 pos, class_2680 state) {
        super(TileRegistry.BASKET_TILE, pos, state);
        class_5819 random = class_5819.method_43047();
        Arrays.fill(this.plushStack, class_1799.field_8037);
        for (int i = 0; i < 8; ++i) {
            this.seeds[i] = random.method_43048(100);
        }
        this.sync();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, BasketBlockEntity be) {
    }

    public boolean pushPlush(class_1657 player) {
        if (this.top_pointer == 8) {
            return false;
        }
        if (this.top_pointer == -1) {
            this.top_pointer = 0;
        }
        if (!this.plushStack[this.top_pointer].method_31574(class_1802.field_8162)) {
            ++this.top_pointer;
        }
        this.plushStack[this.top_pointer] = player.method_6118(class_1304.field_6173).method_46651(1);
        player.method_6118(class_1304.field_6173).method_7939(player.method_6118(class_1304.field_6173).method_7947() - 1);
        ++this.top_pointer;
        this.sync();
        return true;
    }

    public boolean popPlush(class_1657 player) {
        if (this.top_pointer == -1) {
            return false;
        }
        if (this.top_pointer == 8) {
            this.top_pointer = 7;
        }
        if (this.plushStack[this.top_pointer].method_31574(class_1802.field_8162) && this.top_pointer == 0) {
            return false;
        }
        if (this.plushStack[this.top_pointer].method_31574(class_1802.field_8162)) {
            --this.top_pointer;
        }
        player.method_7270(this.plushStack[this.top_pointer].method_46651(1));
        this.plushStack[this.top_pointer] = class_1799.field_8037;
        --this.top_pointer;
        this.sync();
        return true;
    }

    public class_1799[] popAll(class_1657 player) {
        class_1799[] poppedItems = Arrays.copyOf(this.plushStack, 8);
        Arrays.fill(this.plushStack, class_1799.field_8037);
        this.top_pointer = 0;
        this.sync();
        return poppedItems;
    }

    public class_1799[] getPlushStack() {
        return this.plushStack;
    }

    public int getTopPointer() {
        return this.top_pointer;
    }

    public int[] getSeeds() {
        return this.seeds;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_2499 plushNbtList = new class_2499();
        for (class_1799 plush : this.plushStack) {
            class_2487 itemNbt = new class_2487();
            plush.method_7953(itemNbt);
            plushNbtList.add((Object)itemNbt);
        }
        nbt.method_10566("plush_stack", (class_2520)plushNbtList);
        nbt.method_10569("top_pointer", this.top_pointer);
        nbt.method_10539("seeds", this.seeds);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_2499 nbtList = nbt.method_10554("plush_stack", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_1799 itemStack;
            class_2487 itemNbt = nbtList.method_10602(i);
            this.plushStack[i] = itemStack = class_1799.method_7915((class_2487)itemNbt);
        }
        this.top_pointer = nbt.method_10550("top_pointer");
        this.seeds = nbt.method_10561("seeds");
        this.sync();
    }

    public void sync() {
        this.method_5431();
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }
}

