/*
 * Decompiled with CFR 0.152.
 */
package com.seacroak.plushables.block.tile;

import com.seacroak.plushables.block.screen.BuilderInventory;
import com.seacroak.plushables.block.screen.BuilderScreenHandler;
import com.seacroak.plushables.networking.SoundPacketHandler;
import com.seacroak.plushables.recipe.BuilderRecipe;
import com.seacroak.plushables.registry.assets.SoundRegistry;
import com.seacroak.plushables.registry.uncommon.TileRegistry;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BuilderTileEntity
extends class_2586
implements GeoBlockEntity,
class_3908,
BuilderInventory {
    static class_5819 rand;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    protected final class_3913 propertyDelegate;
    private int progress = 0;
    private int maxProgress = 78;
    private final AnimatableInstanceCache instanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BuilderTileEntity(class_2338 pos, class_2680 state) {
        super(TileRegistry.BUILDER_TILE, pos, state);
        rand = new class_6575(100L);
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                switch (index) {
                    case 0: {
                        return BuilderTileEntity.this.progress;
                    }
                    case 1: {
                        return BuilderTileEntity.this.maxProgress;
                    }
                }
                return 0;
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        BuilderTileEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        BuilderTileEntity.this.maxProgress = value;
                    }
                }
            }

            public int method_17389() {
                return 2;
            }
        };
    }

    public class_2561 method_5476() {
        return this.method_11010().method_26204().method_9518();
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new BuilderScreenHandler(syncId, inv, this, this.propertyDelegate);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
    }

    public void method_11007(class_2487 nbt) {
        class_1262.method_5426((class_2487)nbt, this.inventory);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, BuilderTileEntity entity) {
        if (BuilderTileEntity.hasRecipe(entity)) {
            ++entity.progress;
            if (entity.progress > entity.maxProgress) {
                BuilderTileEntity.craftItem(entity);
            }
        } else {
            entity.resetProgress();
        }
    }

    private static boolean hasRecipe(BuilderTileEntity entity) {
        class_1937 world = entity.field_11863;
        class_1277 inventory = new class_1277(entity.inventory.size());
        for (int i = 0; i < entity.inventory.size(); ++i) {
            inventory.method_5447(i, entity.method_5438(i));
        }
        Optional match = world.method_8433().method_8132((class_3956)BuilderRecipe.Type.INSTANCE, (class_1263)inventory, world);
        return match.isPresent() && BuilderTileEntity.canInsertAmountIntoOutputSlot(inventory) && BuilderTileEntity.canInsertItemIntoOutputSlot(inventory, ((BuilderRecipe)match.get()).method_8110(entity.field_11863.method_30349()));
    }

    private static void craftItem(BuilderTileEntity entity) {
        class_1937 world = entity.field_11863;
        class_1277 inventory = new class_1277(entity.inventory.size());
        for (int i = 0; i < entity.inventory.size(); ++i) {
            inventory.method_5447(i, entity.method_5438(i));
        }
        Optional match = world.method_8433().method_8132((class_3956)BuilderRecipe.Type.INSTANCE, (class_1263)inventory, world);
        if (match.isPresent()) {
            entity.method_5434(0, 1);
            entity.method_5434(1, 1);
            entity.method_5434(2, 1);
            entity.method_5447(3, new class_1799((class_1935)((BuilderRecipe)match.get()).method_8110(entity.field_11863.method_30349()).method_7909(), entity.method_5438(3).method_7947() + 1));
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                SoundPacketHandler.sendNoPlayerPacketToClients(serverWorld, new SoundPacketHandler.NoPlayerSoundPacket(entity.method_11016(), SoundRegistry.BUILDER_DING, 1.0f));
                SoundPacketHandler.sendNoPlayerPacketToClients(serverWorld, new SoundPacketHandler.NoPlayerSoundPacket(entity.method_11016(), class_3417.field_28599, 1.0f));
            }
            entity.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static boolean canInsertItemIntoOutputSlot(class_1277 inventory, class_1799 output) {
        return inventory.method_5438(3).method_7909() == output.method_7909() || inventory.method_5438(3).method_7960();
    }

    private static boolean canInsertAmountIntoOutputSlot(class_1277 inventory) {
        return inventory.method_5438(3).method_7914() > inventory.method_5438(3).method_7947();
    }

    private <E extends class_2586> PlayState builderIdlePredicate(AnimationState<E> event) {
        AnimationController controller = event.getController();
        controller.setAnimation(RawAnimation.begin().thenPlay("animation.builder.idle"));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::builderIdlePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.instanceCache;
    }
}

