/*
 * Decompiled with CFR 0.152.
 */
package com.seacroak.plushables.networking;

import com.seacroak.plushables.block.tile.PoweredBlockEntity;
import com.seacroak.plushables.config.ClientConfigValues;
import com.seacroak.plushables.config.ConfigPacketHandler;
import com.seacroak.plushables.config.PlushablesConfig;
import com.seacroak.plushables.networking.AnimationPacketHandler;
import com.seacroak.plushables.networking.ParticlePacketHandler;
import com.seacroak.plushables.networking.SoundPacketHandler;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class PlushablesNetworking {
    public static void priorityConfig(boolean enableBaskets, boolean allowAllBlockItems) {
        ClientConfigValues.enable_baskets = enableBaskets;
        ClientConfigValues.allow_all_block_items_in_baskets = allowAllBlockItems;
    }

    public static void registerServersideClientJoinListener() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 joinedPlayer = handler.method_32311();
            ConfigPacketHandler.sendConfigPacketToClient(joinedPlayer, new ConfigPacketHandler.ConfigPacket(joinedPlayer.method_5667(), PlushablesConfig.enable_baskets, PlushablesConfig.allow_all_block_items_in_baskets));
        });
    }

    public static void playSoundOnClient(class_3414 sound, class_1937 world, class_2338 pos, float volume, float pitch) {
        try {
            class_243 vec = pos.method_46558();
            world.method_45446(class_2338.method_49638((class_2374)vec), sound, class_3419.field_15245, volume, pitch, true);
        }
        catch (Exception e) {
            System.out.println("Caught log-in animation exception");
        }
    }

    public static void spawnParticlesOnClient(class_2394 particleType, class_1937 world, class_2338 pos, int particleCount, class_243 offset, float spread) {
        try {
            class_243 vec = pos.method_46558();
            Random rand = new Random();
            for (int i = 0; i < particleCount; ++i) {
                if (spread == 0.0f) {
                    world.method_8406(particleType, vec.field_1352 + offset.field_1352, vec.field_1351 + offset.field_1351, vec.field_1350 + offset.field_1352, 0.0, 0.0, 0.0);
                }
                if (spread == 0.0f) continue;
                world.method_8406(particleType, vec.field_1352 + offset.field_1352, vec.field_1351 + offset.field_1351, vec.field_1350 + offset.field_1352, (double)rand.nextFloat(-spread, spread), (double)rand.nextFloat(-spread, spread), (double)rand.nextFloat(-spread, spread));
            }
        }
        catch (Exception e) {
            System.out.println("Caught log-in animation exception");
        }
    }

    public static void playAnimationOnClient(boolean shouldAnimate, class_1937 world, class_2338 pos, String animationName) {
        try {
            class_243 vec = pos.method_46558();
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof PoweredBlockEntity) {
                ((PoweredBlockEntity)blockEntity).animationName = animationName;
                ((PoweredBlockEntity)blockEntity).shouldAnimate = shouldAnimate;
            }
        }
        catch (Exception e) {
            System.out.println("Caught log-in animation exception");
        }
    }

    public static void registerGlobalSoundPacketReceiverWithPlayer() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SoundPacketHandler.PACKET_ID_PLAYER, (server, player, handler, buf, responseSender) -> {
            SoundPacketHandler.PlayerSoundPacket packet = SoundPacketHandler.PlayerSoundPacket.read(buf);
            if (packet.player == player.method_5667()) {
                return;
            }
            server.execute(() -> SoundPacketHandler.sendPlayerPacketToClients(player.method_51469(), packet));
        });
    }

    public static void registerGlobalSoundPacketReceiverWithoutPlayer() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SoundPacketHandler.PACKET_ID_NO_PLAYER, (server, player, handler, buf, responseSender) -> {
            SoundPacketHandler.NoPlayerSoundPacket packet = SoundPacketHandler.NoPlayerSoundPacket.read(buf);
            server.execute(() -> SoundPacketHandler.sendNoPlayerPacketToClients(player.method_51469(), packet));
        });
    }

    public static void registerGlobalParticlePacketReceiver() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ParticlePacketHandler.PACKET_ID, (server, player, handler, buf, responseSender) -> {
            ParticlePacketHandler.ParticlePacket packet = ParticlePacketHandler.ParticlePacket.read(buf);
            if (packet.player == player.method_5667()) {
                return;
            }
            server.execute(() -> ParticlePacketHandler.sendPacketToClients(player.method_51469(), packet));
        });
    }

    public static void registerGlobalAnimationPacketReceiver() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)AnimationPacketHandler.PACKET_ID, (server, player, handler, buf, responseSender) -> {
            AnimationPacketHandler.AnimationPacket packet = AnimationPacketHandler.AnimationPacket.read(buf);
            if (packet.player == player.method_5667()) {
                return;
            }
            server.execute(() -> AnimationPacketHandler.sendPacketToClients(player.method_51469(), packet));
        });
    }
}

