/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.source.builtin;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.calculation.Calculation;
import net.puffish.skillsmod.api.calculation.Variables;
import net.puffish.skillsmod.api.calculation.operation.OperationFactory;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.calculation.prototype.Prototype;
import net.puffish.skillsmod.api.experience.source.ExperienceSource;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceDisposeContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public class BreakBlockExperienceSource
implements ExperienceSource {
    private static final class_2960 ID = SkillsMod.createIdentifier("break_block");
    private static final Prototype<Data> PROTOTYPE = Prototype.create(ID);
    private final Calculation<Data> calculation;

    private BreakBlockExperienceSource(Calculation<Data> calculation) {
        this.calculation = calculation;
    }

    public static void register() {
        SkillsAPI.registerExperienceSource(ID, BreakBlockExperienceSource::parse);
    }

    private static Result<BreakBlockExperienceSource, Problem> parse(ExperienceSourceConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(rootObject -> rootObject.noUnused(o -> BreakBlockExperienceSource.parse(o, context)));
    }

    private static Result<BreakBlockExperienceSource, Problem> parse(JsonObject rootObject, ExperienceSourceConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Variables variables = rootObject.get("variables").getSuccess().flatMap(variablesElement -> Variables.parse(variablesElement, PROTOTYPE, context).ifFailure(problems::add).getSuccess()).orElseGet(() -> Variables.create(Map.of()));
        Optional optCalculation = rootObject.get("experience").andThen(experienceElement -> Calculation.parse(experienceElement, variables, context)).ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new BreakBlockExperienceSource((Calculation)optCalculation.orElseThrow()));
        }
        return Result.failure(Problem.combine(problems));
    }

    public int getValue(class_3222 player, class_2680 blockState, class_1799 tool) {
        return (int)Math.round(this.calculation.evaluate(new Data(player, blockState, tool)));
    }

    @Override
    public void dispose(ExperienceSourceDisposeContext context) {
    }

    static {
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_player"), BuiltinPrototypes.PLAYER, OperationFactory.create(Data::player));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_broken_block_state"), BuiltinPrototypes.BLOCK_STATE, OperationFactory.create(Data::blockState));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("get_tool_item_stack"), BuiltinPrototypes.ITEM_STACK, OperationFactory.create(Data::tool));
    }

    private record Data(class_3222 player, class_2680 blockState, class_1799 tool) {
    }
}

