/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsoriginsmod.skills;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.reward.Reward;
import net.puffish.skillsmod.api.reward.RewardConfigContext;
import net.puffish.skillsmod.api.reward.RewardDisposeContext;
import net.puffish.skillsmod.api.reward.RewardUpdateContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsoriginsmod.SkillsOriginsMod;
import net.puffish.skillsoriginsmod.util.PowerRewardOperation;
import org.apache.commons.lang3.RandomStringUtils;

public class PowerReward
implements Reward {
    public static final class_2960 ID = SkillsOriginsMod.createIdentifier("power");
    private final PowerType<?> powerType;
    private final PowerRewardOperation operation;
    private final class_2960 source;

    private PowerReward(PowerType<?> powerType, PowerRewardOperation operation, class_2960 source) {
        this.powerType = powerType;
        this.operation = operation;
        this.source = source;
    }

    public static void register() {
        SkillsAPI.registerReward((class_2960)ID, PowerReward::parse);
    }

    private static Result<PowerReward, Problem> parse(RewardConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(rootObject -> rootObject.noUnused(PowerReward::parse));
    }

    private static Result<PowerReward, Problem> parse(JsonObject rootObject) {
        ArrayList problems = new ArrayList();
        Optional optPower = rootObject.get("power").andThen(PowerReward::parsePowerType).ifFailure(problems::add).getSuccess();
        PowerRewardOperation operation = rootObject.get("operation").getSuccess().flatMap(element -> PowerRewardOperation.parse(element).ifFailure(problems::add).getSuccess()).orElse(PowerRewardOperation.ADD);
        if (problems.isEmpty()) {
            return Result.success((Object)new PowerReward((PowerType)optPower.orElseThrow(), operation, SkillsOriginsMod.createIdentifier(RandomStringUtils.random((int)16, (String)"abcdefghijklmnopqrstuvwxyz0123456789"))));
        }
        return Result.failure((Object)Problem.combine(problems));
    }

    private static Result<PowerType<?>, Problem> parsePowerType(JsonElement element) {
        return BuiltinJson.parseIdentifier((JsonElement)element).mapFailure(problem -> element.getPath().createProblem("Expected power type")).andThen(id -> {
            try {
                return Result.success((Object)PowerTypeRegistry.get((class_2960)id));
            }
            catch (Exception ignored) {
                return Result.failure((Object)element.getPath().createProblem("Unknown power type `" + id + "`"));
            }
        });
    }

    public void update(RewardUpdateContext context) {
        if (context.getCount() > 0) {
            this.unlock(context.getPlayer());
        } else {
            this.lock(context.getPlayer());
        }
    }

    public void dispose(RewardDisposeContext context) {
        context.getServer().method_3760().method_14571().forEach(this::lock);
    }

    private void unlock(class_3222 player) {
        PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)player);
        switch (this.operation) {
            case ADD: {
                component.addPower(this.powerType, this.source);
                break;
            }
            case REMOVE: {
                component.removePower(this.powerType, this.source);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        component.sync();
    }

    private void lock(class_3222 player) {
        PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)player);
        switch (this.operation) {
            case ADD: {
                component.removePower(this.powerType, this.source);
                break;
            }
            case REMOVE: {
                component.addPower(this.powerType, this.source);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        component.sync();
    }
}

