/*
 * Decompiled with CFR 0.152.
 */
package vilantious.pvptoggle.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3532;
import vilantious.pvptoggle.config.PvPToggleConfig;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_FILE_PATH = FabricLoader.getInstance().getConfigDir().resolve("pvptoggle-config.json");
    private static PvPToggleConfig instance;

    public static PvPToggleConfig getInstance() {
        if (instance == null) {
            ConfigManager.load();
        }
        return instance;
    }

    public static PvPToggleConfig createDefault() {
        return new PvPToggleConfig();
    }

    public static void load() {
        try {
            if (!CONFIG_FILE_PATH.toFile().exists()) {
                PvPToggleConfig pvpConfig = ConfigManager.createDefault();
                String newJson = GSON.toJson((Object)pvpConfig);
                Files.writeString(CONFIG_FILE_PATH, (CharSequence)newJson, StandardOpenOption.CREATE_NEW);
            }
            String json = Files.readString(CONFIG_FILE_PATH);
            PvPToggleConfig pvpConfig = (PvPToggleConfig)GSON.fromJson(json, PvPToggleConfig.class);
            pvpConfig.toggleCooldown = class_3532.method_15363((float)pvpConfig.toggleCooldown, (float)0.0f, (float)9999.9f);
            pvpConfig.combatFlagDuration = class_3532.method_15363((float)pvpConfig.combatFlagDuration, (float)0.0f, (float)9999.9f);
            instance = pvpConfig;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load or create PvPToggleConfig", e);
        }
    }
}

