/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.FurnitureBlock;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_6862;

public class TrampolineBlock
extends FurnitureBlock
implements BlockTagSupplier {
    public static final class_2754<Shape> SHAPE = class_2754.method_11850((String)"shape", Shape.class);
    private final class_1767 color;

    public TrampolineBlock(class_1767 color, class_4970.class_2251 properties) {
        super(properties);
        this.color = color;
    }

    public class_1767 getDyeColor() {
        return this.color;
    }

    @Override
    protected Map<class_2680, class_265> generateShapes(ImmutableList<class_2680> states) {
        class_265 topShape = class_2248.method_9541((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
        class_265 bottomLeftSupportShortShape = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)2.0, (double)15.0);
        class_265 bottomLeftSupportLongShape = class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)2.0, (double)16.0);
        class_265 bottomLeftSupportNorthShape = class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)2.0, (double)15.0);
        class_265 bottomLeftSupportSouthShape = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)2.0, (double)16.0);
        class_265 backLeftLegShape = class_2248.method_9541((double)1.0, (double)2.0, (double)1.0, (double)3.0, (double)10.0, (double)3.0);
        class_265 frontLeftLegShape = class_2248.method_9541((double)1.0, (double)2.0, (double)13.0, (double)3.0, (double)10.0, (double)15.0);
        class_265 bottomRightSupportShortShape = class_2248.method_9541((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        class_265 bottomRightSupportLongShape = class_2248.method_9541((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)16.0);
        class_265 bottomRightSupportNorthShape = class_2248.method_9541((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)15.0);
        class_265 bottomRightSupportSouthShape = class_2248.method_9541((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)16.0);
        class_265 frontRightLegShape = class_2248.method_9541((double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)10.0, (double)15.0);
        class_265 backRightLegShape = class_2248.method_9541((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)10.0, (double)3.0);
        class_265 northWestCornerSupportShape = class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)2.0, (double)3.0);
        class_265 northEastCornerSupportShape = class_2248.method_9541((double)13.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)3.0);
        class_265 southEastCornerSupportShape = class_2248.method_9541((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)2.0, (double)16.0);
        class_265 southWestCornerSupportShape = class_2248.method_9541((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)2.0, (double)16.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, o -> topShape)));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 getter, class_2338 pos, class_3726 context) {
        return (class_265)this.shapes.get(state);
    }

    public class_2680 method_9605(class_1750 context) {
        return this.getTrampolineState(this.method_9564(), (class_1936)context.method_8045(), context.method_8037());
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 level, class_2338 pos, class_2338 newPos) {
        return this.getTrampolineState(state, level, pos);
    }

    private class_2680 getTrampolineState(class_2680 state, class_1936 level, class_2338 pos) {
        boolean connectedNorth = this.isTrampoline(level, pos.method_10095());
        boolean connectedEast = this.isTrampoline(level, pos.method_10078());
        boolean connectedSouth = this.isTrampoline(level, pos.method_10072());
        boolean connectedWest = this.isTrampoline(level, pos.method_10067());
        boolean legNorthWest = connectedNorth && connectedWest && !this.isTrampoline(level, pos.method_10095().method_10067());
        boolean legNorthEast = connectedNorth && connectedEast && !this.isTrampoline(level, pos.method_10095().method_10078());
        boolean legSouthEast = connectedSouth && connectedEast && !this.isTrampoline(level, pos.method_10072().method_10078());
        boolean legSouthWest = connectedSouth && connectedWest && !this.isTrampoline(level, pos.method_10072().method_10067());
        int packedValue = Shape.createPackedValue(connectedNorth, connectedEast, connectedSouth, connectedWest, legNorthWest, legNorthEast, legSouthEast, legSouthWest);
        Shape shape = Shape.fromPackedValue(packedValue);
        return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)shape));
    }

    private boolean isTrampoline(class_1936 level, class_2338 pos) {
        return level.method_8320(pos).method_26204() instanceof TrampolineBlock;
    }

    public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (entity.method_21750()) {
            return;
        }
        class_243 movement = entity.method_18798();
        if (movement.field_1351 > 0.0) {
            return;
        }
        float bounceForce = 2.0f;
        float maxBounceHeight = ((Double)Config.SERVER.trampoline.maxBounceHeight.get()).floatValue() * ((Shape)((Object)state.method_11654(TrampolineBlock.SHAPE))).bounceScale * 0.75f;
        float bounceHeight = Math.min(entity.field_6017 * bounceForce, maxBounceHeight - 0.25f);
        entity.method_18799(entity.method_18798().method_18805(1.5, 0.0, 1.5));
        entity.method_5762(0.0, Math.sqrt(0.22 * (double)(bounceHeight + 0.25f)), 0.0);
        entity.method_38785();
        this.spawnBounceParticle(level, entity, pos, false);
        if (!level.method_8608()) {
            level.method_8396(null, pos, (class_3414)ModSounds.BLOCK_TRAMPOLINE_BOUNCE.get(), class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.2f + 0.9f);
        }
    }

    public void method_9502(class_1922 getter, class_1297 entity) {
        class_243 velocity = entity.method_18798();
        if (velocity.field_1351 < 0.0) {
            if (entity instanceof class_1690) {
                class_1690 boat = (class_1690)entity;
                if (-velocity.field_1351 > 0.1) {
                    this.bounceBoat(boat, velocity);
                    return;
                }
            }
            super.method_9502(getter, entity);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{SHAPE});
    }

    @Override
    public List<class_6862<class_2248>> getTags() {
        return List.of(class_3481.field_33715, class_3481.field_33719);
    }

    public float getJumpModifier(class_1937 level, class_2680 state, class_2338 pos) {
        Shape shape = (Shape)((Object)state.method_11654(SHAPE));
        float bounceHeight = ((Double)Config.SERVER.trampoline.maxBounceHeight.get()).floatValue() * shape.bounceScale;
        return class_3532.method_15355((float)(0.22f * bounceHeight)) * 2.3f;
    }

    public void onLivingEntityJump(class_1309 entity, class_1937 level, class_2680 state, class_2338 pos) {
        if (level.method_8608()) {
            level.method_45446(pos, (class_3414)ModSounds.BLOCK_TRAMPOLINE_SUPER_BOUNCE.get(), class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.1f + 0.75f, false);
            this.spawnBounceParticle(level, (class_1297)entity, pos, true);
        }
    }

    private void spawnBounceParticle(class_1937 level, class_1297 bouncingEntity, class_2338 pos, boolean superBounce) {
        if (!level.method_8608()) {
            if (!(bouncingEntity instanceof class_1657) && bouncingEntity instanceof class_1309) {
                class_2394 particle = superBounce ? (class_2394)ModParticleTypes.SUPER_BOUNCE.get() : (class_2394)ModParticleTypes.BOUNCE.get();
                class_243 particlePos = class_243.method_26410((class_2382)pos, (double)0.82);
                ((class_3218)level).method_14199(particle, bouncingEntity.field_6014, particlePos.field_1351, bouncingEntity.field_5969, 0, 0.0, 0.0, 0.0, 0.0);
            }
            return;
        }
        class_2394 particle = superBounce ? (class_2394)ModParticleTypes.SUPER_BOUNCE.get() : (class_2394)ModParticleTypes.BOUNCE.get();
        class_243 particlePos = class_243.method_26410((class_2382)pos, (double)0.82);
        level.method_8406(particle, bouncingEntity.field_6014, particlePos.field_1351, bouncingEntity.field_5969, 0.0, 0.0, 0.0);
    }

    private void bounceBoat(class_1690 boat, class_243 velocity) {
        class_1937 level = boat.method_37908();
        boat.method_18800(velocity.field_1352, -velocity.field_1351, velocity.field_1350);
        if (boat.method_5787() && !boat.method_6034()) {
            level.method_45446(boat.method_24515(), (class_3414)ModSounds.BLOCK_TRAMPOLINE_BOUNCE.get(), class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.2f + 0.9f, false);
        } else {
            level.method_8396(null, boat.method_24515(), (class_3414)ModSounds.BLOCK_TRAMPOLINE_BOUNCE.get(), class_3419.field_15245, 1.0f, level.field_9229.method_43057() * 0.2f + 0.9f);
        }
    }

    public static enum Shape implements class_3542
    {
        DEFAULT("default", 0.4f),
        NORTH("north", 0.4f),
        EAST("east", 0.4f),
        SOUTH("south", 0.4f),
        WEST("west", 0.4f),
        NORTH_SOUTH("north_south", 0.4f),
        EAST_WEST("east_west", 0.4f),
        NORTH_EAST("north_east", 0.8f),
        EAST_SOUTH("east_south", 0.8f),
        SOUTH_WEST("south_west", 0.8f),
        WEST_NORTH("west_north", 0.8f),
        NORTH_EAST_WITH_LEG("north_east_with_leg_northeast", 0.4f),
        EAST_SOUTH_WITH_LEG("east_south_with_leg_eastsouth", 0.4f),
        SOUTH_WEST_WITH_LEG("south_west_with_leg_southwest", 0.4f),
        WEST_NORTH_WITH_LEG("west_north_with_leg_westnorth", 0.4f),
        NORTH_EAST_SOUTH("north_east_south", 0.8f),
        EAST_SOUTH_WEST("east_south_west", 0.8f),
        SOUTH_WEST_NORTH("south_west_north", 0.8f),
        WEST_NORTH_EAST("west_north_east", 0.8f),
        NORTH_EAST_SOUTH_WITH_LEG_NORTHEAST("north_east_south_with_leg_northeast", 0.8f),
        NORTH_EAST_SOUTH_WITH_LEG_EASTSOUTH("north_east_south_with_leg_eastsouth", 0.8f),
        NORTH_EAST_SOUTH_WITH_LEG_NORTHEAST_EASTSOUTH("north_east_south_with_leg_northeast_eastsouth", 0.4f),
        EAST_SOUTH_WEST_WITH_LEG_EASTSOUTH("east_south_west_with_leg_eastsouth", 0.8f),
        EAST_SOUTH_WEST_WITH_LEG_SOUTHWEST("east_south_west_with_leg_southwest", 0.8f),
        EAST_SOUTH_WEST_WITH_LEG_EASTSOUTH_SOUTHWEST("east_south_west_with_leg_eastsouth_southwest", 0.4f),
        SOUTH_WEST_NORTH_WITH_LEG_WESTNORTH("south_west_north_with_leg_westnorth", 0.8f),
        SOUTH_WEST_NORTH_WITH_LEG_SOUTHWEST("south_west_north_with_leg_southwest", 0.8f),
        SOUTH_WEST_NORTH_WITH_LEG_WESTNORTH_SOUTHWEST("south_west_north_with_leg_westnorth_southwest", 0.4f),
        WEST_NORTH_EAST_WITH_LEG_NORTHEAST("west_north_east_with_leg_northeast", 0.8f),
        WEST_NORTH_EAST_WITH_LEG_WESTNORTH("west_north_east_with_leg_westnorth", 0.8f),
        WEST_NORTH_EAST_WITH_LEG_NORTHEAST_WESTNORTH("west_north_east_with_leg_northeast_westnorth", 0.4f),
        ALL("north_east_south_west", 1.0f),
        ALL_WITH_LEG_ALL("north_east_south_west_with_leg_northeast_eastsouth_southwest_westnorth", 0.4f),
        ALL_WITH_LEG_NORTHEAST("north_east_south_west_with_leg_northeast", 0.8f),
        ALL_WITH_LEG_NORTHEAST_EASTSOUTH("north_east_south_west_with_leg_northeast_eastsouth", 0.8f),
        ALL_WITH_LEG_NORTHEAST_EASTSOUTH_SOUTHWEST("north_east_south_west_with_leg_northeast_eastsouth_southwest", 0.8f),
        ALL_WITH_LEG_EASTSOUTH("north_east_south_west_with_leg_eastsouth", 0.8f),
        ALL_WITH_LEG_EASTSOUTH_SOUTHWEST("north_east_south_west_with_leg_eastsouth_southwest", 0.8f),
        ALL_WITH_LEG_EASTSOUTH_SOUTHWEST_WESTNORTH("north_east_south_west_with_leg_eastsouth_southwest_westnorth", 0.8f),
        ALL_WITH_LEG_SOUTHWEST("north_east_south_west_with_leg_southwest", 0.8f),
        ALL_WITH_LEG_SOUTHWEST_WESTNORTH("north_east_south_west_with_leg_southwest_westnorth", 0.8f),
        ALL_WITH_LEG_SOUTHWEST_WESTNORTH_NORTHEAST("north_east_south_west_with_leg_southwest_westnorth_northeast", 0.8f),
        ALL_WITH_LEG_WESTNORTH("north_east_south_west_with_leg_westnorth", 0.8f),
        ALL_WITH_LEG_WESTNORTH_NORTHEAST("north_east_south_west_with_leg_westnorth_northeast", 0.8f),
        ALL_WITH_LEG_WESTNORTH_NORTHEAST_EASTSOUTH("north_east_south_west_with_leg_westnorth_northeast_eastsouth", 0.8f),
        ALL_WITH_LEG_NORTHEAST_SOUTHWEST("north_east_south_west_with_leg_northeast_southwest", 0.8f),
        ALL_WITH_LEG_EASTSOUTH_WESTNORTH("north_east_south_west_with_leg_eastsouth_westnorth", 0.8f);

        public static final Map<Integer, Shape> PACKED_VALUE_TO_SHAPE;
        private final String name;
        private final int packedValue;
        private final float bounceScale;

        private Shape(String name, float bounceScale) {
            this.name = name;
            this.packedValue = Shape.createPackedValue(name);
            this.bounceScale = bounceScale;
        }

        public String method_15434() {
            return this.name;
        }

        public static Shape fromPackedValue(int packedValue) {
            return PACKED_VALUE_TO_SHAPE.getOrDefault(packedValue, DEFAULT);
        }

        private static int createPackedValue(String name) {
            List<String> values = Arrays.asList(name.split("_"));
            boolean north = values.contains("north");
            boolean east = values.contains("east");
            boolean south = values.contains("south");
            boolean west = values.contains("west");
            boolean lnw = values.contains("westnorth");
            boolean lne = values.contains("northeast");
            boolean lse = values.contains("eastsouth");
            boolean lsw = values.contains("southwest");
            return Shape.createPackedValue(north, east, south, west, lnw, lne, lse, lsw);
        }

        public static int createPackedValue(boolean n, boolean e, boolean s, boolean w, boolean cnw, boolean cne, boolean cse, boolean csw) {
            boolean[] states = new boolean[]{n, e, s, w, cnw, cne, cse, csw};
            int value = 0;
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                value |= 1 << i;
            }
            return value;
        }

        static {
            PACKED_VALUE_TO_SHAPE = Arrays.stream(Shape.values()).collect(Collectors.toMap(shape -> shape.packedValue, shape -> shape));
        }
    }
}

